/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.clouddirectory.model.GetSchemaAsJsonRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetSchemaAsJsonRequestMarshaller
implements Marshaller<Request<GetSchemaAsJsonRequest>, GetSchemaAsJsonRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetSchemaAsJsonRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetSchemaAsJsonRequest> marshall(GetSchemaAsJsonRequest getSchemaAsJsonRequest) {
        if (getSchemaAsJsonRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetSchemaAsJsonRequest> request = new DefaultRequest<GetSchemaAsJsonRequest>(getSchemaAsJsonRequest, "AmazonCloudDirectory");
        request.setHttpMethod(HttpMethodName.POST);
        if (getSchemaAsJsonRequest.getSchemaArn() != null) {
            request.addHeader("x-amz-data-partition", StringUtils.fromString(getSchemaAsJsonRequest.getSchemaArn()));
        }
        String uriResourcePath = "/amazonclouddirectory/2017-01-11/schema/json";
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

