/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.CreateFacetRequest;
import com.amazonaws.services.clouddirectory.model.FacetAttribute;
import com.amazonaws.services.clouddirectory.model.transform.FacetAttributeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.util.List;

public class CreateFacetRequestMarshaller
implements Marshaller<Request<CreateFacetRequest>, CreateFacetRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateFacetRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateFacetRequest> marshall(CreateFacetRequest createFacetRequest) {
        if (createFacetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateFacetRequest> request = new DefaultRequest<CreateFacetRequest>(createFacetRequest, "AmazonCloudDirectory");
        request.setHttpMethod(HttpMethodName.PUT);
        if (createFacetRequest.getSchemaArn() != null) {
            request.addHeader("x-amz-data-partition", StringUtils.fromString(createFacetRequest.getSchemaArn()));
        }
        String uriResourcePath = "/amazonclouddirectory/2017-01-11/facet/create";
        request.setResourcePath(uriResourcePath);
        try {
            List<FacetAttribute> attributesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createFacetRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(createFacetRequest.getName());
            }
            if ((attributesList = createFacetRequest.getAttributes()) != null) {
                jsonGenerator.writeFieldName("Attributes");
                jsonGenerator.writeStartArray();
                for (FacetAttribute attributesListValue : attributesList) {
                    if (attributesListValue == null) continue;
                    FacetAttributeJsonMarshaller.getInstance().marshall(attributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (createFacetRequest.getObjectType() != null) {
                jsonGenerator.writeFieldName("ObjectType").writeValue(createFacetRequest.getObjectType());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

