/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.BatchWriteOperation;
import com.amazonaws.services.clouddirectory.model.BatchWriteRequest;
import com.amazonaws.services.clouddirectory.model.transform.BatchWriteOperationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.util.List;

public class BatchWriteRequestMarshaller
implements Marshaller<Request<BatchWriteRequest>, BatchWriteRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public BatchWriteRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<BatchWriteRequest> marshall(BatchWriteRequest batchWriteRequest) {
        if (batchWriteRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BatchWriteRequest> request = new DefaultRequest<BatchWriteRequest>(batchWriteRequest, "AmazonCloudDirectory");
        request.setHttpMethod(HttpMethodName.PUT);
        if (batchWriteRequest.getDirectoryArn() != null) {
            request.addHeader("x-amz-data-partition", StringUtils.fromString(batchWriteRequest.getDirectoryArn()));
        }
        String uriResourcePath = "/amazonclouddirectory/2017-01-11/batchwrite";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<BatchWriteOperation> operationsList = batchWriteRequest.getOperations();
            if (operationsList != null) {
                jsonGenerator.writeFieldName("Operations");
                jsonGenerator.writeStartArray();
                for (BatchWriteOperation operationsListValue : operationsList) {
                    if (operationsListValue == null) continue;
                    BatchWriteOperationJsonMarshaller.getInstance().marshall(operationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

