/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.budgets.model.UpdateNotificationRequest;
import com.amazonaws.services.budgets.model.transform.NotificationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class UpdateNotificationRequestMarshaller
implements Marshaller<Request<UpdateNotificationRequest>, UpdateNotificationRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public UpdateNotificationRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateNotificationRequest> marshall(UpdateNotificationRequest updateNotificationRequest) {
        if (updateNotificationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateNotificationRequest> request = new DefaultRequest<UpdateNotificationRequest>(updateNotificationRequest, "AWSBudgets");
        request.addHeader("X-Amz-Target", "AWSBudgetServiceGateway.UpdateNotification");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateNotificationRequest.getAccountId() != null) {
                jsonGenerator.writeFieldName("AccountId").writeValue(updateNotificationRequest.getAccountId());
            }
            if (updateNotificationRequest.getBudgetName() != null) {
                jsonGenerator.writeFieldName("BudgetName").writeValue(updateNotificationRequest.getBudgetName());
            }
            if (updateNotificationRequest.getOldNotification() != null) {
                jsonGenerator.writeFieldName("OldNotification");
                NotificationJsonMarshaller.getInstance().marshall(updateNotificationRequest.getOldNotification(), jsonGenerator);
            }
            if (updateNotificationRequest.getNewNotification() != null) {
                jsonGenerator.writeFieldName("NewNotification");
                NotificationJsonMarshaller.getInstance().marshall(updateNotificationRequest.getNewNotification(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

