/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.batch.AWSBatchAsync;
import com.amazonaws.services.batch.AWSBatchClient;
import com.amazonaws.services.batch.model.CancelJobRequest;
import com.amazonaws.services.batch.model.CancelJobResult;
import com.amazonaws.services.batch.model.CreateComputeEnvironmentRequest;
import com.amazonaws.services.batch.model.CreateComputeEnvironmentResult;
import com.amazonaws.services.batch.model.CreateJobQueueRequest;
import com.amazonaws.services.batch.model.CreateJobQueueResult;
import com.amazonaws.services.batch.model.DeleteComputeEnvironmentRequest;
import com.amazonaws.services.batch.model.DeleteComputeEnvironmentResult;
import com.amazonaws.services.batch.model.DeleteJobQueueRequest;
import com.amazonaws.services.batch.model.DeleteJobQueueResult;
import com.amazonaws.services.batch.model.DeregisterJobDefinitionRequest;
import com.amazonaws.services.batch.model.DeregisterJobDefinitionResult;
import com.amazonaws.services.batch.model.DescribeComputeEnvironmentsRequest;
import com.amazonaws.services.batch.model.DescribeComputeEnvironmentsResult;
import com.amazonaws.services.batch.model.DescribeJobDefinitionsRequest;
import com.amazonaws.services.batch.model.DescribeJobDefinitionsResult;
import com.amazonaws.services.batch.model.DescribeJobQueuesRequest;
import com.amazonaws.services.batch.model.DescribeJobQueuesResult;
import com.amazonaws.services.batch.model.DescribeJobsRequest;
import com.amazonaws.services.batch.model.DescribeJobsResult;
import com.amazonaws.services.batch.model.ListJobsRequest;
import com.amazonaws.services.batch.model.ListJobsResult;
import com.amazonaws.services.batch.model.RegisterJobDefinitionRequest;
import com.amazonaws.services.batch.model.RegisterJobDefinitionResult;
import com.amazonaws.services.batch.model.SubmitJobRequest;
import com.amazonaws.services.batch.model.SubmitJobResult;
import com.amazonaws.services.batch.model.TerminateJobRequest;
import com.amazonaws.services.batch.model.TerminateJobResult;
import com.amazonaws.services.batch.model.UpdateComputeEnvironmentRequest;
import com.amazonaws.services.batch.model.UpdateComputeEnvironmentResult;
import com.amazonaws.services.batch.model.UpdateJobQueueRequest;
import com.amazonaws.services.batch.model.UpdateJobQueueResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSBatchAsyncClient
extends AWSBatchClient
implements AWSBatchAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSBatchAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSBatchAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSBatchAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSBatchAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSBatchAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSBatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSBatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSBatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSBatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AWSBatchAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelJobResult> cancelJobAsync(CancelJobRequest request) {
        return this.cancelJobAsync(request, null);
    }

    @Override
    public Future<CancelJobResult> cancelJobAsync(final CancelJobRequest request, final AsyncHandler<CancelJobRequest, CancelJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<CancelJobResult>(){

            @Override
            public CancelJobResult call() throws Exception {
                CancelJobResult result;
                try {
                    result = AWSBatchAsyncClient.this.cancelJob(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateComputeEnvironmentResult> createComputeEnvironmentAsync(CreateComputeEnvironmentRequest request) {
        return this.createComputeEnvironmentAsync(request, null);
    }

    @Override
    public Future<CreateComputeEnvironmentResult> createComputeEnvironmentAsync(final CreateComputeEnvironmentRequest request, final AsyncHandler<CreateComputeEnvironmentRequest, CreateComputeEnvironmentResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateComputeEnvironmentResult>(){

            @Override
            public CreateComputeEnvironmentResult call() throws Exception {
                CreateComputeEnvironmentResult result;
                try {
                    result = AWSBatchAsyncClient.this.createComputeEnvironment(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateJobQueueResult> createJobQueueAsync(CreateJobQueueRequest request) {
        return this.createJobQueueAsync(request, null);
    }

    @Override
    public Future<CreateJobQueueResult> createJobQueueAsync(final CreateJobQueueRequest request, final AsyncHandler<CreateJobQueueRequest, CreateJobQueueResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateJobQueueResult>(){

            @Override
            public CreateJobQueueResult call() throws Exception {
                CreateJobQueueResult result;
                try {
                    result = AWSBatchAsyncClient.this.createJobQueue(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteComputeEnvironmentResult> deleteComputeEnvironmentAsync(DeleteComputeEnvironmentRequest request) {
        return this.deleteComputeEnvironmentAsync(request, null);
    }

    @Override
    public Future<DeleteComputeEnvironmentResult> deleteComputeEnvironmentAsync(final DeleteComputeEnvironmentRequest request, final AsyncHandler<DeleteComputeEnvironmentRequest, DeleteComputeEnvironmentResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteComputeEnvironmentResult>(){

            @Override
            public DeleteComputeEnvironmentResult call() throws Exception {
                DeleteComputeEnvironmentResult result;
                try {
                    result = AWSBatchAsyncClient.this.deleteComputeEnvironment(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteJobQueueResult> deleteJobQueueAsync(DeleteJobQueueRequest request) {
        return this.deleteJobQueueAsync(request, null);
    }

    @Override
    public Future<DeleteJobQueueResult> deleteJobQueueAsync(final DeleteJobQueueRequest request, final AsyncHandler<DeleteJobQueueRequest, DeleteJobQueueResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteJobQueueResult>(){

            @Override
            public DeleteJobQueueResult call() throws Exception {
                DeleteJobQueueResult result;
                try {
                    result = AWSBatchAsyncClient.this.deleteJobQueue(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeregisterJobDefinitionResult> deregisterJobDefinitionAsync(DeregisterJobDefinitionRequest request) {
        return this.deregisterJobDefinitionAsync(request, null);
    }

    @Override
    public Future<DeregisterJobDefinitionResult> deregisterJobDefinitionAsync(final DeregisterJobDefinitionRequest request, final AsyncHandler<DeregisterJobDefinitionRequest, DeregisterJobDefinitionResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeregisterJobDefinitionResult>(){

            @Override
            public DeregisterJobDefinitionResult call() throws Exception {
                DeregisterJobDefinitionResult result;
                try {
                    result = AWSBatchAsyncClient.this.deregisterJobDefinition(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeComputeEnvironmentsResult> describeComputeEnvironmentsAsync(DescribeComputeEnvironmentsRequest request) {
        return this.describeComputeEnvironmentsAsync(request, null);
    }

    @Override
    public Future<DescribeComputeEnvironmentsResult> describeComputeEnvironmentsAsync(final DescribeComputeEnvironmentsRequest request, final AsyncHandler<DescribeComputeEnvironmentsRequest, DescribeComputeEnvironmentsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeComputeEnvironmentsResult>(){

            @Override
            public DescribeComputeEnvironmentsResult call() throws Exception {
                DescribeComputeEnvironmentsResult result;
                try {
                    result = AWSBatchAsyncClient.this.describeComputeEnvironments(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeJobDefinitionsResult> describeJobDefinitionsAsync(DescribeJobDefinitionsRequest request) {
        return this.describeJobDefinitionsAsync(request, null);
    }

    @Override
    public Future<DescribeJobDefinitionsResult> describeJobDefinitionsAsync(final DescribeJobDefinitionsRequest request, final AsyncHandler<DescribeJobDefinitionsRequest, DescribeJobDefinitionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeJobDefinitionsResult>(){

            @Override
            public DescribeJobDefinitionsResult call() throws Exception {
                DescribeJobDefinitionsResult result;
                try {
                    result = AWSBatchAsyncClient.this.describeJobDefinitions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeJobQueuesResult> describeJobQueuesAsync(DescribeJobQueuesRequest request) {
        return this.describeJobQueuesAsync(request, null);
    }

    @Override
    public Future<DescribeJobQueuesResult> describeJobQueuesAsync(final DescribeJobQueuesRequest request, final AsyncHandler<DescribeJobQueuesRequest, DescribeJobQueuesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeJobQueuesResult>(){

            @Override
            public DescribeJobQueuesResult call() throws Exception {
                DescribeJobQueuesResult result;
                try {
                    result = AWSBatchAsyncClient.this.describeJobQueues(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeJobsResult> describeJobsAsync(DescribeJobsRequest request) {
        return this.describeJobsAsync(request, null);
    }

    @Override
    public Future<DescribeJobsResult> describeJobsAsync(final DescribeJobsRequest request, final AsyncHandler<DescribeJobsRequest, DescribeJobsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeJobsResult>(){

            @Override
            public DescribeJobsResult call() throws Exception {
                DescribeJobsResult result;
                try {
                    result = AWSBatchAsyncClient.this.describeJobs(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(ListJobsRequest request) {
        return this.listJobsAsync(request, null);
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(final ListJobsRequest request, final AsyncHandler<ListJobsRequest, ListJobsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListJobsResult>(){

            @Override
            public ListJobsResult call() throws Exception {
                ListJobsResult result;
                try {
                    result = AWSBatchAsyncClient.this.listJobs(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterJobDefinitionResult> registerJobDefinitionAsync(RegisterJobDefinitionRequest request) {
        return this.registerJobDefinitionAsync(request, null);
    }

    @Override
    public Future<RegisterJobDefinitionResult> registerJobDefinitionAsync(final RegisterJobDefinitionRequest request, final AsyncHandler<RegisterJobDefinitionRequest, RegisterJobDefinitionResult> asyncHandler) {
        return this.executorService.submit(new Callable<RegisterJobDefinitionResult>(){

            @Override
            public RegisterJobDefinitionResult call() throws Exception {
                RegisterJobDefinitionResult result;
                try {
                    result = AWSBatchAsyncClient.this.registerJobDefinition(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SubmitJobResult> submitJobAsync(SubmitJobRequest request) {
        return this.submitJobAsync(request, null);
    }

    @Override
    public Future<SubmitJobResult> submitJobAsync(final SubmitJobRequest request, final AsyncHandler<SubmitJobRequest, SubmitJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<SubmitJobResult>(){

            @Override
            public SubmitJobResult call() throws Exception {
                SubmitJobResult result;
                try {
                    result = AWSBatchAsyncClient.this.submitJob(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TerminateJobResult> terminateJobAsync(TerminateJobRequest request) {
        return this.terminateJobAsync(request, null);
    }

    @Override
    public Future<TerminateJobResult> terminateJobAsync(final TerminateJobRequest request, final AsyncHandler<TerminateJobRequest, TerminateJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<TerminateJobResult>(){

            @Override
            public TerminateJobResult call() throws Exception {
                TerminateJobResult result;
                try {
                    result = AWSBatchAsyncClient.this.terminateJob(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateComputeEnvironmentResult> updateComputeEnvironmentAsync(UpdateComputeEnvironmentRequest request) {
        return this.updateComputeEnvironmentAsync(request, null);
    }

    @Override
    public Future<UpdateComputeEnvironmentResult> updateComputeEnvironmentAsync(final UpdateComputeEnvironmentRequest request, final AsyncHandler<UpdateComputeEnvironmentRequest, UpdateComputeEnvironmentResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateComputeEnvironmentResult>(){

            @Override
            public UpdateComputeEnvironmentResult call() throws Exception {
                UpdateComputeEnvironmentResult result;
                try {
                    result = AWSBatchAsyncClient.this.updateComputeEnvironment(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateJobQueueResult> updateJobQueueAsync(UpdateJobQueueRequest request) {
        return this.updateJobQueueAsync(request, null);
    }

    @Override
    public Future<UpdateJobQueueResult> updateJobQueueAsync(final UpdateJobQueueRequest request, final AsyncHandler<UpdateJobQueueRequest, UpdateJobQueueResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateJobQueueResult>(){

            @Override
            public UpdateJobQueueResult call() throws Exception {
                UpdateJobQueueResult result;
                try {
                    result = AWSBatchAsyncClient.this.updateJobQueue(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

