/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationautoscaling.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.applicationautoscaling.model.DeleteScalingPolicyRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DeleteScalingPolicyRequestMarshaller
implements Marshaller<Request<DeleteScalingPolicyRequest>, DeleteScalingPolicyRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DeleteScalingPolicyRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteScalingPolicyRequest> marshall(DeleteScalingPolicyRequest deleteScalingPolicyRequest) {
        if (deleteScalingPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteScalingPolicyRequest> request = new DefaultRequest<DeleteScalingPolicyRequest>(deleteScalingPolicyRequest, "AWSApplicationAutoScaling");
        request.addHeader("X-Amz-Target", "AnyScaleFrontendService.DeleteScalingPolicy");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (deleteScalingPolicyRequest.getPolicyName() != null) {
                jsonGenerator.writeFieldName("PolicyName").writeValue(deleteScalingPolicyRequest.getPolicyName());
            }
            if (deleteScalingPolicyRequest.getServiceNamespace() != null) {
                jsonGenerator.writeFieldName("ServiceNamespace").writeValue(deleteScalingPolicyRequest.getServiceNamespace());
            }
            if (deleteScalingPolicyRequest.getResourceId() != null) {
                jsonGenerator.writeFieldName("ResourceId").writeValue(deleteScalingPolicyRequest.getResourceId());
            }
            if (deleteScalingPolicyRequest.getScalableDimension() != null) {
                jsonGenerator.writeFieldName("ScalableDimension").writeValue(deleteScalingPolicyRequest.getScalableDimension());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

