/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.apigateway.model.GetUsagePlanKeysRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetUsagePlanKeysRequestMarshaller
implements Marshaller<Request<GetUsagePlanKeysRequest>, GetUsagePlanKeysRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetUsagePlanKeysRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetUsagePlanKeysRequest> marshall(GetUsagePlanKeysRequest getUsagePlanKeysRequest) {
        if (getUsagePlanKeysRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetUsagePlanKeysRequest> request = new DefaultRequest<GetUsagePlanKeysRequest>(getUsagePlanKeysRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/usageplans/{usageplanId}/keys";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "usageplanId", getUsagePlanKeysRequest.getUsagePlanId());
        request.setResourcePath(uriResourcePath);
        if (getUsagePlanKeysRequest.getPosition() != null) {
            request.addParameter("position", StringUtils.fromString(getUsagePlanKeysRequest.getPosition()));
        }
        if (getUsagePlanKeysRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromInteger(getUsagePlanKeysRequest.getLimit()));
        }
        if (getUsagePlanKeysRequest.getNameQuery() != null) {
            request.addParameter("name", StringUtils.fromString(getUsagePlanKeysRequest.getNameQuery()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

