/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.view;

import java.io.PrintWriter;
import java.util.EnumSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.WebAppException;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet2.HamletImpl;
import org.apache.hadoop.yarn.webapp.hamlet2.HamletSpec;
import org.apache.hadoop.yarn.webapp.view.TextView;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
public abstract class HtmlPage
extends TextView {
    public static final String DOCTYPE = "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">";
    private Page page;

    private Page page() {
        if (this.page == null) {
            this.page = new Page(this.writer());
        }
        return this.page;
    }

    protected HtmlPage() {
        this(null);
    }

    protected HtmlPage(View.ViewContext ctx) {
        super(ctx, "text/html; charset=UTF-8");
    }

    @Override
    public void render() {
        this.puts(DOCTYPE);
        this.render((Hamlet.HTML<__>)((Hamlet.HTML)this.page().html().meta_http("X-UA-Compatible", "IE=8")).meta_http("Content-type", "text/html; charset=UTF-8"));
        if (this.page().nestLevel() != 0) {
            throw new WebAppException("Error rendering page: nestLevel=" + this.page().nestLevel());
        }
    }

    protected abstract void render(Hamlet.HTML<__> var1);

    public class Page
    extends Hamlet {
        Page(PrintWriter out) {
            super(out, 0, false);
        }

        @Override
        protected void subView(Class<? extends SubView> cls) {
            HtmlPage.this.context().set(this.nestLevel(), this.wasInline());
            HtmlPage.this.render(cls);
            this.setWasInline(HtmlPage.this.context().wasInline());
        }

        public Hamlet.HTML<__> html() {
            return new Hamlet.HTML((Hamlet)this, "html", null, EnumSet.of(HamletImpl.EOpt.ENDTAG));
        }
    }

    public static class __
    implements HamletSpec.__ {
    }
}

