/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;

public class YarnAppUtil {
    public static final FsPermission APP_DIR_PERMISSION = FsPermission.createImmutable((short)448);
    public static final FsPermission APP_FILE_PERMISSION = FsPermission.createImmutable((short)420);
    public static final FsPermission RM_SYSTEM_DIR_PERMISSION = FsPermission.createImmutable((short)448);
    public static final FsPermission RM_STAGING_DIR_PERMISSION = FsPermission.createImmutable((short)511);
    private static final String MAPR_TICKET_FILE = "ticketfile";

    public static Path getRMStagingDir(String appIdStr, FileSystem fs, Configuration conf) {
        Path dir = new Path(conf.get("yarn.resourcemanager.staging"));
        return new Path(fs.makeQualified(dir).toString(), appIdStr);
    }

    public static Path getRMSystemDir(String appIdStr, FileSystem fs, Configuration conf) {
        Path dir = new Path(conf.get("yarn.resourcemanager.system"));
        return new Path(fs.makeQualified(dir).toString(), appIdStr);
    }

    public static Path getRMStagedMapRTicketPath(String appIdStr, FileSystem fs, Configuration conf) {
        return YarnAppUtil.getMapRTicketPath(YarnAppUtil.getRMStagingDir(appIdStr, fs, conf));
    }

    public static Path getRMSystemMapRTicketPath(String appIdStr, FileSystem fs, Configuration conf) {
        return YarnAppUtil.getMapRTicketPath(YarnAppUtil.getRMSystemDir(appIdStr, fs, conf));
    }

    public static Path getMapRTicketPath(Path appDir) {
        return new Path(appDir, MAPR_TICKET_FILE);
    }

    public static String getNMPrivateRelativeTicketLocation(String appIdStr) {
        StringBuilder sb = new StringBuilder();
        sb.append("nmPrivate").append("/").append(appIdStr).append("/").append(MAPR_TICKET_FILE);
        return sb.toString();
    }

    public static Path getNMPrivateTicketPath(String appIdStr, Configuration conf) {
        return new Path(conf.get("yarn.nodemanager.local-dirs"), YarnAppUtil.getNMPrivateRelativeTicketLocation(appIdStr));
    }
}

