/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.util.Map;
import org.apache.hadoop.yarn.conf.DefaultYarnConfiguration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.DFSLoggingHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskLogUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TaskLogUtil.class);
    private static final YarnConfiguration DEFAULT_CONF = DefaultYarnConfiguration.get();
    private static final boolean enableDfsLogging;
    private static DFSLoggingHandler dfsLoggingHandler;

    private static void initializeHandler() {
        String handlerClass = DEFAULT_CONF.get("yarn.dfs-logging.handler-class");
        try {
            dfsLoggingHandler = (DFSLoggingHandler)Class.forName(handlerClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.error("Cannot load redirection class: " + handlerClass, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static DFSLoggingHandler getDFSLoggingHandler() {
        return dfsLoggingHandler;
    }

    public static boolean isDfsLoggingEnabled() {
        return enableDfsLogging;
    }

    public static boolean isDfsLoggingEnabled(Map<String, String> env) {
        String dfsLoggingSupported = env.get("yarn_dfs_logging_supported");
        return enableDfsLogging && dfsLoggingSupported != null && Boolean.parseBoolean(dfsLoggingSupported);
    }

    public static YarnConfiguration getConf() {
        return DEFAULT_CONF;
    }

    public static String getAppender() {
        return enableDfsLogging ? "CLA_DFS" : "CLA";
    }

    public static String getRollingAppender() {
        return enableDfsLogging ? "CRLA_DFS" : "CRLA";
    }

    public static String getPropertyValue(String property, String defaultValue) {
        return DEFAULT_CONF.get(property, defaultValue);
    }

    public static String getPropertyValue(String property) {
        return DEFAULT_CONF.get(property);
    }

    static {
        dfsLoggingHandler = null;
        enableDfsLogging = Boolean.parseBoolean(DEFAULT_CONF.get("yarn.use-central-logging-for-mapreduce-only", "false"));
        if (enableDfsLogging) {
            TaskLogUtil.initializeHandler();
        }
    }
}

