/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.util.Collection;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.hadoop.yarn.security.NMTokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NMTokenSelector
implements TokenSelector<NMTokenIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(NMTokenSelector.class);

    public Token<NMTokenIdentifier> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (service == null) {
            return null;
        }
        for (Token<? extends TokenIdentifier> token : tokens) {
            if (LOG.isDebugEnabled()) {
                LOG.info("Looking for service: " + service + ". Current token is " + token);
            }
            if (!NMTokenIdentifier.KIND.equals((Object)token.getKind()) || !service.equals((Object)token.getService())) continue;
            return token;
        }
        return null;
    }
}

