/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.nodelabels.FileSystemNodeLabelsStore;
import org.apache.hadoop.yarn.nodelabels.NodeLabel;
import org.apache.hadoop.yarn.nodelabels.NodeLabelsStore;
import org.apache.hadoop.yarn.nodelabels.event.NodeLabelsStoreEvent;
import org.apache.hadoop.yarn.nodelabels.event.NodeLabelsStoreEventType;
import org.apache.hadoop.yarn.nodelabels.event.RemoveClusterNodeLabels;
import org.apache.hadoop.yarn.nodelabels.event.StoreNewClusterNodeLabels;
import org.apache.hadoop.yarn.nodelabels.event.UpdateNodeToLabelsMappingsEvent;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonNodeLabelsManager
extends AbstractService {
    protected static final Logger LOG = LoggerFactory.getLogger(CommonNodeLabelsManager.class);
    private static final int MAX_LABEL_LENGTH = 255;
    public static final Set<String> EMPTY_STRING_SET = Collections.unmodifiableSet(new HashSet(0));
    public static final String ANY = "*";
    public static final Set<String> ACCESS_ANY_LABEL_SET = ImmutableSet.of((Object)"*");
    private static final Pattern LABEL_PATTERN = Pattern.compile("^[0-9a-zA-Z][0-9a-zA-Z-_]*");
    public static final int WILDCARD_PORT = 0;
    @VisibleForTesting
    public static final String NODE_LABELS_NOT_ENABLED_ERR = "Node-label-based scheduling is disabled. Please check yarn.node-labels.enabled";
    public static final String NO_LABEL = "";
    protected Dispatcher dispatcher;
    protected ConcurrentMap<String, NodeLabel> labelCollections = new ConcurrentHashMap<String, NodeLabel>();
    protected ConcurrentMap<String, Host> nodeCollections = new ConcurrentHashMap<String, Host>();
    protected final ReentrantReadWriteLock.ReadLock readLock;
    protected final ReentrantReadWriteLock.WriteLock writeLock;
    protected NodeLabelsStore store;
    private boolean nodeLabelsEnabled = false;

    protected void handleStoreEvent(NodeLabelsStoreEvent event) {
        try {
            switch ((NodeLabelsStoreEventType)((Object)event.getType())) {
                case ADD_LABELS: {
                    StoreNewClusterNodeLabels storeNewClusterNodeLabelsEvent = (StoreNewClusterNodeLabels)event;
                    this.store.storeNewClusterNodeLabels(storeNewClusterNodeLabelsEvent.getLabels());
                    break;
                }
                case REMOVE_LABELS: {
                    RemoveClusterNodeLabels removeClusterNodeLabelsEvent = (RemoveClusterNodeLabels)event;
                    this.store.removeClusterNodeLabels(removeClusterNodeLabelsEvent.getLabels());
                    break;
                }
                case STORE_NODE_TO_LABELS: {
                    UpdateNodeToLabelsMappingsEvent updateNodeToLabelsMappingsEvent = (UpdateNodeToLabelsMappingsEvent)event;
                    this.store.updateNodeToLabelsMappings(updateNodeToLabelsMappingsEvent.getNodeToLabels());
                }
            }
        }
        catch (IOException e) {
            LOG.error("Failed to store label modification to storage");
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    public CommonNodeLabelsManager() {
        super(CommonNodeLabelsManager.class.getName());
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    protected void initDispatcher(Configuration conf) {
        this.dispatcher = new AsyncDispatcher();
        AsyncDispatcher asyncDispatcher = (AsyncDispatcher)this.dispatcher;
        asyncDispatcher.init(conf);
        asyncDispatcher.setDrainEventsOnStop();
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.nodeLabelsEnabled = conf.getBoolean("yarn.node-labels.enabled", false);
        if (this.nodeLabelsEnabled) {
            this.initNodeLabelStore(conf);
        }
        this.labelCollections.put(NO_LABEL, new NodeLabel(NO_LABEL));
    }

    protected void initNodeLabelStore(Configuration conf) throws Exception {
        this.store = new FileSystemNodeLabelsStore(this);
        this.store.init(conf);
        this.store.recover();
    }

    protected void startDispatcher() {
        AsyncDispatcher asyncDispatcher = (AsyncDispatcher)this.dispatcher;
        asyncDispatcher.start();
    }

    protected void serviceStart() throws Exception {
        this.initDispatcher(this.getConfig());
        if (null != this.dispatcher) {
            this.dispatcher.register(NodeLabelsStoreEventType.class, new ForwardingEventHandler());
        }
        this.startDispatcher();
    }

    protected void stopDispatcher() {
        AsyncDispatcher asyncDispatcher = (AsyncDispatcher)this.dispatcher;
        if (null != asyncDispatcher) {
            asyncDispatcher.stop();
        }
    }

    protected void serviceStop() throws Exception {
        this.stopDispatcher();
        if (null != this.store) {
            this.store.close();
        }
    }

    public void addToCluserNodeLabels(Set<String> labels) throws IOException {
        if (!this.nodeLabelsEnabled) {
            LOG.error(NODE_LABELS_NOT_ENABLED_ERR);
            throw new IOException(NODE_LABELS_NOT_ENABLED_ERR);
        }
        if (null == labels || labels.isEmpty()) {
            return;
        }
        HashSet<String> newLabels = new HashSet<String>();
        labels = this.normalizeLabels(labels);
        for (String label : labels) {
            this.checkAndThrowLabelName(label);
        }
        for (String label : labels) {
            if (this.labelCollections.get(label) != null) continue;
            this.labelCollections.put(label, new NodeLabel(label));
            newLabels.add(label);
        }
        if (null != this.dispatcher && !newLabels.isEmpty()) {
            this.dispatcher.getEventHandler().handle(new StoreNewClusterNodeLabels((Set<String>)newLabels));
        }
        LOG.info("Add labels: [" + StringUtils.join(labels.iterator(), (String)",") + "]");
    }

    protected void checkAddLabelsToNode(Map<NodeId, Set<String>> addedLabelsToNode) throws IOException {
        if (null == addedLabelsToNode || addedLabelsToNode.isEmpty()) {
            return;
        }
        Set knownLabels = this.labelCollections.keySet();
        for (Map.Entry<NodeId, Set<String>> entry : addedLabelsToNode.entrySet()) {
            NodeId nodeId = entry.getKey();
            Set<String> labels = entry.getValue();
            if (!knownLabels.containsAll(labels)) {
                String msg = "Not all labels being added contained by known label collections, please check, added labels=[" + StringUtils.join(labels, (String)",") + "]";
                LOG.error(msg);
                throw new IOException(msg);
            }
            if (labels.isEmpty()) continue;
            HashSet<String> newLabels = new HashSet<String>(this.getLabelsByNode(nodeId));
            newLabels.addAll(labels);
            if (newLabels.size() <= 1) continue;
            String msg = String.format("%d labels specified on host=%s after add labels to node, please note that we do not support specifying multiple labels on a single host for now.", newLabels.size(), nodeId.getHost());
            LOG.error(msg);
            throw new IOException(msg);
        }
    }

    public void addLabelsToNode(Map<NodeId, Set<String>> addedLabelsToNode) throws IOException {
        if (!this.nodeLabelsEnabled) {
            LOG.error(NODE_LABELS_NOT_ENABLED_ERR);
            throw new IOException(NODE_LABELS_NOT_ENABLED_ERR);
        }
        addedLabelsToNode = this.normalizeNodeIdToLabels(addedLabelsToNode);
        this.checkAddLabelsToNode(addedLabelsToNode);
        this.internalUpdateLabelsOnNodes(addedLabelsToNode, NodeLabelUpdateOperation.ADD);
    }

    protected void checkRemoveFromClusterNodeLabels(Collection<String> labelsToRemove) throws IOException {
        if (null == labelsToRemove || labelsToRemove.isEmpty()) {
            return;
        }
        for (String label : labelsToRemove) {
            if ((label = this.normalizeLabel(label)) == null || label.isEmpty()) {
                throw new IOException("Label to be removed is null or empty");
            }
            if (this.labelCollections.containsKey(label)) continue;
            throw new IOException("Node label=" + label + " to be removed doesn't existed in cluster node labels collection.");
        }
    }

    protected void internalRemoveFromClusterNodeLabels(Collection<String> labelsToRemove) {
        for (Map.Entry nodeEntry : this.nodeCollections.entrySet()) {
            Host host = (Host)nodeEntry.getValue();
            if (null == host) continue;
            host.labels.removeAll(labelsToRemove);
            for (Node nm : host.nms.values()) {
                if (nm.labels == null) continue;
                nm.labels.removeAll(labelsToRemove);
            }
        }
        for (String label : labelsToRemove) {
            this.labelCollections.remove(label);
        }
        if (null != this.dispatcher) {
            this.dispatcher.getEventHandler().handle(new RemoveClusterNodeLabels(labelsToRemove));
        }
        LOG.info("Remove labels: [" + StringUtils.join(labelsToRemove.iterator(), (String)",") + "]");
    }

    public void removeFromClusterNodeLabels(Collection<String> labelsToRemove) throws IOException {
        if (!this.nodeLabelsEnabled) {
            LOG.error(NODE_LABELS_NOT_ENABLED_ERR);
            throw new IOException(NODE_LABELS_NOT_ENABLED_ERR);
        }
        labelsToRemove = this.normalizeLabels(labelsToRemove);
        this.checkRemoveFromClusterNodeLabels(labelsToRemove);
        this.internalRemoveFromClusterNodeLabels(labelsToRemove);
    }

    protected void checkRemoveLabelsFromNode(Map<NodeId, Set<String>> removeLabelsFromNode) throws IOException {
        Set knownLabels = this.labelCollections.keySet();
        for (Map.Entry<NodeId, Set<String>> entry : removeLabelsFromNode.entrySet()) {
            String msg;
            NodeId nodeId = entry.getKey();
            Set<String> labels = entry.getValue();
            if (!knownLabels.containsAll(labels)) {
                String msg2 = "Not all labels being removed contained by known label collections, please check, removed labels=[" + StringUtils.join(labels, (String)",") + "]";
                LOG.error(msg2);
                throw new IOException(msg2);
            }
            Set<String> originalLabels = null;
            boolean nodeExisted = false;
            if (0 != nodeId.getPort()) {
                Node nm = this.getNMInNodeSet(nodeId);
                if (nm != null) {
                    originalLabels = nm.labels;
                    nodeExisted = true;
                }
            } else {
                Host host = (Host)this.nodeCollections.get(nodeId.getHost());
                if (null != host) {
                    originalLabels = host.labels;
                    nodeExisted = true;
                }
            }
            if (!nodeExisted) {
                msg = "Try to remove labels from NM=" + nodeId + ", but the NM doesn't existed";
                LOG.error(msg);
                throw new IOException(msg);
            }
            if (labels.isEmpty() || originalLabels != null && originalLabels.containsAll(labels)) continue;
            msg = "Try to remove labels = [" + StringUtils.join(labels, (String)",") + "], but not all labels contained by NM=" + nodeId;
            LOG.error(msg);
            throw new IOException(msg);
        }
    }

    private void addNodeToLabels(NodeId node, Set<String> labels) {
        for (String l : labels) {
            ((NodeLabel)this.labelCollections.get(l)).addNodeId(node);
        }
    }

    protected void removeNodeFromLabels(NodeId node, Set<String> labels) {
        for (String l : labels) {
            ((NodeLabel)this.labelCollections.get(l)).removeNodeId(node);
        }
    }

    private void replaceNodeForLabels(NodeId node, Set<String> oldLabels, Set<String> newLabels) {
        if (oldLabels != null) {
            this.removeNodeFromLabels(node, oldLabels);
        }
        this.addNodeToLabels(node, newLabels);
    }

    protected void internalUpdateLabelsOnNodes(Map<NodeId, Set<String>> nodeToLabels, NodeLabelUpdateOperation op) throws IOException {
        HashMap<NodeId, Set<String>> newNMToLabels = new HashMap<NodeId, Set<String>>();
        for (Map.Entry<NodeId, Set<String>> entry : nodeToLabels.entrySet()) {
            Node nm;
            NodeId nodeId = entry.getKey();
            Set<String> labels = entry.getValue();
            this.createHostIfNonExisted(nodeId.getHost());
            if (nodeId.getPort() == 0) {
                Host host = (Host)this.nodeCollections.get(nodeId.getHost());
                switch (op) {
                    case REMOVE: {
                        this.removeNodeFromLabels(nodeId, labels);
                        host.labels.removeAll(labels);
                        for (Node node : host.nms.values()) {
                            if (node.labels != null) {
                                node.labels.removeAll(labels);
                            }
                            this.removeNodeFromLabels(node.nodeId, labels);
                        }
                        break;
                    }
                    case ADD: {
                        this.addNodeToLabels(nodeId, labels);
                        host.labels.addAll(labels);
                        for (Node node : host.nms.values()) {
                            if (node.labels != null) {
                                node.labels.addAll(labels);
                            }
                            this.addNodeToLabels(node.nodeId, labels);
                        }
                        break;
                    }
                    case REPLACE: {
                        this.replaceNodeForLabels(nodeId, host.labels, labels);
                        host.labels.clear();
                        host.labels.addAll(labels);
                        for (Node node : host.nms.values()) {
                            this.replaceNodeForLabels(node.nodeId, node.labels, labels);
                            node.labels = null;
                        }
                        break;
                    }
                }
                newNMToLabels.put(nodeId, host.labels);
                continue;
            }
            if (EnumSet.of(NodeLabelUpdateOperation.ADD, NodeLabelUpdateOperation.REPLACE).contains((Object)op)) {
                this.createNodeIfNonExisted(nodeId);
                nm = this.getNMInNodeSet(nodeId);
                switch (op) {
                    case ADD: {
                        this.addNodeToLabels(nodeId, labels);
                        if (nm.labels == null) {
                            nm.labels = new HashSet<String>();
                        }
                        nm.labels.addAll(labels);
                        break;
                    }
                    case REPLACE: {
                        Set<String> oldLabels = this.getLabelsByNode(nodeId);
                        this.replaceNodeForLabels(nodeId, oldLabels, labels);
                        if (nm.labels == null) {
                            nm.labels = new HashSet<String>();
                        }
                        nm.labels.clear();
                        nm.labels.addAll(labels);
                        break;
                    }
                }
                newNMToLabels.put(nodeId, nm.labels);
                continue;
            }
            this.removeNodeFromLabels(nodeId, labels);
            nm = this.getNMInNodeSet(nodeId);
            if (nm.labels == null) continue;
            nm.labels.removeAll(labels);
            newNMToLabels.put(nodeId, nm.labels);
        }
        if (null != this.dispatcher) {
            this.dispatcher.getEventHandler().handle(new UpdateNodeToLabelsMappingsEvent((Map<NodeId, Set<String>>)newNMToLabels));
        }
        LOG.info(op.name() + " labels on nodes:");
        for (Map.Entry<Object, Set<String>> entry : newNMToLabels.entrySet()) {
            LOG.info("  NM=" + entry.getKey() + ", labels=[" + StringUtils.join(entry.getValue().iterator(), (String)",") + "]");
        }
    }

    public void removeLabelsFromNode(Map<NodeId, Set<String>> removeLabelsFromNode) throws IOException {
        if (!this.nodeLabelsEnabled) {
            LOG.error(NODE_LABELS_NOT_ENABLED_ERR);
            throw new IOException(NODE_LABELS_NOT_ENABLED_ERR);
        }
        removeLabelsFromNode = this.normalizeNodeIdToLabels(removeLabelsFromNode);
        this.checkRemoveLabelsFromNode(removeLabelsFromNode);
        this.internalUpdateLabelsOnNodes(removeLabelsFromNode, NodeLabelUpdateOperation.REMOVE);
    }

    protected void checkReplaceLabelsOnNode(Map<NodeId, Set<String>> replaceLabelsToNode) throws IOException {
        if (null == replaceLabelsToNode || replaceLabelsToNode.isEmpty()) {
            return;
        }
        Set knownLabels = this.labelCollections.keySet();
        for (Map.Entry<NodeId, Set<String>> entry : replaceLabelsToNode.entrySet()) {
            NodeId nodeId = entry.getKey();
            Set<String> labels = entry.getValue();
            if (labels.size() > 1) {
                String msg = String.format("%d labels specified on host=%s, please note that we do not support specifying multiple labels on a single host for now.", labels.size(), nodeId.getHost());
                LOG.error(msg);
                throw new IOException(msg);
            }
            if (knownLabels.containsAll(labels)) continue;
            String msg = "Not all labels being replaced contained by known label collections, please check, new labels=[" + StringUtils.join(labels, (String)",") + "]";
            LOG.error(msg);
            throw new IOException(msg);
        }
    }

    public void replaceLabelsOnNode(Map<NodeId, Set<String>> replaceLabelsToNode) throws IOException {
        if (!this.nodeLabelsEnabled) {
            LOG.error(NODE_LABELS_NOT_ENABLED_ERR);
            throw new IOException(NODE_LABELS_NOT_ENABLED_ERR);
        }
        replaceLabelsToNode = this.normalizeNodeIdToLabels(replaceLabelsToNode);
        this.checkReplaceLabelsOnNode(replaceLabelsToNode);
        this.internalUpdateLabelsOnNodes(replaceLabelsToNode, NodeLabelUpdateOperation.REPLACE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<NodeId, Set<String>> getNodeLabels() {
        try {
            this.readLock.lock();
            HashMap<NodeId, Set<String>> nodeToLabels = new HashMap<NodeId, Set<String>>();
            for (Map.Entry entry : this.nodeCollections.entrySet()) {
                String hostName = (String)entry.getKey();
                Host host = (Host)entry.getValue();
                for (NodeId nodeId : host.nms.keySet()) {
                    Set<String> nodeLabels = this.getLabelsByNode(nodeId);
                    if (nodeLabels == null || nodeLabels.isEmpty()) continue;
                    nodeToLabels.put(nodeId, nodeLabels);
                }
                if (host.labels.isEmpty()) continue;
                nodeToLabels.put(NodeId.newInstance((String)hostName, (int)0), host.labels);
            }
            Map map = Collections.unmodifiableMap(nodeToLabels);
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Map<String, Set<NodeId>> getLabelsToNodes() {
        try {
            this.readLock.lock();
            Map<String, Set<NodeId>> map = this.getLabelsToNodes(this.labelCollections.keySet());
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Set<NodeId>> getLabelsToNodes(Set<String> labels) {
        try {
            this.readLock.lock();
            HashMap<String, Set<NodeId>> labelsToNodes = new HashMap<String, Set<NodeId>>();
            for (String label : labels) {
                if (label.equals(NO_LABEL)) continue;
                NodeLabel nodeLabelInfo = (NodeLabel)this.labelCollections.get(label);
                if (nodeLabelInfo != null) {
                    Set<NodeId> nodeIds = nodeLabelInfo.getAssociatedNodeIds();
                    if (nodeIds.isEmpty()) continue;
                    labelsToNodes.put(label, nodeIds);
                    continue;
                }
                LOG.warn("getLabelsToNodes : Label [" + label + "] cannot be found");
            }
            Map map = Collections.unmodifiableMap(labelsToNodes);
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<String> getClusterNodeLabels() {
        try {
            this.readLock.lock();
            HashSet labels = new HashSet(this.labelCollections.keySet());
            labels.remove(NO_LABEL);
            Set<String> set = Collections.unmodifiableSet(labels);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void checkAndThrowLabelName(String label) throws IOException {
        if (label == null || label.isEmpty() || label.length() > 255) {
            throw new IOException("label added is empty or exceeds 255 character(s)");
        }
        boolean match = LABEL_PATTERN.matcher(label = label.trim()).matches();
        if (!match) {
            throw new IOException("label name should only contains {0-9, a-z, A-Z, -, _} and should not started with {-,_}, now it is=" + label);
        }
    }

    protected String normalizeLabel(String label) {
        if (label != null) {
            return label.trim();
        }
        return NO_LABEL;
    }

    private Set<String> normalizeLabels(Collection<String> labels) {
        HashSet<String> newLabels = new HashSet<String>();
        for (String label : labels) {
            newLabels.add(this.normalizeLabel(label));
        }
        return newLabels;
    }

    protected Node getNMInNodeSet(NodeId nodeId) {
        return this.getNMInNodeSet(nodeId, this.nodeCollections);
    }

    protected Node getNMInNodeSet(NodeId nodeId, Map<String, Host> map) {
        return this.getNMInNodeSet(nodeId, map, false);
    }

    protected Node getNMInNodeSet(NodeId nodeId, Map<String, Host> map, boolean checkRunning) {
        Host host = map.get(nodeId.getHost());
        if (null == host) {
            return null;
        }
        Node nm = host.nms.get(nodeId);
        if (null == nm) {
            return null;
        }
        if (checkRunning) {
            return nm.running ? nm : null;
        }
        return nm;
    }

    protected Set<String> getLabelsByNode(NodeId nodeId) {
        return this.getLabelsByNode(nodeId, this.nodeCollections);
    }

    protected Set<String> getLabelsByNode(NodeId nodeId, Map<String, Host> map) {
        Host host = map.get(nodeId.getHost());
        if (null == host) {
            return EMPTY_STRING_SET;
        }
        Node nm = host.nms.get(nodeId);
        if (null != nm && null != nm.labels) {
            return nm.labels;
        }
        return host.labels;
    }

    protected void createNodeIfNonExisted(NodeId nodeId) throws IOException {
        Host host = (Host)this.nodeCollections.get(nodeId.getHost());
        if (null == host) {
            throw new IOException("Should create host before creating node.");
        }
        Node nm = host.nms.get(nodeId);
        if (null == nm) {
            host.nms.put(nodeId, new Node(nodeId));
        }
    }

    protected void createHostIfNonExisted(String hostName) {
        Host host = (Host)this.nodeCollections.get(hostName);
        if (null == host) {
            host = new Host();
            this.nodeCollections.put(hostName, host);
        }
    }

    protected Map<NodeId, Set<String>> normalizeNodeIdToLabels(Map<NodeId, Set<String>> nodeIdToLabels) {
        HashMap<NodeId, Set<String>> newMap = new HashMap<NodeId, Set<String>>();
        for (Map.Entry<NodeId, Set<String>> entry : nodeIdToLabels.entrySet()) {
            NodeId id = entry.getKey();
            Set<String> labels = entry.getValue();
            newMap.put(id, this.normalizeLabels(labels));
        }
        return newMap;
    }

    private final class ForwardingEventHandler
    implements EventHandler<NodeLabelsStoreEvent> {
        private ForwardingEventHandler() {
        }

        @Override
        public void handle(NodeLabelsStoreEvent event) {
            CommonNodeLabelsManager.this.handleStoreEvent(event);
        }
    }

    private static enum NodeLabelUpdateOperation {
        ADD,
        REMOVE,
        REPLACE;

    }

    protected static class Node {
        public Set<String> labels = null;
        public Resource resource = Resource.newInstance((int)0, (int)0);
        public boolean running = false;
        public NodeId nodeId;

        protected Node(NodeId nodeid) {
            this.nodeId = nodeid;
        }

        public Node copy() {
            Node c = new Node(this.nodeId);
            if (this.labels != null) {
                c.labels = Collections.newSetFromMap(new ConcurrentHashMap());
                c.labels.addAll(this.labels);
            } else {
                c.labels = null;
            }
            c.resource = Resources.clone(this.resource);
            c.running = this.running;
            return c;
        }
    }

    protected static class Host {
        public Set<String> labels = Collections.newSetFromMap(new ConcurrentHashMap());
        public Map<NodeId, Node> nms = new ConcurrentHashMap<NodeId, Node>();

        protected Host() {
        }

        public Host copy() {
            Host c = new Host();
            c.labels = new HashSet<String>(this.labels);
            for (Map.Entry<NodeId, Node> entry : this.nms.entrySet()) {
                c.nms.put(entry.getKey(), entry.getValue().copy());
            }
            return c;
        }
    }
}

