/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.configuration;

import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class YarnHASiteXmlBuilder {
    private static final String RM_ID_TEMPLATE = "__RM_ID__";
    private static final String IP_FOR_RM_ID_TEMPLATE = "__IP_FOR_RM_ID__";
    private static final String THIS_RM_ID_TEMPLATE = "__THIS_RM_ID__";
    private static final String RM_IDS_TEMPLATE = "__COMMA_SEPARATED_RM_IDS__";
    private static final String MAPR_CLUSTER_ID_TEMPLATE = "__MAPR_CLUSTER_ID__";
    private static final String ZK_IP_PORT_TEMPLATE = "__ZK_IP_PORT__";
    private static final String RM_CONFIGS_TEMPLATE = "__THIS_LINE_WILL_BE_REPLACED_BY_CONFIGS_FOR_INDIVIDUAL_RMS__";
    private static final String CONFIG_DEMARCATION = "  <!-- :::CAUTION::: DO NOT EDIT ANYTHING ON OR ABOVE THIS LINE -->";
    private static final String YARN_SITE_HA_TEMPLATE_FILE = "yarn-site-ha-template.xml";
    private static final String YARN_HA_RM_ID_TEMPLATE_FILE = "yarn-ha-rm-id-configuration.template";
    private final String[] rmIps;
    private final String maprClusterName;
    private final String zkIpPort;
    private final String pathToYarnSiteXml;
    private String rmIdConfigTemplate;

    public YarnHASiteXmlBuilder(String[] rmIps, String clusterName, String zkIpPort, String pathToYarnSiteXml) {
        this.rmIps = rmIps;
        this.maprClusterName = clusterName;
        this.zkIpPort = zkIpPort;
        this.pathToYarnSiteXml = pathToYarnSiteXml;
    }

    public String build() throws IOException {
        String currentContents;
        String string = currentContents = new File(this.pathToYarnSiteXml).exists() ? this.readStream(new FileInputStream(this.pathToYarnSiteXml)) : "";
        if (currentContents.contains(CONFIG_DEMARCATION)) {
            return currentContents.replaceAll("(?s).*  <!-- :::CAUTION::: DO NOT EDIT ANYTHING ON OR ABOVE THIS LINE -->\r?\n", this.buildYarnSiteXmlFromTemplate().replaceAll("(?s)</configuration>.*", ""));
        }
        return this.buildYarnSiteXmlFromTemplate();
    }

    private String buildYarnSiteXmlFromTemplate() throws IOException {
        Object[] rmIds = new String[this.rmIps.length];
        StringBuilder rmConfigs = new StringBuilder();
        for (int i = 0; i < this.rmIps.length; ++i) {
            rmConfigs.append(this.getRMConfigForIp(this.rmIps[i]));
            rmIds[i] = this.getRmIdForIp(this.rmIps[i]);
        }
        InputStream haTemplateStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(YARN_SITE_HA_TEMPLATE_FILE);
        return this.readStream(haTemplateStream).replace(RM_IDS_TEMPLATE, Joiner.on((String)",").join(rmIds)).replace(MAPR_CLUSTER_ID_TEMPLATE, this.maprClusterName).replace(ZK_IP_PORT_TEMPLATE, this.zkIpPort).replace(THIS_RM_ID_TEMPLATE, this.getRmIdForIp(this.getThisRmIp())).replaceAll("(?m)^.*__THIS_LINE_WILL_BE_REPLACED_BY_CONFIGS_FOR_INDIVIDUAL_RMS__.*$", rmConfigs.toString());
    }

    private String getRMConfigForIp(String rmIp) throws IOException {
        return this.getRmIdConfigTemplate().replace(RM_ID_TEMPLATE, this.getRmIdForIp(rmIp)).replace(IP_FOR_RM_ID_TEMPLATE, rmIp);
    }

    private String getRmIdConfigTemplate() throws IOException {
        if (this.rmIdConfigTemplate == null) {
            this.rmIdConfigTemplate = this.readStream(Thread.currentThread().getContextClassLoader().getResourceAsStream(YARN_HA_RM_ID_TEMPLATE_FILE));
        }
        return this.rmIdConfigTemplate;
    }

    private String readStream(InputStream stream) throws IOException {
        String line;
        StringBuilder buf = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        while ((line = reader.readLine()) != null) {
            buf.append(line);
            buf.append("\n");
        }
        reader.close();
        return buf.toString();
    }

    private String getRmIdForIp(String ip) {
        for (int i = 0; i < this.rmIps.length; ++i) {
            if (!this.rmIps[i].equals(ip)) continue;
            return "rm" + String.valueOf(i + 1);
        }
        return "rm1";
    }

    private String getThisRmIp() {
        String thisRmIp = null;
        try {
            List<InetAddress> allInetAddressesOfThisMachine = this.getAllInetAddressesOfThisMachine();
            block3: for (String rmIp : this.rmIps) {
                for (InetAddress rmAddr : InetAddress.getAllByName(rmIp)) {
                    if (!this.doesAddrBelongToThisHost(rmAddr, allInetAddressesOfThisMachine)) continue;
                    if (thisRmIp == null) {
                        thisRmIp = rmIp;
                        continue block3;
                    }
                    throw new RuntimeException(thisRmIp + " and " + rmIp + " seem to resolve to same machine. Please input distinct addresses for Resource Manager hosts.");
                }
            }
            return thisRmIp;
        }
        catch (SocketException e) {
            throw new RuntimeException("Error in looking up the network interfaces of local host.", e);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Error in looking up the address for local host.", e);
        }
    }

    private boolean doesAddrBelongToThisHost(InetAddress addr, List<InetAddress> thisHostsAddresses) {
        for (InetAddress hostAddr : thisHostsAddresses) {
            if (!addr.equals(hostAddr)) continue;
            return true;
        }
        return false;
    }

    private List<InetAddress> getAllInetAddressesOfThisMachine() throws SocketException, UnknownHostException {
        ArrayList<InetAddress> allIps = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        for (NetworkInterface networkInterface : Collections.list(interfaces)) {
            allIps.addAll(Collections.list(networkInterface.getInetAddresses()));
        }
        allIps.add(InetAddress.getLocalHost());
        return allIps;
    }

    public static void main(String[] args) throws IOException {
        String[] rmIPs;
        if (args.length < 3) {
            System.err.println("Usage: YarnHASiteXmlBuilder <Comma separated RM IPs> <MapR cluster name> <ZK IP:Port (optional)> <Full path To yarn-site.xml>");
            System.exit(1);
        }
        if ((rmIPs = args[0].split(",")).length < 2) {
            System.err.println("At least 2 RM IPs are required to configure RM HA.");
            System.exit(1);
        }
        String zkAddr = args.length > 3 ? args[2] : " ";
        String yarnSiteXmlPath = args.length > 3 ? args[3] : args[2];
        System.out.println(new YarnHASiteXmlBuilder(rmIPs, args[1], zkAddr, yarnSiteXmlPath).build());
    }
}

