/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import com.google.protobuf.ByteString;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.protocolrecords.ApplicationsRequestScope;
import org.apache.hadoop.yarn.api.records.AMCommand;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.ReservationRequestInterpreter;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationResourceUsageReportPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeIdPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ProtoUtils {
    private static String CONTAINER_STATE_PREFIX = "C_";
    private static String NODE_STATE_PREFIX = "NS_";
    private static String YARN_APPLICATION_ATTEMPT_STATE_PREFIX = "APP_ATTEMPT_";
    private static String FINAL_APPLICATION_STATUS_PREFIX = "APP_";
    private static String QUEUE_STATE_PREFIX = "Q_";
    private static String QUEUE_ACL_PREFIX = "QACL_";
    private static String APP_ACCESS_TYPE_PREFIX = "APPACCESS_";

    public static YarnProtos.ContainerStateProto convertToProtoFormat(ContainerState e) {
        return YarnProtos.ContainerStateProto.valueOf((String)(CONTAINER_STATE_PREFIX + e.name()));
    }

    public static ContainerState convertFromProtoFormat(YarnProtos.ContainerStateProto e) {
        return ContainerState.valueOf((String)e.name().replace(CONTAINER_STATE_PREFIX, ""));
    }

    public static YarnProtos.NodeStateProto convertToProtoFormat(NodeState e) {
        return YarnProtos.NodeStateProto.valueOf((String)(NODE_STATE_PREFIX + e.name()));
    }

    public static NodeState convertFromProtoFormat(YarnProtos.NodeStateProto e) {
        return NodeState.valueOf((String)e.name().replace(NODE_STATE_PREFIX, ""));
    }

    public static YarnProtos.NodeIdProto convertToProtoFormat(NodeId e) {
        return ((NodeIdPBImpl)e).getProto();
    }

    public static NodeId convertFromProtoFormat(YarnProtos.NodeIdProto e) {
        return new NodeIdPBImpl(e);
    }

    public static YarnProtos.YarnApplicationStateProto convertToProtoFormat(YarnApplicationState e) {
        return YarnProtos.YarnApplicationStateProto.valueOf((String)e.name());
    }

    public static YarnApplicationState convertFromProtoFormat(YarnProtos.YarnApplicationStateProto e) {
        return YarnApplicationState.valueOf((String)e.name());
    }

    public static YarnProtos.YarnApplicationAttemptStateProto convertToProtoFormat(YarnApplicationAttemptState e) {
        return YarnProtos.YarnApplicationAttemptStateProto.valueOf((String)(YARN_APPLICATION_ATTEMPT_STATE_PREFIX + e.name()));
    }

    public static YarnApplicationAttemptState convertFromProtoFormat(YarnProtos.YarnApplicationAttemptStateProto e) {
        return YarnApplicationAttemptState.valueOf((String)e.name().replace(YARN_APPLICATION_ATTEMPT_STATE_PREFIX, ""));
    }

    public static YarnServiceProtos.ApplicationsRequestScopeProto convertToProtoFormat(ApplicationsRequestScope e) {
        return YarnServiceProtos.ApplicationsRequestScopeProto.valueOf((String)e.name());
    }

    public static ApplicationsRequestScope convertFromProtoFormat(YarnServiceProtos.ApplicationsRequestScopeProto e) {
        return ApplicationsRequestScope.valueOf((String)e.name());
    }

    public static YarnProtos.ApplicationResourceUsageReportProto convertToProtoFormat(ApplicationResourceUsageReport e) {
        return ((ApplicationResourceUsageReportPBImpl)e).getProto();
    }

    public static ApplicationResourceUsageReport convertFromProtoFormat(YarnProtos.ApplicationResourceUsageReportProto e) {
        return new ApplicationResourceUsageReportPBImpl(e);
    }

    public static YarnProtos.FinalApplicationStatusProto convertToProtoFormat(FinalApplicationStatus e) {
        return YarnProtos.FinalApplicationStatusProto.valueOf((String)(FINAL_APPLICATION_STATUS_PREFIX + e.name()));
    }

    public static FinalApplicationStatus convertFromProtoFormat(YarnProtos.FinalApplicationStatusProto e) {
        return FinalApplicationStatus.valueOf((String)e.name().replace(FINAL_APPLICATION_STATUS_PREFIX, ""));
    }

    public static YarnProtos.LocalResourceTypeProto convertToProtoFormat(LocalResourceType e) {
        return YarnProtos.LocalResourceTypeProto.valueOf((String)e.name());
    }

    public static LocalResourceType convertFromProtoFormat(YarnProtos.LocalResourceTypeProto e) {
        return LocalResourceType.valueOf((String)e.name());
    }

    public static YarnProtos.LocalResourceVisibilityProto convertToProtoFormat(LocalResourceVisibility e) {
        return YarnProtos.LocalResourceVisibilityProto.valueOf((String)e.name());
    }

    public static LocalResourceVisibility convertFromProtoFormat(YarnProtos.LocalResourceVisibilityProto e) {
        return LocalResourceVisibility.valueOf((String)e.name());
    }

    public static YarnProtos.AMCommandProto convertToProtoFormat(AMCommand e) {
        return YarnProtos.AMCommandProto.valueOf((String)e.name());
    }

    public static AMCommand convertFromProtoFormat(YarnProtos.AMCommandProto e) {
        return AMCommand.valueOf((String)e.name());
    }

    public static ByteBuffer convertFromProtoFormat(ByteString byteString) {
        int capacity = ((Buffer)byteString.asReadOnlyByteBuffer()).rewind().remaining();
        byte[] b = new byte[capacity];
        byteString.asReadOnlyByteBuffer().get(b, 0, capacity);
        return ByteBuffer.wrap(b);
    }

    public static ByteString convertToProtoFormat(ByteBuffer byteBuffer) {
        int oldPos = byteBuffer.position();
        ((Buffer)byteBuffer).rewind();
        ByteString bs = ByteString.copyFrom((ByteBuffer)byteBuffer);
        ((Buffer)byteBuffer).position(oldPos);
        return bs;
    }

    public static YarnProtos.QueueStateProto convertToProtoFormat(QueueState e) {
        return YarnProtos.QueueStateProto.valueOf((String)(QUEUE_STATE_PREFIX + e.name()));
    }

    public static QueueState convertFromProtoFormat(YarnProtos.QueueStateProto e) {
        return QueueState.valueOf((String)e.name().replace(QUEUE_STATE_PREFIX, ""));
    }

    public static YarnProtos.QueueACLProto convertToProtoFormat(QueueACL e) {
        return YarnProtos.QueueACLProto.valueOf((String)(QUEUE_ACL_PREFIX + e.name()));
    }

    public static QueueACL convertFromProtoFormat(YarnProtos.QueueACLProto e) {
        return QueueACL.valueOf((String)e.name().replace(QUEUE_ACL_PREFIX, ""));
    }

    public static YarnProtos.ApplicationAccessTypeProto convertToProtoFormat(ApplicationAccessType e) {
        return YarnProtos.ApplicationAccessTypeProto.valueOf((String)(APP_ACCESS_TYPE_PREFIX + e.name()));
    }

    public static ApplicationAccessType convertFromProtoFormat(YarnProtos.ApplicationAccessTypeProto e) {
        return ApplicationAccessType.valueOf((String)e.name().replace(APP_ACCESS_TYPE_PREFIX, ""));
    }

    public static YarnProtos.ReservationRequestInterpreterProto convertToProtoFormat(ReservationRequestInterpreter e) {
        return YarnProtos.ReservationRequestInterpreterProto.valueOf((String)e.name());
    }

    public static ReservationRequestInterpreter convertFromProtoFormat(YarnProtos.ReservationRequestInterpreterProto e) {
        return ReservationRequestInterpreter.valueOf((String)e.name());
    }
}

