/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.maprfs.AbstractMapRFileSystem;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.BaseMapRUtil;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.NodeLocalVolumeMonitor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeLocalVolumeMonitorImpl
extends AbstractService
implements NodeLocalVolumeMonitor {
    static final Logger LOG = LoggerFactory.getLogger(NodeLocalVolumeMonitorImpl.class);
    private long monitoringInterval;
    private long monitorExpiration;
    private long startSleepTime;
    private MonitoringThread monitoringThread;
    private Context nmContext;
    private FileSystem fs;
    private Set<ApplicationId> applicationSet;
    private Set<String> jobSet;
    private String outputDirName;
    private String outputUDirName;
    private String spillDirName;
    private String spillUDirName;
    private String mapredLocalVolumeMountPath;
    private String mapredNMVolumeMountPath;
    private static final String LOCALHOSTNAME = BaseMapRUtil.getMapRHostName();
    public static final String MAPR_LOCALOUTPUT_DIR_PARAM = "mapr.localoutput.dir";
    public static final String MAPR_LOCALOUTPUT_DIR_DEFAULT = "output";
    public static final String MAPR_LOCALSPILL_DIR_PARAM = "mapr.localspill.dir";
    public static final String MAPR_LOCALSPILL_DIR_DEFAULT = "spill";
    public static final String MAPR_UNCOMPRESSED_SUFFIX = ".U";
    public static final String MAPR_MAPRED_LOCAL_VOLUME_PATH = "mapr.mapred.localvolume.mount.path";
    public static final String MAPR_NM_LOCAL_VOLUME_PATH = "mapr.mapred.localvolume.root.dir.path";
    public static final String jobIdStrPrefix = "job";

    public NodeLocalVolumeMonitorImpl(Context context) {
        super(NodeLocalVolumeMonitorImpl.class.getName());
        this.nmContext = context;
        this.monitoringThread = new MonitoringThread();
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.mapredLocalVolumeMountPath = conf.get(MAPR_MAPRED_LOCAL_VOLUME_PATH, "/var/mapr/local/" + LOCALHOSTNAME + "/mapred");
        this.mapredNMVolumeMountPath = conf.get(MAPR_NM_LOCAL_VOLUME_PATH, this.mapredLocalVolumeMountPath + "/nodeManager");
        this.outputDirName = this.mapredNMVolumeMountPath + "/" + conf.get(MAPR_LOCALOUTPUT_DIR_PARAM, MAPR_LOCALOUTPUT_DIR_DEFAULT);
        this.outputUDirName = this.outputDirName + MAPR_UNCOMPRESSED_SUFFIX;
        this.spillDirName = this.mapredNMVolumeMountPath + "/" + conf.get(MAPR_LOCALSPILL_DIR_PARAM, MAPR_LOCALSPILL_DIR_DEFAULT);
        this.spillUDirName = this.spillDirName + MAPR_UNCOMPRESSED_SUFFIX;
        if (this.fs == null) {
            this.fs = FileSystem.get((URI)new URI(this.outputDirName), (Configuration)conf);
        }
        this.monitoringInterval = conf.getLong("yarn.nodemanager.local-volume.monitor.interval-secs", 86400L);
        this.monitorExpiration = conf.getLong("yarn.nodemanager.local-volume.monitor.expire-secs", 86400L);
        this.startSleepTime = conf.getLong("yarn.nodemanager.local-volume.monitor.start-sleep-secs", 600L);
        LOG.info("Local volume monitor initialized. Monitor interval: {} seconds", (Object)this.monitoringInterval);
    }

    private boolean isEnabled() {
        if (this.monitoringInterval <= 0L) {
            LOG.info("Node local volume monitoring interval is <=0. {} is disabled.", (Object)this.getClass().getName());
            return false;
        }
        if (!(this.fs instanceof AbstractMapRFileSystem)) {
            LOG.info("Output directory for local volume is not MFS instance. Monitor service can't initialize.");
            return false;
        }
        return true;
    }

    protected void serviceStart() throws Exception {
        if (this.isEnabled()) {
            this.monitoringThread.start();
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.isEnabled()) {
            this.monitoringThread.interrupt();
            try {
                this.monitoringThread.join(10000L);
            }
            catch (InterruptedException e) {
                LOG.warn("Could not wait for the thread to join");
            }
        }
        super.serviceStop();
    }

    private void checkLocalVolumeDir() {
        try {
            this.cleanUpDirectory(this.fs.listStatus(new Path(this.spillDirName)));
            this.cleanUpDirectory(this.fs.listStatus(new Path(this.spillUDirName)));
            this.cleanUpDirectory(this.fs.listStatus(new Path(this.outputDirName)));
            this.cleanUpDirectory(this.fs.listStatus(new Path(this.outputUDirName)));
        }
        catch (IOException e) {
            LOG.warn("Unable to locate local volume directories.");
        }
    }

    private void cleanUpDirectory(FileStatus[] dirs) {
        long borderToDelete = new Date().getTime() - TimeUnit.SECONDS.toMillis(this.monitorExpiration);
        if (dirs != null && dirs.length > 0) {
            for (FileStatus dir : dirs) {
                if (dir.getModificationTime() >= borderToDelete || this.jobSet.contains(dir.getPath().getName())) continue;
                try {
                    if (this.fs.delete(dir.getPath(), true)) {
                        LOG.debug("Successfully deleted : {}", (Object)dir.getPath());
                        continue;
                    }
                    LOG.warn("Directory {} was not remove during cleaning by monitor tool.", (Object)dir.getPath());
                }
                catch (IOException e) {
                    LOG.warn("Unable to delete files: {}", (Object)dir.getPath());
                }
            }
        }
    }

    private class MonitoringThread
    extends Thread {
        public MonitoringThread() {
            super("Node Local Volume Monitor");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(NodeLocalVolumeMonitorImpl.this.startSleepTime * 1000L);
            }
            catch (InterruptedException e) {
                LOG.warn("{} is interrupted during start. Exiting.", (Object)NodeLocalVolumeMonitorImpl.class.getName());
            }
            while (true) {
                LOG.info("Cleanup node local volume is starting");
                NodeLocalVolumeMonitorImpl.this.applicationSet = NodeLocalVolumeMonitorImpl.this.nmContext.getApplications().keySet();
                NodeLocalVolumeMonitorImpl.this.jobSet = new HashSet();
                for (ApplicationId appId : NodeLocalVolumeMonitorImpl.this.applicationSet) {
                    if (((Application)NodeLocalVolumeMonitorImpl.this.nmContext.getApplications().get(appId)).getApplicationState() == ApplicationState.FINISHED) continue;
                    NodeLocalVolumeMonitorImpl.this.jobSet.add(appId.toString().replaceAll("application", NodeLocalVolumeMonitorImpl.jobIdStrPrefix));
                }
                NodeLocalVolumeMonitorImpl.this.checkLocalVolumeDir();
                LOG.info("Cleanup node local volume end");
                try {
                    Thread.sleep(NodeLocalVolumeMonitorImpl.this.monitoringInterval * 1000L);
                }
                catch (InterruptedException e) {
                    LOG.warn("{} is interrupted. Exiting.", (Object)NodeLocalVolumeMonitorImpl.class.getName());
                    return;
                }
            }
        }
    }
}

