/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.net.Inet4Address;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.namenode.DefaultAuditLogger;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.HdfsAuditLogger;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestAuditLogAtDebug {
    static final Logger LOG = LoggerFactory.getLogger(TestAuditLogAtDebug.class);
    @Rule
    public Timeout timeout = new Timeout(300000);
    private static final String DUMMY_COMMAND_1 = "dummycommand1";
    private static final String DUMMY_COMMAND_2 = "dummycommand2";

    private DefaultAuditLogger makeSpyLogger(Level level, Optional<List<String>> debugCommands) {
        FSNamesystem.FSNamesystemAuditLogger logger = new FSNamesystem.FSNamesystemAuditLogger();
        HdfsConfiguration conf = new HdfsConfiguration();
        if (debugCommands.isPresent()) {
            conf.set("dfs.namenode.audit.log.debug.cmdlist", Joiner.on((String)",").join((Iterable)debugCommands.get()));
        }
        logger.initialize((Configuration)conf);
        GenericTestUtils.setLogLevel((Logger)FSNamesystem.AUDIT_LOG, (Level)level);
        return (DefaultAuditLogger)Mockito.spy((Object)logger);
    }

    private void logDummyCommandToAuditLog(HdfsAuditLogger logger, String command) {
        logger.logAuditEvent(true, "", Inet4Address.getLoopbackAddress(), command, "", "", null, null, null, null);
    }

    @Test
    public void testDebugCommandNotLoggedAtInfo() {
        DefaultAuditLogger logger = this.makeSpyLogger(Level.INFO, Optional.of(Arrays.asList(DUMMY_COMMAND_1)));
        this.logDummyCommandToAuditLog((HdfsAuditLogger)logger, DUMMY_COMMAND_1);
        ((DefaultAuditLogger)Mockito.verify((Object)logger, (VerificationMode)Mockito.never())).logAuditMessage(ArgumentMatchers.anyString());
    }

    @Test
    public void testDebugCommandLoggedAtDebug() {
        DefaultAuditLogger logger = this.makeSpyLogger(Level.DEBUG, Optional.of(Arrays.asList(DUMMY_COMMAND_1)));
        this.logDummyCommandToAuditLog((HdfsAuditLogger)logger, DUMMY_COMMAND_1);
        ((DefaultAuditLogger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)1))).logAuditMessage(ArgumentMatchers.anyString());
    }

    @Test
    public void testInfoCommandLoggedAtInfo() {
        DefaultAuditLogger logger = this.makeSpyLogger(Level.INFO, Optional.of(Arrays.asList(DUMMY_COMMAND_1)));
        this.logDummyCommandToAuditLog((HdfsAuditLogger)logger, DUMMY_COMMAND_2);
        ((DefaultAuditLogger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)1))).logAuditMessage(ArgumentMatchers.anyString());
    }

    @Test
    public void testMultipleDebugCommandsNotLoggedAtInfo() {
        DefaultAuditLogger logger = this.makeSpyLogger(Level.INFO, Optional.of(Arrays.asList(DUMMY_COMMAND_1, DUMMY_COMMAND_2)));
        this.logDummyCommandToAuditLog((HdfsAuditLogger)logger, DUMMY_COMMAND_1);
        this.logDummyCommandToAuditLog((HdfsAuditLogger)logger, DUMMY_COMMAND_2);
        ((DefaultAuditLogger)Mockito.verify((Object)logger, (VerificationMode)Mockito.never())).logAuditMessage(ArgumentMatchers.anyString());
    }

    @Test
    public void testMultipleDebugCommandsLoggedAtDebug() {
        DefaultAuditLogger logger = this.makeSpyLogger(Level.DEBUG, Optional.of(Arrays.asList(DUMMY_COMMAND_1, DUMMY_COMMAND_2)));
        this.logDummyCommandToAuditLog((HdfsAuditLogger)logger, DUMMY_COMMAND_1);
        this.logDummyCommandToAuditLog((HdfsAuditLogger)logger, DUMMY_COMMAND_2);
        ((DefaultAuditLogger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)2))).logAuditMessage(ArgumentMatchers.anyString());
    }

    @Test
    public void testEmptyDebugCommands() {
        DefaultAuditLogger logger = this.makeSpyLogger(Level.INFO, Optional.empty());
        this.logDummyCommandToAuditLog((HdfsAuditLogger)logger, DUMMY_COMMAND_1);
        this.logDummyCommandToAuditLog((HdfsAuditLogger)logger, DUMMY_COMMAND_2);
        ((DefaultAuditLogger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)2))).logAuditMessage(ArgumentMatchers.anyString());
    }
}

