/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.logging;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.logging.YarnCentralTaskLogAppender;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;

public class YarnCentralTaskRollingLogAppender
extends YarnCentralTaskLogAppender {
    protected long maxFileSize = 0xA00000L;
    protected int maxBackupIndex = 1;
    private long nextRollover = 0L;

    @Override
    protected synchronized Long getFileSizeLimit() {
        return null;
    }

    public int getMaxBackupIndex() {
        return this.maxBackupIndex;
    }

    public long getMaximumFileSize() {
        return this.maxFileSize;
    }

    public void setMaxBackupIndex(int maxBackups) {
        this.maxBackupIndex = maxBackups;
    }

    public void setMaximumFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setMaxFileSize(String value) {
        this.maxFileSize = OptionConverter.toFileSize((String)value, (long)(this.maxFileSize + 1L));
    }

    @Override
    public void append(LoggingEvent event) {
        super.append(event);
        try {
            long size = this.getFileSize();
            if (size > this.maxFileSize && size > this.nextRollover) {
                this.nextRollover = size + this.maxFileSize;
                this.rollOver();
            }
        }
        catch (IOException e) {
            LogLog.error((String)("Could not write to: " + this.fileNamePath + ". Failing over to local logging"), (Throwable)e);
            this.failoverToLocalLogs(e);
        }
        catch (Throwable t) {
            LogLog.error((String)"Fatal error while trying to write to maprfs. Failing over to local logging", (Throwable)t);
            this.failoverToLocalLogs(t);
        }
    }

    private void rollOver() throws IOException {
        if (this.maxBackupIndex > 0) {
            if (this.maprFS.exists(new Path(this.fileNamePath.toString() + '.' + this.maxBackupIndex))) {
                this.maprFS.delete(new Path(this.fileNamePath.toString() + '.' + this.maxBackupIndex), true);
            }
            for (int i = this.maxBackupIndex - 1; i > 0; --i) {
                if (!this.maprFS.exists(new Path(this.fileNamePath.toString() + '.' + i))) continue;
                this.maprFS.rename(new Path(this.fileNamePath.toString() + '.' + i), new Path(this.fileNamePath.toString() + '.' + (i + 1)));
            }
            this.closeFile();
            if (this.maprFS.rename(this.fileNamePath, new Path(this.fileNamePath.toString() + '.' + 1))) {
                this.createFile(this.fileNamePath);
                this.nextRollover = 0L;
            } else {
                LogLog.error((String)("Unable to rename from: " + this.fileNamePath + " to: " + this.fileNamePath.toString() + '.' + 1));
                this.maprFS.append(this.fileNamePath);
            }
        }
    }
}

