/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.domain;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Column;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.GenericConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ValueConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.domain.DomainColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.domain.DomainTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.Attribute;

public enum DomainColumn implements Column<DomainTable>
{
    CREATED_TIME(DomainColumnFamily.INFO, "created_time"),
    DESCRIPTION(DomainColumnFamily.INFO, "description"),
    MODIFICATION_TIME(DomainColumnFamily.INFO, "modification_time"),
    OWNER(DomainColumnFamily.INFO, "owner"),
    READERS(DomainColumnFamily.INFO, "readers"),
    WRITERS(DomainColumnFamily.INFO, "writers");

    private final ColumnFamily<DomainTable> columnFamily;
    private final String columnQualifier;
    private final byte[] columnQualifierBytes;
    private final ValueConverter valueConverter;

    private DomainColumn(ColumnFamily<DomainTable> columnFamily, String columnQualifier) {
        this.columnFamily = columnFamily;
        this.columnQualifier = columnQualifier;
        this.columnQualifierBytes = Bytes.toBytes((String)Separator.SPACE.encode(columnQualifier));
        this.valueConverter = GenericConverter.getInstance();
    }

    private String getColumnQualifier() {
        return this.columnQualifier;
    }

    @Override
    public byte[] getColumnQualifierBytes() {
        return (byte[])this.columnQualifierBytes.clone();
    }

    @Override
    public byte[] getColumnFamilyBytes() {
        return this.columnFamily.getBytes();
    }

    @Override
    public ValueConverter getValueConverter() {
        return this.valueConverter;
    }

    @Override
    public Attribute[] getCombinedAttrsWithAggr(Attribute ... attributes) {
        return attributes;
    }

    @Override
    public boolean supplementCellTimestamp() {
        return false;
    }
}

