/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.volume.csi.provisioner;

import java.util.List;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.event.ControllerPublishVolumeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.event.ValidateVolumeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.lifecycle.Volume;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.provisioner.VolumeProvisioner;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.provisioner.VolumeProvisioningResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolumeProvisioningTask
implements VolumeProvisioner {
    private static final Logger LOG = LoggerFactory.getLogger(VolumeProvisioningTask.class);
    private List<Volume> volumes;

    public VolumeProvisioningTask(List<Volume> volumes) {
        this.volumes = volumes;
    }

    public List<Volume> getVolumes() {
        return this.volumes;
    }

    @Override
    public VolumeProvisioningResults call() throws Exception {
        VolumeProvisioningResults vpr = new VolumeProvisioningResults();
        for (Volume vs : this.volumes) {
            LOG.info("Provisioning volume : {}", (Object)vs.getVolumeId().toString());
            vs.handle((Event)new ValidateVolumeEvent(vs));
            vs.handle((Event)new ControllerPublishVolumeEvent(vs));
        }
        this.volumes.stream().forEach(v -> vpr.addResult(v.getVolumeId(), v.getVolumeState()));
        return vpr;
    }
}

