/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableResolver;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterAdminServer;
import org.apache.hadoop.hdfs.server.federation.router.RouterSafemodeService;
import org.apache.hadoop.hdfs.server.federation.router.RouterServiceState;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUnavailableException;
import org.apache.hadoop.hdfs.server.federation.store.protocol.EnterSafeModeRequest;
import org.apache.hadoop.hdfs.tools.federation.RouterAdmin;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestRouterSafemode {
    private Router router;
    private static Configuration conf;

    @BeforeClass
    public static void create() throws IOException {
        FederationStateStoreTestUtils.deleteStateStore();
        conf = FederationStateStoreTestUtils.getStateStoreConfiguration();
        conf.setTimeDuration("dfs.federation.router.safemode.extension", TimeUnit.SECONDS.toMillis(2L), TimeUnit.MILLISECONDS);
        conf.setTimeDuration("dfs.federation.router.cache.ttl", 200L, TimeUnit.MILLISECONDS);
        conf.setTimeDuration("dfs.federation.router.safemode.expiration", TimeUnit.SECONDS.toMillis(1L), TimeUnit.MILLISECONDS);
        conf.set("dfs.federation.router.rpc-bind-host", "0.0.0.0");
        conf.set("dfs.federation.router.rpc-address", "127.0.0.1:0");
        conf.set("dfs.federation.router.admin-address", "127.0.0.1:0");
        conf.set("dfs.federation.router.admin-bind-host", "0.0.0.0");
        conf.set("dfs.federation.router.http-address", "127.0.0.1:0");
        conf.set("dfs.federation.router.https-address", "127.0.0.1:0");
        conf = new RouterConfigBuilder(conf).rpc().admin().safemode().stateStore().metrics().build();
    }

    @AfterClass
    public static void destroy() {
    }

    @Before
    public void setup() throws IOException, URISyntaxException {
        this.router = new Router();
        this.router.init(conf);
        this.router.start();
    }

    @After
    public void cleanup() throws IOException {
        if (this.router != null) {
            this.router.stop();
            this.router = null;
        }
    }

    @Test
    public void testSafemodeService() throws IOException {
        RouterSafemodeService server = new RouterSafemodeService(this.router);
        server.init(conf);
        Assert.assertEquals((Object)Service.STATE.INITED, (Object)server.getServiceState());
        server.start();
        Assert.assertEquals((Object)Service.STATE.STARTED, (Object)server.getServiceState());
        server.stop();
        Assert.assertEquals((Object)Service.STATE.STOPPED, (Object)server.getServiceState());
        server.close();
    }

    @Test
    public void testRouterExitSafemode() throws InterruptedException, IllegalStateException, IOException {
        Assert.assertTrue((boolean)this.router.getSafemodeService().isInSafeMode());
        this.verifyRouter(RouterServiceState.SAFEMODE);
        long interval = conf.getTimeDuration("dfs.federation.router.safemode.extension", TimeUnit.SECONDS.toMillis(2L), TimeUnit.MILLISECONDS) + conf.getTimeDuration("dfs.federation.router.cache.ttl", TimeUnit.SECONDS.toMillis(1L), TimeUnit.MILLISECONDS);
        Thread.sleep(interval);
        Assert.assertFalse((boolean)this.router.getSafemodeService().isInSafeMode());
        this.verifyRouter(RouterServiceState.RUNNING);
    }

    @Test
    public void testRouterEnterSafemode() throws IllegalStateException, IOException, InterruptedException {
        Assert.assertTrue((boolean)this.router.getSafemodeService().isInSafeMode());
        this.verifyRouter(RouterServiceState.SAFEMODE);
        long interval0 = conf.getTimeDuration("dfs.federation.router.safemode.extension", TimeUnit.SECONDS.toMillis(2L), TimeUnit.MILLISECONDS) - 1000L;
        long t0 = Time.now();
        while (Time.now() - t0 < interval0) {
            this.verifyRouter(RouterServiceState.SAFEMODE);
            Thread.sleep(100L);
        }
        long interval1 = 1000L + 2L * conf.getTimeDuration("dfs.federation.router.cache.ttl", TimeUnit.SECONDS.toMillis(1L), TimeUnit.MILLISECONDS);
        Thread.sleep(interval1);
        Assert.assertFalse((boolean)this.router.getSafemodeService().isInSafeMode());
        this.verifyRouter(RouterServiceState.RUNNING);
        this.router.getStateStore().stopCacheUpdateService();
        long interval2 = conf.getTimeDuration("dfs.federation.router.safemode.expiration", TimeUnit.SECONDS.toMillis(2L), TimeUnit.MILLISECONDS) + 2L * conf.getTimeDuration("dfs.federation.router.cache.ttl", TimeUnit.SECONDS.toMillis(1L), TimeUnit.MILLISECONDS);
        Thread.sleep(interval2);
        Assert.assertTrue((boolean)this.router.getSafemodeService().isInSafeMode());
        this.verifyRouter(RouterServiceState.SAFEMODE);
    }

    @Test
    public void testRouterRpcSafeMode() throws IllegalStateException, IOException {
        Assert.assertTrue((boolean)this.router.getSafemodeService().isInSafeMode());
        this.verifyRouter(RouterServiceState.SAFEMODE);
        boolean exception = false;
        try {
            this.router.getRpcServer().delete("/testfile.txt", true);
            Assert.fail((String)"We should have thrown a safe mode exception");
        }
        catch (StandbyException sme) {
            exception = true;
        }
        Assert.assertTrue((String)"We should have thrown a safe mode exception", (boolean)exception);
    }

    @Test
    public void testRouterManualSafeMode() throws Exception {
        InetSocketAddress adminAddr = this.router.getAdminServerAddress();
        conf.setSocketAddr("dfs.federation.router.admin-address", adminAddr);
        RouterAdmin admin = new RouterAdmin(conf);
        Assert.assertTrue((boolean)this.router.getSafemodeService().isInSafeMode());
        this.verifyRouter(RouterServiceState.SAFEMODE);
        long interval = conf.getTimeDuration("dfs.federation.router.safemode.extension", TimeUnit.SECONDS.toMillis(2L), TimeUnit.MILLISECONDS) + 300L;
        Thread.sleep(interval);
        this.verifyRouter(RouterServiceState.RUNNING);
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-safemode", "enter"}));
        this.verifyRouter(RouterServiceState.SAFEMODE);
        interval = 2L * conf.getTimeDuration("dfs.federation.router.cache.ttl", TimeUnit.SECONDS.toMillis(1L), TimeUnit.MILLISECONDS);
        Thread.sleep(interval);
        this.verifyRouter(RouterServiceState.SAFEMODE);
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-safemode", "leave"}));
        this.verifyRouter(RouterServiceState.RUNNING);
    }

    private void verifyRouter(RouterServiceState status) throws IllegalStateException, IOException {
        Assert.assertEquals((Object)status, (Object)this.router.getRouterState());
    }

    @Test
    public void testRouterNotInitMountTable() throws Exception {
        MountTableResolver mountTable = (MountTableResolver)this.router.getSubclusterResolver();
        mountTable.setDisabled(true);
        int interval = 2 * (int)conf.getTimeDuration("dfs.federation.router.safemode.extension", TimeUnit.SECONDS.toMillis(2L), TimeUnit.MILLISECONDS);
        GenericTestUtils.waitFor(() -> this.router.getRouterState() == RouterServiceState.RUNNING, (long)100L, (long)interval);
        try {
            this.router.getRpcServer().getFileInfo("/mnt/file.txt");
            Assert.fail((String)"We should have thrown StateStoreUnavailableException");
        }
        catch (StateStoreUnavailableException e) {
            Assert.assertEquals((Object)"Mount Table not initialized", (Object)e.getMessage());
        }
        RouterAdminServer admin = this.router.getAdminServer();
        EnterSafeModeRequest request = EnterSafeModeRequest.newInstance();
        admin.enterSafeMode(request);
        this.verifyRouter(RouterServiceState.SAFEMODE);
        try {
            this.router.getRpcServer().getFileInfo("/mnt/file.txt");
            Assert.fail((String)"We should have thrown a safe mode exception");
        }
        catch (StandbyException e) {
            String msg = e.getMessage();
            Assert.assertTrue((String)("Wrong message: " + msg), (boolean)msg.endsWith("is in safe mode and cannot handle READ requests"));
        }
    }
}

