/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.conf;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.util.MapRCommonSecurityUtil;

public class MapReduceDefaultProperties
extends Properties {
    public static final String CLUSTER_NAME_PREFIX = "cluster.name.prefix";
    private static final Map<String, String> props;
    private static final long IO_SORT_XMX_THRESHOLD = 0x32000000L;
    private static final String IO_SORT_MB_MIN = "100";
    private static final String IO_SORT_MB_MAX = "480";

    private static String getIoSortMb() {
        return Runtime.getRuntime().maxMemory() >= 0x32000000L ? IO_SORT_MB_MAX : IO_SORT_MB_MIN;
    }

    public static Properties getProperties() {
        Properties properties = new Properties();
        properties.putAll(props);
        return properties;
    }

    public MapReduceDefaultProperties() {
        this.putAll(props);
    }

    static {
        String name;
        props = new HashMap<String, String>();
        props.put("mapreduce.framework.name", "yarn");
        props.put("yarn.app.mapreduce.am.staging-dir", "${yarn.resourcemanager.staging}");
        props.put("mapreduce.task.local.output.class", "org.apache.hadoop.mapred.MapRFsOutputFile");
        props.put("mapreduce.job.map.output.collector.class", "org.apache.hadoop.mapred.MapRFsOutputBuffer");
        props.put("mapreduce.job.reduce.shuffle.consumer.plugin.class", "org.apache.hadoop.mapreduce.task.reduce.DirectShuffle");
        props.put("mapred.ifile.outputstream", "org.apache.hadoop.mapred.MapRIFileOutputStream");
        props.put("mapred.ifile.inputstream", "org.apache.hadoop.mapred.MapRIFileInputStream");
        props.put("mapred.local.mapoutput", "false");
        props.put("mapreduce.job.shuffle.provider.services", "mapr_direct_shuffle");
        if (System.getProperty(CLUSTER_NAME_PREFIX) != null) {
            props.put(CLUSTER_NAME_PREFIX, System.getProperty(CLUSTER_NAME_PREFIX));
            name = System.getProperty(CLUSTER_NAME_PREFIX) + "/nodeManager";
        } else {
            name = "nodeManager";
        }
        props.put("mapr.mapred.localvolume.root.dir.name", name);
        props.put("mapr.localoutput.dir", "output");
        props.put("mapr.localspill.dir", "spill");
        props.put("mapred.maxthreads.generate.mapoutput", "1");
        props.put("mapred.maxthreads.partition.closer", "1");
        props.put("mapr.map.keyprefix.ints", "1");
        props.put("mapreduce.map.output.compress", "false");
        props.put("mapreduce.map.speculative", "true");
        props.put("mapreduce.reduce.speculative", "true");
        props.put("yarn.app.mapreduce.am.env", "HADOOP_MAPRED_HOME=${HADOOP_HOME}");
        props.put("mapreduce.map.env", "HADOOP_MAPRED_HOME=${HADOOP_HOME}");
        props.put("mapreduce.reduce.env", "HADOOP_MAPRED_HOME=${HADOOP_HOME}");
        props.put("mapreduce.map.memory.mb", "1024");
        props.put("mapreduce.map.cpu.vcores", "1");
        props.put("mapreduce.map.java.opts", "-Xmx900m --add-opens java.base/java.lang=ALL-UNNAMED -XX:+UseParallelGC");
        props.put("mapreduce.task.io.sort.mb", MapReduceDefaultProperties.getIoSortMb());
        props.put("mapreduce.task.io.sort.factor", "256");
        props.put("mapreduce.map.sort.spill.percent", "0.99");
        props.put("io.sort.record.percent", "0.17");
        props.put("mapreduce.reduce.memory.mb", "3072");
        props.put("mapreduce.reduce.cpu.vcores", "1");
        props.put("mapreduce.reduce.java.opts", "-Xmx2560m --add-opens java.base/java.lang=ALL-UNNAMED -XX:+UseParallelGC");
        props.put("mapreduce.job.reduce.slowstart.completedmaps", "1.00");
        props.put("mapreduce.reduce.shuffle.parallelcopies", "12");
        String http_scheme = HttpConfig.Policy.HTTP_ONLY.name();
        if (MapRCommonSecurityUtil.getInstance().isSecurityEnabled()) {
            http_scheme = HttpConfig.Policy.HTTPS_ONLY.name();
        }
        props.put("mapreduce.jobhistory.http.policy", http_scheme);
    }
}

