/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
public enum AuthMethod {
    SIMPLE(80, "", UserGroupInformation.AuthenticationMethod.SIMPLE),
    KERBEROS(81, "GSSAPI", UserGroupInformation.AuthenticationMethod.KERBEROS),
    DIGEST(82, "DIGEST-MD5", UserGroupInformation.AuthenticationMethod.TOKEN),
    MAPRSASL(83, "MAPR-SECURITY", UserGroupInformation.AuthenticationMethod.CUSTOM);

    public final byte code;
    public final String mechanismName;
    public final UserGroupInformation.AuthenticationMethod authenticationMethod;
    private static final int FIRST_CODE;

    private AuthMethod(byte code, String mechanismName, UserGroupInformation.AuthenticationMethod authMethod) {
        this.code = code;
        this.mechanismName = mechanismName;
        this.authenticationMethod = authMethod;
    }

    public static AuthMethod valueOf(byte code) {
        int i = (code & 0xFF) - FIRST_CODE;
        return i < 0 || i >= AuthMethod.values().length ? null : AuthMethod.values()[i];
    }

    public String getMechanismName() {
        return this.mechanismName;
    }

    public static AuthMethod read(DataInput in) throws IOException {
        return AuthMethod.valueOf(in.readByte());
    }

    public void write(DataOutput out) throws IOException {
        out.write(this.code);
    }

    static {
        FIRST_CODE = AuthMethod.values()[0].code;
    }
}

