/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.maprfs.AbstractMapRFileSystem;
import org.apache.hadoop.security.authorize.UsersACLsManager;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class LogAggregationUtils {
    public static final Logger LOG = LoggerFactory.getLogger(LogAggregationUtils.class);
    public static final String TMP_FILE_SUFFIX = ".tmp";
    private static final String BUCKET_SUFFIX = "bucket-";
    public static final String LOG_PATH_FOR_LOCAL_VOLUME = "/mapred/nodeManager/logs/";

    public static Path getRemoteNodeLogFileForApp(Path remoteRootLogDir, ApplicationId appId, String user, NodeId nodeId, String suffix) {
        return new Path(LogAggregationUtils.getRemoteAppLogDir(remoteRootLogDir, appId, user, suffix), LogAggregationUtils.getNodeString(nodeId));
    }

    public static Path getRemoteAppLogDir(Path remoteRootLogDir, ApplicationId appId, String user, String suffix) {
        return new Path(LogAggregationUtils.getRemoteBucketDir(remoteRootLogDir, user, suffix, appId), appId.toString());
    }

    public static Path getOlderRemoteAppLogDir(ApplicationId appId, String user, Path remoteRootLogDir, String suffix) {
        return new Path(LogAggregationUtils.getOlderRemoteLogSuffixedDir(remoteRootLogDir, user, suffix), appId.toString());
    }

    public static Path getOlderRemoteAppLogDir(Configuration conf, ApplicationId appId, String user, Path remoteRootLogDir, String suffix) throws IOException {
        Path remoteAppDir = null;
        if (user == null) {
            Path qualifiedRemoteRootLogDir = FileContext.getFileContext((Configuration)conf).makeQualified(remoteRootLogDir);
            FileContext fc = FileContext.getFileContext((URI)qualifiedRemoteRootLogDir.toUri(), (Configuration)conf);
            Path toMatch = LogAggregationUtils.getOlderRemoteAppLogDir(appId, "*", remoteRootLogDir, suffix);
            FileStatus[] matching = fc.util().globStatus(toMatch);
            if (matching == null || matching.length != 1) {
                throw new IOException("Can not find remote application directory for the application:" + appId);
            }
            remoteAppDir = matching[0].getPath();
        } else {
            remoteAppDir = LogAggregationUtils.getOlderRemoteAppLogDir(appId, user, remoteRootLogDir, suffix);
        }
        return remoteAppDir;
    }

    public static Path getRemoteLogSuffixedDir(Path remoteRootLogDir, String user, String suffix) {
        suffix = LogAggregationUtils.getBucketSuffix() + suffix;
        return new Path(LogAggregationUtils.getRemoteLogUserDir(remoteRootLogDir, user), suffix);
    }

    public static Path getOlderRemoteLogSuffixedDir(Path remoteRootLogDir, String user, String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            return LogAggregationUtils.getRemoteLogUserDir(remoteRootLogDir, user);
        }
        return new Path(LogAggregationUtils.getRemoteLogUserDir(remoteRootLogDir, user), suffix);
    }

    public static Path getRemoteLogUserDir(Path remoteRootLogDir, String user) {
        return new Path(remoteRootLogDir, user);
    }

    public static Path getRemoteBucketDir(Path remoteRootLogDir, String user, String suffix, ApplicationId appId) {
        int bucket = appId.getId() % 10000;
        String bucketDir = String.format("%04d", bucket);
        return new Path(LogAggregationUtils.getRemoteLogSuffixedDir(remoteRootLogDir, user, suffix), bucketDir);
    }

    public static boolean isOlderPathEnabled(Configuration conf) {
        return conf.getBoolean("yarn.nodemanager.remote-app-log-dir-include-older", true);
    }

    public static String getBucketSuffix() {
        return BUCKET_SUFFIX;
    }

    @VisibleForTesting
    public static String getNodeString(NodeId nodeId) {
        return nodeId.toString().replace(":", "_");
    }

    @VisibleForTesting
    public static String getNodeString(String nodeId) {
        return nodeId.toString().replace(":", "_");
    }

    public static Path getRemoteAppLogDir(Configuration conf, ApplicationId appId, String appOwner, Path remoteRootLogDir, String suffix) throws IOException {
        Path remoteAppDir = null;
        if (appOwner == null) {
            Path qualifiedRemoteRootLogDir = FileContext.getFileContext((Configuration)conf).makeQualified(remoteRootLogDir);
            FileContext fc = FileContext.getFileContext((URI)qualifiedRemoteRootLogDir.toUri(), (Configuration)conf);
            Path toMatch = LogAggregationUtils.getRemoteAppLogDir(remoteRootLogDir, appId, "*", suffix);
            FileStatus[] matching = fc.util().globStatus(toMatch);
            if (matching == null || matching.length != 1) {
                throw new IOException("Can not find remote application directory for the application:" + appId);
            }
            remoteAppDir = matching[0].getPath();
        } else {
            remoteAppDir = LogAggregationUtils.getRemoteAppLogDir(remoteRootLogDir, appId, appOwner, suffix);
        }
        return remoteAppDir;
    }

    public static RemoteIterator<FileStatus> getNodeFiles(Configuration conf, Path remoteAppLogDir, ApplicationId appId, String appOwner) throws IOException {
        Path qualifiedLogDir = FileContext.getFileContext((Configuration)conf).makeQualified(remoteAppLogDir);
        return FileContext.getFileContext((URI)qualifiedLogDir.toUri(), (Configuration)conf).listStatus(remoteAppLogDir);
    }

    public static RemoteIterator<FileStatus> getRemoteNodeFileDir(Configuration conf, ApplicationId appId, String appOwner, Path remoteRootLogDir, String suffix, String oldSuffix) throws IOException {
        Path remoteAppLogDir;
        RemoteIterator<FileStatus> nodeFilesCur = null;
        RemoteIterator<FileStatus> nodeFilesPrev = null;
        StringBuilder diagnosticsMsg = new StringBuilder();
        try {
            remoteAppLogDir = LogAggregationUtils.getRemoteAppLogDir(conf, appId, appOwner, remoteRootLogDir, suffix);
            nodeFilesCur = LogAggregationUtils.getNodeFiles(conf, remoteAppLogDir, appId, appOwner);
        }
        catch (IOException ex) {
            diagnosticsMsg.append(ex.getMessage() + "\n");
        }
        if (LogAggregationUtils.isOlderPathEnabled(conf)) {
            try {
                remoteAppLogDir = LogAggregationUtils.getOlderRemoteAppLogDir(conf, appId, appOwner, remoteRootLogDir, oldSuffix);
                nodeFilesPrev = LogAggregationUtils.getNodeFiles(conf, remoteAppLogDir, appId, appOwner);
            }
            catch (IOException ex) {
                diagnosticsMsg.append(ex.getMessage() + "\n");
            }
            if (nodeFilesCur == null) {
                return nodeFilesPrev;
            }
            if (nodeFilesPrev != null) {
                final RemoteIterator<FileStatus> curDir = nodeFilesCur;
                final RemoteIterator<FileStatus> prevDir = nodeFilesPrev;
                RemoteIterator<FileStatus> nodeFilesCombined = new RemoteIterator<FileStatus>(){

                    public boolean hasNext() throws IOException {
                        return prevDir.hasNext() || curDir.hasNext();
                    }

                    public FileStatus next() throws IOException {
                        return prevDir.hasNext() ? (FileStatus)prevDir.next() : (FileStatus)curDir.next();
                    }
                };
                return nodeFilesCombined;
            }
        }
        if (nodeFilesCur == null) {
            throw new IOException(diagnosticsMsg.toString());
        }
        return nodeFilesCur;
    }

    public static List<FileStatus> getRemoteNodeFileList(Configuration conf, ApplicationId appId, String appOwner, Path remoteRootLogDir, String suffix, String oldSuffix) throws IOException {
        Path qualifiedLogDir;
        Path remoteAppLogDir;
        StringBuilder diagnosticsMsg = new StringBuilder();
        ArrayList<FileStatus> nodeFiles = new ArrayList<FileStatus>();
        try {
            remoteAppLogDir = LogAggregationUtils.getRemoteAppLogDir(conf, appId, appOwner, remoteRootLogDir, suffix);
            qualifiedLogDir = FileContext.getFileContext((Configuration)conf).makeQualified(remoteAppLogDir);
            nodeFiles.addAll(Arrays.asList(FileContext.getFileContext((URI)qualifiedLogDir.toUri(), (Configuration)conf).util().listStatus(remoteAppLogDir)));
        }
        catch (IOException ex) {
            diagnosticsMsg.append(ex.getMessage() + "\n");
        }
        if (LogAggregationUtils.isOlderPathEnabled(conf)) {
            try {
                remoteAppLogDir = LogAggregationUtils.getOlderRemoteAppLogDir(conf, appId, appOwner, remoteRootLogDir, oldSuffix);
                qualifiedLogDir = FileContext.getFileContext((Configuration)conf).makeQualified(remoteAppLogDir);
                nodeFiles.addAll(Arrays.asList(FileContext.getFileContext((URI)qualifiedLogDir.toUri(), (Configuration)conf).util().listStatus(remoteAppLogDir)));
            }
            catch (IOException ex) {
                diagnosticsMsg.append(ex.getMessage() + "\n");
            }
        }
        if (nodeFiles.isEmpty()) {
            throw new IOException(diagnosticsMsg.toString());
        }
        return nodeFiles;
    }

    public static void initACLForAggregatedLogs(Configuration conf, UsersACLsManager usersAclsManager, Path rootDir) {
        try {
            LOG.info("Overwrite all ACE for directory: {}", (Object)rootDir.toString());
            FileSystem fs = FileSystem.get((Configuration)conf);
            if (fs instanceof AbstractMapRFileSystem && fs.exists(rootDir)) {
                FileStatus[] directories;
                AbstractMapRFileSystem mfs = (AbstractMapRFileSystem)fs;
                for (FileStatus dir : directories = mfs.listStatus(rootDir)) {
                    String ace;
                    String username = dir.getPath().getName();
                    if (!Shell.checkUserExists((String)username) || (ace = usersAclsManager.buildACEStrForUser(username)).isEmpty()) continue;
                    mfs.setAces(dir.getPath(), ace, true, 0, 1, true);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Can't initialize FS for aggregation logs.", e);
        }
    }

    public static void cleanAllACE(Configuration conf, Path rootDir) {
        LOG.info("Remove all ACE for directory: {}", (Object)rootDir.toString());
        try {
            FileSystem fs = FileSystem.get((Configuration)conf);
            if (fs instanceof AbstractMapRFileSystem && fs.exists(rootDir)) {
                FileStatus[] directories;
                AbstractMapRFileSystem mfs = (AbstractMapRFileSystem)fs;
                for (FileStatus dir : directories = mfs.listStatus(rootDir)) {
                    String username = dir.getPath().getName();
                    if (!Shell.checkUserExists((String)username)) continue;
                    mfs.deleteAces(dir.getPath(), false);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Can't initialize FS for aggregation logs.", e);
        }
    }

    public static void checkACLConf(boolean isUsersACLEnable, boolean forceInit, Configuration conf, Path rootDir) {
        if (isUsersACLEnable && !forceInit) {
            try {
                FileSystem fs = FileSystem.get((Configuration)conf);
                if (fs instanceof AbstractMapRFileSystem && fs.exists(rootDir) && fs.listStatus(rootDir).length > 0) {
                    LOG.warn("ACE for user aggregation log was enabled, but root directory doesn't empty or hadoop.users.acl.force.init property set to false. User's mapping ACE for logs possibly will not work. Please check configuration.");
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Can't initialize FileSystem.", e);
            }
        }
    }
}

