/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.amrmproxy;

import java.util.Map;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.AbstractConfigurableFederationPolicy;
import org.apache.hadoop.yarn.server.federation.policies.amrmproxy.FederationAMRMProxyPolicy;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;

public abstract class AbstractAMRMProxyPolicy
extends AbstractConfigurableFederationPolicy
implements FederationAMRMProxyPolicy {
    @Override
    public void validate(WeightedPolicyInfo newPolicyInfo) throws FederationPolicyInitializationException {
        super.validate(newPolicyInfo);
        Map<SubClusterIdInfo, Float> newWeights = newPolicyInfo.getAMRMPolicyWeights();
        if (newWeights == null || newWeights.size() < 1) {
            throw new FederationPolicyInitializationException("Weight vector cannot be null/empty.");
        }
    }

    @Override
    public void notifyOfResponse(SubClusterId subClusterId, AllocateResponse response) throws YarnException {
    }
}

