/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.utils;

import java.lang.reflect.Array;
import java.util.Arrays;

public final class ArrayUtils {
    public static int binarySearch(int[] a, int fromIndex, int toIndex, int key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low;
    }

    public static <T> T[] addUnique(T[] array, T element) {
        return ArrayUtils.addUnique(array, element, true);
    }

    public static <T> T[] addUnique(T[] array, T element, boolean replaceElementIfEquals) {
        int idx = ArrayUtils.indexOf(array, element);
        if (idx == -1) {
            int length = array.length;
            T[] newArray = Arrays.copyOf(array, length + 1);
            newArray[length] = element;
            return newArray;
        }
        if (replaceElementIfEquals) {
            array[idx] = element;
        }
        return array;
    }

    public static <T> T[] remove(T[] array, Object element) {
        int idx = ArrayUtils.indexOf(array, element);
        if (idx != -1) {
            int length = array.length;
            if (length == 1) {
                return null;
            }
            Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), length - 1);
            if (idx > 0) {
                System.arraycopy(array, 0, newArray, 0, idx);
            }
            if (idx < length - 1) {
                System.arraycopy(array, idx + 1, newArray, idx, length - idx - 1);
            }
            return newArray;
        }
        return array;
    }

    public static <T> int indexOf(T[] array, Object element) {
        for (int i = 0; i < array.length; ++i) {
            if (!element.equals(array[i])) continue;
            return i;
        }
        return -1;
    }
}

