/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.dynamometer.workloadgenerator;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.tools.dynamometer.workloadgenerator.WorkloadMapper;
import org.apache.hadoop.tools.dynamometer.workloadgenerator.audit.AuditReplayMapper;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkloadDriver
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(WorkloadDriver.class);
    public static final String START_TIMESTAMP_MS = "start_timestamp_ms";
    public static final String START_TIME_OFFSET = "start_time_offset";
    public static final String START_TIME_OFFSET_DEFAULT = "1m";
    public static final String NN_URI = "nn_uri";
    public static final String MAPPER_CLASS_NAME = "mapper_class_name";

    public int run(String[] args) throws Exception {
        long startTimestampMs;
        Option helpOption = new Option("h", "help", false, "Shows this message. Additionally specify the mapper_class_name argument to show help for a specific mapper class.");
        Options options = new Options();
        options.addOption(helpOption);
        OptionBuilder.withArgName((String)"NN URI");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"URI of the NameNode under test");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)NN_URI));
        OptionGroup startTimeOptions = new OptionGroup();
        OptionBuilder.withArgName((String)"Start Timestamp");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Mapper start UTC timestamp in ms");
        startTimeOptions.addOption(OptionBuilder.create((String)START_TIMESTAMP_MS));
        OptionBuilder.withArgName((String)"Start Time Offset");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Mapper start time as an offset from current time. Human-readable formats accepted, e.g. 10m (default 1m).");
        startTimeOptions.addOption(OptionBuilder.create((String)START_TIME_OFFSET));
        options.addOptionGroup(startTimeOptions);
        OptionBuilder.withArgName((String)"Mapper ClassName");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Class name of the mapper; must be a WorkloadMapper subclass. Mappers supported currently: \n1. AuditReplayMapper \n2. CreateFileMapper \nFully specified class names are also supported.");
        OptionBuilder.isRequired();
        Option mapperClassOption = OptionBuilder.create((String)MAPPER_CLASS_NAME);
        options.addOption(mapperClassOption);
        Options helpOptions = new Options();
        helpOptions.addOption(helpOption);
        Option mapperClassNotRequiredOption = (Option)mapperClassOption.clone();
        mapperClassNotRequiredOption.setRequired(false);
        helpOptions.addOption(mapperClassNotRequiredOption);
        PosixParser parser = new PosixParser();
        CommandLine cli = parser.parse(helpOptions, args, true);
        if (cli.hasOption("h")) {
            String footer = null;
            if (cli.hasOption(MAPPER_CLASS_NAME)) {
                footer = this.getMapperUsageInfo(cli.getOptionValue(MAPPER_CLASS_NAME));
            }
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(200, "./start-workload [options]", null, options, footer);
            return 1;
        }
        cli = parser.parse(options, args);
        String nnURI = cli.getOptionValue(NN_URI);
        if (cli.hasOption(START_TIMESTAMP_MS)) {
            startTimestampMs = Long.parseLong(cli.getOptionValue(START_TIMESTAMP_MS));
        } else {
            String tmpConfKey = "___temp_config_property___";
            Configuration tmpConf = new Configuration();
            tmpConf.set(tmpConfKey, cli.getOptionValue(START_TIME_OFFSET, START_TIME_OFFSET_DEFAULT));
            startTimestampMs = tmpConf.getTimeDuration(tmpConfKey, 0L, TimeUnit.MILLISECONDS) + System.currentTimeMillis();
        }
        Class<WorkloadMapper<?, ?, ?, ?>> mapperClass = this.getMapperClass(cli.getOptionValue(MAPPER_CLASS_NAME));
        if (!mapperClass.newInstance().verifyConfigurations(this.getConf())) {
            System.err.println(this.getMapperUsageInfo(cli.getOptionValue(MAPPER_CLASS_NAME)));
            return 1;
        }
        Job job = WorkloadDriver.getJobForSubmission(this.getConf(), nnURI, startTimestampMs, mapperClass);
        boolean success = job.waitForCompletion(true);
        return success ? 0 : 1;
    }

    public static Job getJobForSubmission(Configuration baseConf, String nnURI, long startTimestampMs, Class<? extends WorkloadMapper<?, ?, ?, ?>> mapperClass) throws IOException, InstantiationException, IllegalAccessException {
        Configuration conf = new Configuration(baseConf);
        conf.set(NN_URI, nnURI);
        conf.setBoolean("mapreduce.map.speculative", false);
        String startTimeString = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss z").format(new Date(startTimestampMs));
        LOG.info("The workload will start at " + startTimestampMs + " ms (" + startTimeString + ")");
        conf.setLong(START_TIMESTAMP_MS, startTimestampMs);
        Job job = Job.getInstance((Configuration)conf, (String)"Dynamometer Workload Driver");
        job.setJarByClass(mapperClass);
        job.setMapperClass(mapperClass);
        mapperClass.newInstance().configureJob(job);
        return job;
    }

    public static void main(String[] args) throws Exception {
        WorkloadDriver driver = new WorkloadDriver();
        System.exit(ToolRunner.run((Tool)driver, (String[])args));
    }

    private Class<? extends WorkloadMapper<?, ?, ?, ?>> getMapperClass(String className) {
        String[] potentialQualifiedClassNames;
        for (String qualifiedClassName : potentialQualifiedClassNames = new String[]{WorkloadDriver.class.getPackage().getName() + "." + className, AuditReplayMapper.class.getPackage().getName() + "." + className, className}) {
            Class mapperClass;
            try {
                mapperClass = this.getConf().getClassByName(qualifiedClassName);
            }
            catch (ClassNotFoundException cnfe) {
                continue;
            }
            if (!WorkloadMapper.class.isAssignableFrom(mapperClass)) {
                throw new IllegalArgumentException(className + " is not a subclass of " + WorkloadMapper.class.getCanonicalName());
            }
            return mapperClass;
        }
        throw new IllegalArgumentException("Unable to find workload mapper class: " + className);
    }

    private String getMapperUsageInfo(String mapperClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        WorkloadMapper<?, ?, ?, ?> mapper = this.getMapperClass(mapperClassName).newInstance();
        StringBuilder builder = new StringBuilder("Usage for ");
        builder.append(((Object)mapper).getClass().getSimpleName());
        builder.append(":\n");
        builder.append(mapper.getDescription());
        for (String configDescription : mapper.getConfigDescriptions()) {
            builder.append("\n    ");
            builder.append(configDescription);
        }
        builder.append("\nConfiguration parameters can be set at the ");
        builder.append("_start_ of the argument list like:\n");
        builder.append("  -Dconfiguration.key=configurationValue");
        return builder.toString();
    }
}

