/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.ConsistencyLevel;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.Error;
import com.microsoft.azure.cosmosdb.ISessionContainer;
import com.microsoft.azure.cosmosdb.internal.OperationType;
import com.microsoft.azure.cosmosdb.internal.PathsHelper;
import com.microsoft.azure.cosmosdb.internal.QueryCompatibilityMode;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.UserAgentContainer;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.HttpUtils;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreResponse;
import com.microsoft.azure.cosmosdb.rx.internal.BackoffRetryUtility;
import com.microsoft.azure.cosmosdb.rx.internal.Exceptions;
import com.microsoft.azure.cosmosdb.rx.internal.GlobalEndpointManager;
import com.microsoft.azure.cosmosdb.rx.internal.ReplicatedResourceClientUtils;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceResponse;
import com.microsoft.azure.cosmosdb.rx.internal.RxStoreModel;
import com.microsoft.azure.cosmosdb.rx.internal.Strings;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.WebExceptionRetryPolicy;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.netty.client.RxClient;
import io.reactivex.netty.protocol.http.client.CompositeHttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.reactivex.netty.protocol.http.client.HttpResponseHeaders;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.functions.Func0;

class RxGatewayStoreModel
implements RxStoreModel {
    private static final int INITIAL_RESPONSE_BUFFER_SIZE = 1024;
    private final Logger logger = LoggerFactory.getLogger(RxGatewayStoreModel.class);
    private final Map<String, String> defaultHeaders = new HashMap<String, String>();
    private final CompositeHttpClient<ByteBuf, ByteBuf> httpClient;
    private final QueryCompatibilityMode queryCompatibilityMode;
    private final GlobalEndpointManager globalEndpointManager;
    private ConsistencyLevel defaultConsistencyLevel;
    private ISessionContainer sessionContainer;

    public RxGatewayStoreModel(ISessionContainer sessionContainer, ConsistencyLevel defaultConsistencyLevel, QueryCompatibilityMode queryCompatibilityMode, UserAgentContainer userAgentContainer, GlobalEndpointManager globalEndpointManager, CompositeHttpClient<ByteBuf, ByteBuf> httpClient) {
        this.defaultHeaders.put("Cache-Control", "no-cache");
        this.defaultHeaders.put("x-ms-version", "2018-09-17");
        if (userAgentContainer == null) {
            userAgentContainer = new UserAgentContainer();
        }
        this.defaultHeaders.put("User-Agent", userAgentContainer.getUserAgent());
        if (defaultConsistencyLevel != null) {
            this.defaultHeaders.put("x-ms-consistency-level", defaultConsistencyLevel.toString());
        }
        this.defaultConsistencyLevel = defaultConsistencyLevel;
        this.globalEndpointManager = globalEndpointManager;
        this.queryCompatibilityMode = queryCompatibilityMode;
        this.httpClient = httpClient;
        this.sessionContainer = sessionContainer;
    }

    private Observable<RxDocumentServiceResponse> doCreate(RxDocumentServiceRequest request) {
        return this.performRequest(request, HttpMethod.POST);
    }

    private Observable<RxDocumentServiceResponse> upsert(RxDocumentServiceRequest request) {
        return this.performRequest(request, HttpMethod.POST);
    }

    private Observable<RxDocumentServiceResponse> read(RxDocumentServiceRequest request) {
        return this.performRequest(request, HttpMethod.GET);
    }

    private Observable<RxDocumentServiceResponse> replace(RxDocumentServiceRequest request) {
        return this.performRequest(request, HttpMethod.PUT);
    }

    private Observable<RxDocumentServiceResponse> delete(RxDocumentServiceRequest request) {
        return this.performRequest(request, HttpMethod.DELETE);
    }

    private Observable<RxDocumentServiceResponse> execute(RxDocumentServiceRequest request) {
        return this.performRequest(request, HttpMethod.POST);
    }

    private Observable<RxDocumentServiceResponse> readFeed(RxDocumentServiceRequest request) {
        return this.performRequest(request, HttpMethod.GET);
    }

    private Observable<RxDocumentServiceResponse> query(RxDocumentServiceRequest request) {
        request.getHeaders().put("x-ms-documentdb-isquery", "true");
        switch (this.queryCompatibilityMode) {
            case SqlQuery: {
                request.getHeaders().put("Content-Type", "application/sql");
                break;
            }
            default: {
                request.getHeaders().put("Content-Type", "application/query+json");
            }
        }
        return this.performRequest(request, HttpMethod.POST);
    }

    public Observable<RxDocumentServiceResponse> performRequest(RxDocumentServiceRequest request, HttpMethod method) {
        try {
            URI uri = this.getUri(request);
            HttpClientRequest httpRequest = HttpClientRequest.create((HttpMethod)method, (String)uri.toString());
            this.fillHttpRequestBaseWithHeaders(request.getHeaders(), (HttpClientRequest<ByteBuf>)httpRequest);
            if (request.getContentObservable() != null) {
                Observable byteBufObservable = request.getContentObservable().map(bytes -> Unpooled.wrappedBuffer((byte[])bytes));
                httpRequest.withContentSource(byteBufObservable);
            } else if (request.getContent() != null) {
                httpRequest.withContent(request.getContent());
            }
            RxClient.ServerInfo serverInfo = new RxClient.ServerInfo(uri.getHost(), uri.getPort());
            Observable clientResponseObservable = this.httpClient.submit(serverInfo, httpRequest);
            return this.toDocumentServiceResponse((Observable<HttpClientResponse<ByteBuf>>)clientResponseObservable, request);
        }
        catch (Exception e) {
            return Observable.error((Throwable)e);
        }
    }

    private void fillHttpRequestBaseWithHeaders(Map<String, String> headers, HttpClientRequest<ByteBuf> req) {
        for (Map.Entry<String, String> entry : this.defaultHeaders.entrySet()) {
            if (headers.containsKey(entry.getKey())) continue;
            req.withHeader(entry.getKey(), entry.getValue());
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                if (entry.getValue() == null) {
                    req.withHeader(entry.getKey(), "");
                    continue;
                }
                req.withHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    private URI getUri(RxDocumentServiceRequest request) throws URISyntaxException {
        URI rootUri = request.getEndpointOverride();
        if (rootUri == null) {
            rootUri = request.getIsMedia() ? ((URL)this.globalEndpointManager.getWriteEndpoints().get(0)).toURI() : this.globalEndpointManager.resolveServiceEndpoint(request).toURI();
        }
        String path = PathsHelper.generatePath((ResourceType)request.getResourceType(), (RxDocumentServiceRequest)request, (boolean)request.isFeed);
        if (request.getResourceType().equals((Object)ResourceType.DatabaseAccount)) {
            path = "";
        }
        URI uri = new URI("https", null, rootUri.getHost(), rootUri.getPort(), this.ensureSlashPrefixed(path), null, null);
        return uri;
    }

    private String ensureSlashPrefixed(String path) {
        if (path == null) {
            return path;
        }
        if (path.startsWith("/")) {
            return path;
        }
        return "/" + path;
    }

    private Observable<InputStream> toInputStream(Observable<ByteBuf> contentObservable) {
        return contentObservable.reduce((Object)new ByteArrayOutputStream(), (out, bb) -> {
            try {
                bb.readBytes((OutputStream)out, bb.readableBytes());
                return out;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).map(out -> new ByteArrayInputStream(out.toByteArray()));
    }

    private Observable<String> toString(Observable<ByteBuf> contentObservable) {
        return contentObservable.reduce((Object)new ByteArrayOutputStream(1024), (out, bb) -> {
            try {
                bb.readBytes((OutputStream)out, bb.readableBytes());
                return out;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).map(out -> new String(out.toByteArray(), StandardCharsets.UTF_8));
    }

    private Observable<RxDocumentServiceResponse> toDocumentServiceResponse(Observable<HttpClientResponse<ByteBuf>> clientResponseObservable, RxDocumentServiceRequest request) {
        if (request.getIsMedia()) {
            return clientResponseObservable.flatMap(clientResponse -> {
                HttpResponseHeaders httpResponseHeaders = clientResponse.getHeaders();
                HttpResponseStatus httpResponseStatus = clientResponse.getStatus();
                Observable<InputStream> inputStreamObservable = request.getOperationType() == OperationType.Delete ? Observable.just(null) : this.toInputStream((Observable<ByteBuf>)clientResponse.getContent());
                Observable storeResponseObservable = inputStreamObservable.flatMap(contentInputStream -> {
                    try {
                        this.validateOrThrow(request, httpResponseStatus, httpResponseHeaders, null, (InputStream)contentInputStream);
                        StoreResponse rsp = new StoreResponse(httpResponseStatus.code(), HttpUtils.unescape((List)httpResponseHeaders.entries()), contentInputStream);
                        return Observable.just((Object)rsp);
                    }
                    catch (Exception e) {
                        return Observable.error((Throwable)e);
                    }
                });
                return storeResponseObservable;
            }).map(storeResponse -> new RxDocumentServiceResponse(storeResponse));
        }
        return clientResponseObservable.flatMap(clientResponse -> {
            HttpResponseHeaders httpResponseHeaders = clientResponse.getHeaders();
            HttpResponseStatus httpResponseStatus = clientResponse.getStatus();
            Observable<String> contentObservable = request.getOperationType() == OperationType.Delete ? Observable.just(null) : this.toString((Observable<ByteBuf>)clientResponse.getContent());
            Observable storeResponseObservable = contentObservable.flatMap(content -> {
                try {
                    this.validateOrThrow(request, httpResponseStatus, httpResponseHeaders, (String)content, null);
                    StoreResponse rsp = new StoreResponse(httpResponseStatus.code(), HttpUtils.unescape((List)httpResponseHeaders.entries()), content);
                    return Observable.just((Object)rsp);
                }
                catch (Exception e) {
                    return Observable.error((Throwable)e);
                }
            });
            return storeResponseObservable;
        }).map(storeResponse -> new RxDocumentServiceResponse(storeResponse)).onErrorResumeNext(throwable -> {
            if (!(throwable instanceof Exception)) {
                this.logger.error("Unexpected failure {}", (Object)throwable.getMessage(), throwable);
                return Observable.error((Throwable)throwable);
            }
            Exception exception = (Exception)throwable;
            if (!(exception instanceof DocumentClientException)) {
                this.logger.error("Network failure", (Throwable)exception);
                DocumentClientException dce = new DocumentClientException(0, exception);
                BridgeInternal.setRequestHeaders((DocumentClientException)dce, (Map)request.getHeaders());
                return Observable.error((Throwable)dce);
            }
            return Observable.error((Throwable)exception);
        });
    }

    private void validateOrThrow(RxDocumentServiceRequest request, HttpResponseStatus status, HttpResponseHeaders headers, String body, InputStream inputStream) throws DocumentClientException {
        int statusCode = status.code();
        if (statusCode >= 400) {
            if (body == null && inputStream != null) {
                try {
                    body = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    this.logger.error("Failed to get content from the http response", (Throwable)e);
                    DocumentClientException dce = new DocumentClientException(0, (Exception)e);
                    BridgeInternal.setRequestHeaders((DocumentClientException)dce, (Map)request.getHeaders());
                    throw dce;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
            String statusCodeString = status.reasonPhrase() != null ? status.reasonPhrase().replace(" ", "") : "";
            Error error = null;
            error = body != null ? new Error(body) : new Error();
            error = new Error(statusCodeString, String.format("%s, StatusCode: %s", error.getMessage(), statusCodeString), error.getPartitionedQueryExecutionInfo());
            DocumentClientException dce = new DocumentClientException(statusCode, error, HttpUtils.asMap((HttpResponseHeaders)headers));
            BridgeInternal.setRequestHeaders((DocumentClientException)dce, (Map)request.getHeaders());
            throw dce;
        }
    }

    private Observable<RxDocumentServiceResponse> invokeAsyncInternal(RxDocumentServiceRequest request) {
        switch (request.getOperationType()) {
            case Create: {
                return this.doCreate(request);
            }
            case Upsert: {
                return this.upsert(request);
            }
            case Delete: {
                return this.delete(request);
            }
            case ExecuteJavaScript: {
                return this.execute(request);
            }
            case Read: {
                return this.read(request);
            }
            case ReadFeed: {
                return this.readFeed(request);
            }
            case Replace: {
                return this.replace(request);
            }
            case SqlQuery: 
            case Query: {
                return this.query(request);
            }
        }
        throw new IllegalStateException("Unknown operation type " + request.getOperationType());
    }

    private Observable<RxDocumentServiceResponse> invokeAsync(RxDocumentServiceRequest request) {
        Func0 funcDelegate = () -> this.invokeAsyncInternal(request).toSingle();
        return BackoffRetryUtility.executeRetry(funcDelegate, new WebExceptionRetryPolicy()).toObservable();
    }

    @Override
    public Observable<RxDocumentServiceResponse> processMessage(RxDocumentServiceRequest request) {
        this.applySessionToken(request);
        Observable<RxDocumentServiceResponse> responseObs = this.invokeAsync(request);
        return responseObs.onErrorResumeNext(e -> {
            DocumentClientException dce = (DocumentClientException)((Object)((Object)Utils.as((Object)e, DocumentClientException.class)));
            if (dce == null) {
                this.logger.error("unexpected failure {}", (Object)e.getMessage(), e);
                return Observable.error((Throwable)e);
            }
            if (!ReplicatedResourceClientUtils.isMasterResource(request.getResourceType()) && (dce.getStatusCode() == 412 || dce.getStatusCode() == 409 || dce.getStatusCode() == 404 && !Exceptions.isSubStatusCode((DocumentClientException)dce, (int)1002))) {
                this.captureSessionToken(request, dce.getResponseHeaders());
            }
            return Observable.error((Throwable)dce);
        }).map(response -> {
            this.captureSessionToken(request, response.getResponseHeaders());
            return response;
        });
    }

    private void captureSessionToken(RxDocumentServiceRequest request, Map<String, String> responseHeaders) {
        if (request.getResourceType() == ResourceType.DocumentCollection && request.getOperationType() == OperationType.Delete) {
            String resourceId = request.getIsNameBased() ? responseHeaders.get("x-ms-content-path") : request.getResourceId();
            this.sessionContainer.clearTokenByResourceId(resourceId);
        } else {
            this.sessionContainer.setSessionToken(request, responseHeaders);
        }
    }

    private void applySessionToken(RxDocumentServiceRequest request) {
        boolean sessionConsistency;
        Map headers = request.getHeaders();
        if (headers != null && !Strings.isNullOrEmpty((String)((String)request.getHeaders().get("x-ms-session-token")))) {
            if (ReplicatedResourceClientUtils.isMasterResource(request.getResourceType())) {
                request.getHeaders().remove("x-ms-session-token");
            }
            return;
        }
        String requestConsistencyLevel = (String)headers.get("x-ms-consistency-level");
        boolean bl = sessionConsistency = this.defaultConsistencyLevel == ConsistencyLevel.Session || !Strings.isNullOrEmpty((String)requestConsistencyLevel) && Strings.areEqual((String)requestConsistencyLevel, (String)ConsistencyLevel.Session.name());
        if (!sessionConsistency || ReplicatedResourceClientUtils.isMasterResource(request.getResourceType())) {
            return;
        }
        String sessionToken = this.sessionContainer.resolveGlobalSessionToken(request);
        if (!Strings.isNullOrEmpty((String)sessionToken)) {
            headers.put("x-ms-session-token", sessionToken);
        }
    }
}

