/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.util.EnumSet;
import java.util.Iterator;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.thirdparty.com.google.common.collect.Iterators;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;

public enum Statistic {
    BYTES_READ("bytesRead", "Count of bytes read in read operations"),
    BYTES_WRITTEN("bytesWritten", "Count of bytes written in write operations"),
    READ_OPS("readOps", "Number of read operations"),
    LARGE_READ_OPS("largeReadOps", "Number of large read operations"),
    WRITE_OPS("writeOps", "Number of write operations"),
    BYTES_READ_LOCAL_HOST("bytesReadLocalHost", "Count of bytes read from 0 network distance"),
    BYTES_READ_DISTANCE_OF_ONE_OR_TWO("bytesReadDistanceOfOneOrTwo", "Count of bytes read from {1, 2} network distance"),
    BYTES_READ_DISTANCE_OF_THREE_OR_FOUR("bytesReadDistanceOfThreeOrFour", "Count of bytes read from {3, 4} network distance"),
    BYTES_READ_DISTANCE_OF_FIVE_OR_LARGER("bytesReadDistanceOfFiveOrLarger", "Count of bytes read from {5 and beyond} network distance"),
    BYTES_READ_ERASURE_CODED("bytesReadErasureCoded", "Bytes read on erasure-coded files");

    public static final ImmutableSet<Statistic> VALUES;
    private static final ImmutableMap<String, Statistic> SYMBOL_MAP;
    private final String symbol;
    private final String description;

    private Statistic(String symbol, String description) {
        this.symbol = symbol;
        this.description = description;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public static Statistic fromSymbol(String symbol) {
        return (Statistic)((Object)SYMBOL_MAP.get((Object)symbol));
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.symbol;
    }

    static {
        VALUES = ImmutableSet.copyOf(EnumSet.allOf(Statistic.class));
        SYMBOL_MAP = Maps.uniqueIndex((Iterator)Iterators.forArray((Object[])Statistic.values()), Statistic::getSymbol);
    }
}

