/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RunCommand {
    public static final Logger LOG = LoggerFactory.getLogger(RunCommand.class);
    String[] command;
    String singleCommand;
    String args;
    boolean isBG;
    Process prCreated;
    boolean reqOutput;
    String outputStr = null;

    RunCommand() {
    }

    public void init(String command, String args, boolean isBG, boolean reqOutput) {
        this.singleCommand = command;
        this.args = args;
        this.isBG = isBG;
        this.reqOutput = reqOutput;
    }

    public void init(String[] command, String args, boolean isBG, boolean reqOutput) {
        this.command = command;
        this.args = args;
        this.isBG = isBG;
        this.reqOutput = reqOutput;
    }

    public Process BGProcess() {
        return this.prCreated;
    }

    public String OutPutStr() {
        return this.outputStr;
    }

    public int Run() {
        int retval = 0;
        this.prCreated = null;
        try {
            Process pr;
            Runtime rt = Runtime.getRuntime();
            if (this.singleCommand == null) {
                StringBuilder cmdline = new StringBuilder("Command ran: ");
                for (int i = 0; i < this.command.length; ++i) {
                    cmdline.append(this.command[i] + " ");
                }
                LOG.info(String.valueOf(cmdline));
                pr = rt.exec(this.command);
            } else {
                LOG.info("Command ran: " + this.singleCommand);
                pr = rt.exec(this.singleCommand);
            }
            if (!this.isBG) {
                String stderr;
                retval = pr.waitFor();
                String stdout = this.readStreamFully(pr.getInputStream());
                if (stdout.length() > 0) {
                    LOG.info("Stdout:" + stdout);
                }
                if ((stderr = this.readStreamFully(pr.getErrorStream())).length() > 0) {
                    LOG.info("Stderr:" + stderr.toString());
                }
            } else {
                this.prCreated = pr;
                LOG.info("created BG process: " + this.prCreated);
            }
            LOG.info("Exited with error code " + retval);
        }
        catch (Exception e) {
            LOG.info(e.toString());
            e.printStackTrace();
            retval = -1;
        }
        return retval;
    }

    private String readStreamFully(InputStream is) throws IOException {
        BufferedReader input = new BufferedReader(new InputStreamReader(is));
        StringBuilder text = new StringBuilder();
        String line = null;
        while ((line = input.readLine()) != null) {
            text.append("\n\t").append(line);
            if (!this.reqOutput || this.outputStr == null) continue;
            this.outputStr = line;
        }
        input.close();
        return text.toString();
    }
}

