/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.appmaster;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.sls.SLSRunner;
import org.apache.hadoop.yarn.sls.appmaster.AMSimulator;
import org.apache.hadoop.yarn.sls.scheduler.ContainerSimulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class StreamAMSimulator
extends AMSimulator {
    private static final int PRIORITY_MAP = 20;
    private LinkedList<ContainerSimulator> pendingStreams = new LinkedList();
    private LinkedList<ContainerSimulator> scheduledStreams = new LinkedList();
    private Map<ContainerId, ContainerSimulator> assignedStreams = new HashMap<ContainerId, ContainerSimulator>();
    private LinkedList<ContainerSimulator> allStreams = new LinkedList();
    private boolean isFinished = false;
    private long duration = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(StreamAMSimulator.class);

    @Override
    public void init(int heartbeatInterval, List<ContainerSimulator> containerList, ResourceManager rm, SLSRunner se, long traceStartTime, long traceFinishTime, String user, String queue, boolean isTracked, String oldAppId, long baselineStartTimeMS, Resource amContainerResource, String nodeLabelExpr, Map<String, String> params, Map<ApplicationId, AMSimulator> appIdAMSim) {
        super.init(heartbeatInterval, containerList, rm, se, traceStartTime, traceFinishTime, user, queue, isTracked, oldAppId, baselineStartTimeMS, amContainerResource, nodeLabelExpr, params, appIdAMSim);
        this.amtype = "stream";
        this.allStreams.addAll(containerList);
        this.duration = traceFinishTime - traceStartTime;
        LOG.info("Added new job with {} streams, running for {}", (Object)this.allStreams.size(), (Object)this.duration);
    }

    @Override
    public synchronized void notifyAMContainerLaunched(Container masterContainer) throws Exception {
        if (null != masterContainer) {
            this.restart();
            super.notifyAMContainerLaunched(masterContainer);
        }
    }

    @Override
    protected void processResponseQueue() throws Exception {
        while (!this.responseQueue.isEmpty()) {
            AllocateResponse response = (AllocateResponse)this.responseQueue.take();
            if (!response.getCompletedContainersStatuses().isEmpty()) {
                for (ContainerStatus cs : response.getCompletedContainersStatuses()) {
                    ContainerId containerId = cs.getContainerId();
                    if (this.assignedStreams.containsKey(containerId)) {
                        LOG.debug("Application {} has one streamer finished ({}).", (Object)this.appId, (Object)containerId);
                        this.pendingStreams.add(this.assignedStreams.remove(containerId));
                        continue;
                    }
                    if (!this.amContainer.getId().equals((Object)containerId)) continue;
                    if (cs.getExitStatus() == 0) {
                        this.isAMContainerRunning = false;
                        this.isFinished = true;
                        LOG.info("Application {} goes to finish.", (Object)this.appId);
                        continue;
                    }
                    LOG.info("Application {}'s AM is going to be killed. Waiting for rescheduling...", (Object)this.appId);
                    this.isAMContainerRunning = false;
                }
            }
            if (this.isAMContainerRunning && System.currentTimeMillis() - this.simulateStartTimeMS >= this.duration) {
                LOG.debug("Application {} sends out event to clean up its AM container.", (Object)this.appId);
                this.isAMContainerRunning = false;
                this.isFinished = true;
                break;
            }
            for (Container container : response.getAllocatedContainers()) {
                if (this.scheduledStreams.isEmpty()) continue;
                ContainerSimulator cs = this.scheduledStreams.remove();
                LOG.debug("Application {} starts to launch a stream ({}).", (Object)this.appId, (Object)container.getId());
                this.assignedStreams.put(container.getId(), cs);
                this.se.getNmMap().get(container.getNodeId()).addNewContainer(container, cs.getLifeTime());
            }
        }
    }

    private void restart() throws YarnException, IOException, InterruptedException {
        this.isFinished = false;
        this.pendingStreams.clear();
        this.pendingStreams.addAll(this.allStreams);
        this.amContainer = null;
    }

    private List<ContainerSimulator> mergeLists(List<ContainerSimulator> left, List<ContainerSimulator> right) {
        ArrayList<ContainerSimulator> list = new ArrayList<ContainerSimulator>();
        list.addAll(left);
        list.addAll(right);
        return list;
    }

    @Override
    protected void sendContainerRequest() throws YarnException, IOException, InterruptedException {
        List<ResourceRequest> ask = new ArrayList<ResourceRequest>();
        ArrayList<ContainerId> release = new ArrayList<ContainerId>();
        if (!this.isFinished && !this.pendingStreams.isEmpty()) {
            ask = this.packageRequests(this.mergeLists(this.pendingStreams, this.scheduledStreams), 20);
            LOG.debug("Application {} sends out request for {} streams.", (Object)this.appId, (Object)this.pendingStreams.size());
            this.scheduledStreams.addAll(this.pendingStreams);
            this.pendingStreams.clear();
        }
        if (this.isFinished) {
            release.addAll(this.assignedStreams.keySet());
            ask.clear();
        }
        final AllocateRequest request = this.createAllocateRequest(ask, release);
        if (this.totalContainers == 0) {
            request.setProgress(1.0f);
        } else {
            request.setProgress((float)this.finishedContainers / (float)this.totalContainers);
        }
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)this.appAttemptId.toString());
        Token token = ((RMApp)this.rm.getRMContext().getRMApps().get(this.appAttemptId.getApplicationId())).getRMAppAttempt(this.appAttemptId).getAMRMToken();
        ugi.addTokenIdentifier(token.decodeIdentifier());
        AllocateResponse response = (AllocateResponse)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<AllocateResponse>(){

            @Override
            public AllocateResponse run() throws Exception {
                return StreamAMSimulator.this.rm.getApplicationMasterService().allocate(request);
            }
        });
        if (response != null) {
            this.responseQueue.put(response);
        }
    }

    @Override
    public void initReservation(ReservationId reservationId, long deadline, long now) {
        this.setReservationRequest(null);
    }

    @Override
    protected void checkStop() {
        if (this.isFinished) {
            super.setEndTime(System.currentTimeMillis());
        }
    }

    @Override
    public void lastStep() throws Exception {
        super.lastStep();
        this.allStreams.clear();
        this.assignedStreams.clear();
        this.pendingStreams.clear();
        this.scheduledStreams.clear();
        this.responseQueue.clear();
    }
}

