/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.health;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.server.nodemanager.health.HealthReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimedHealthReporterService
extends AbstractService
implements HealthReporter {
    private static final Logger LOG = LoggerFactory.getLogger(TimedHealthReporterService.class);
    private boolean isHealthy = true;
    private String healthReport = "";
    private long lastReportedTime = System.currentTimeMillis();
    private Timer timer;
    private TimerTask task;
    private long intervalMs;
    private boolean runBeforeStartup;

    TimedHealthReporterService(String name, long intervalMs) {
        super(name);
        this.intervalMs = intervalMs;
        this.runBeforeStartup = false;
    }

    TimedHealthReporterService(String name, long intervalMs, boolean runBeforeStartup) {
        super(name);
        this.intervalMs = intervalMs;
        this.runBeforeStartup = runBeforeStartup;
    }

    @VisibleForTesting
    void setTimerTask(TimerTask timerTask) {
        this.task = timerTask;
    }

    @VisibleForTesting
    TimerTask getTimerTask() {
        return this.task;
    }

    public void serviceStart() throws Exception {
        if (this.task == null) {
            throw new Exception("Health reporting task hasn't been set!");
        }
        this.timer = new Timer("HealthReporterService-Timer", true);
        long delay = 0L;
        if (this.runBeforeStartup) {
            delay = this.intervalMs;
            this.task.run();
        }
        this.timer.scheduleAtFixedRate(this.task, delay, this.intervalMs);
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.timer != null) {
            this.timer.cancel();
        }
        super.serviceStop();
    }

    @Override
    public boolean isHealthy() {
        return this.isHealthy;
    }

    protected synchronized void setHealthy(boolean healthy) {
        this.isHealthy = healthy;
    }

    @Override
    public String getHealthReport() {
        return this.healthReport;
    }

    private synchronized void setHealthReport(String report) {
        this.healthReport = report;
    }

    @Override
    public long getLastHealthReportTime() {
        return this.lastReportedTime;
    }

    private synchronized void setLastReportedTime(long lastReportedTime) {
        this.lastReportedTime = lastReportedTime;
    }

    synchronized void setHealthyWithoutReport() {
        this.setHealthy(true);
        this.setHealthReport("");
        this.setLastReportedTime(System.currentTimeMillis());
    }

    synchronized void setUnhealthyWithReport(String output) {
        LOG.info("Health status being set as: \"" + output + "\".");
        this.setHealthy(false);
        this.setHealthReport(output);
        this.setLastReportedTime(System.currentTimeMillis());
    }
}

