/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.nustaq.offheap.bytez.bytesource;

import java.io.UnsupportedEncodingException;
import org.apache.hadoop.shaded.org.nustaq.offheap.bytez.ByteSource;
import org.apache.hadoop.shaded.org.nustaq.serialization.util.FSTUtil;

public class UTFStringByteSource
implements ByteSource {
    byte[] bytes;

    public UTFStringByteSource(String key) {
        try {
            this.bytes = key.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            FSTUtil.rethrow(e);
        }
    }

    @Override
    public byte get(long index) {
        return this.bytes[(int)index];
    }

    @Override
    public long length() {
        return this.bytes.length;
    }

    public UTFStringByteSource padLeft(int keyLen) {
        if (this.bytes.length < keyLen) {
            byte[] newBytes = new byte[keyLen];
            System.arraycopy(this.bytes, 0, newBytes, keyLen - this.bytes.length, this.bytes.length);
            this.bytes = newBytes;
        }
        return this;
    }
}

