/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.tls.AbstractTlsKeyExchange;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.TlsCredentialedAgreement;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsSecret;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TlsDHKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsCredentialedAgreement agreementCredentials;
    protected TlsCertificate dhPeerCertificate;

    private static int checkKeyExchange(int keyExchange) {
        switch (keyExchange) {
            case 7: 
            case 9: {
                return keyExchange;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsDHKeyExchange(int keyExchange) {
        super(TlsDHKeyExchange.checkKeyExchange(keyExchange));
    }

    public void skipServerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        this.agreementCredentials = TlsUtils.requireAgreementCredentials(serverCredentials);
    }

    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        this.dhPeerCertificate = serverCertificate.getCertificateAt(0).checkUsageInRole(1);
    }

    public short[] getClientCertificateTypes() {
        return new short[]{4, 3};
    }

    public void skipClientCredentials() throws IOException {
        throw new TlsFatalAlert(10);
    }

    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        this.agreementCredentials = TlsUtils.requireAgreementCredentials(clientCredentials);
    }

    public void generateClientKeyExchange(OutputStream output) throws IOException {
    }

    public void processClientCertificate(Certificate clientCertificate) throws IOException {
        this.dhPeerCertificate = clientCertificate.getCertificateAt(0).checkUsageInRole(1);
    }

    public void processClientKeyExchange(InputStream input) throws IOException {
    }

    public boolean requiresCertificateVerify() {
        return false;
    }

    public TlsSecret generatePreMasterSecret() throws IOException {
        return this.agreementCredentials.generateAgreement(this.dhPeerCertificate);
    }
}

