/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.framework.AuthInfo;
import org.apache.curator.framework.CuratorFramework;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.authorize.UsersACLsManager;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.JvmPauseMonitor;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.util.curator.ZKCuratorManager;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.ConfigurationProvider;
import org.apache.hadoop.yarn.conf.ConfigurationProviderFactory;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventDispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.metrics.EventTypeMetrics;
import org.apache.hadoop.yarn.metrics.GenericEventTypeMetrics;
import org.apache.hadoop.yarn.nodelabels.NodeAttributesManager;
import org.apache.hadoop.yarn.server.api.ConfigurableAuxServices;
import org.apache.hadoop.yarn.server.resourcemanager.ActiveStandbyElectorBasedElectorService;
import org.apache.hadoop.yarn.server.resourcemanager.AdminService;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.CuratorBasedElectorService;
import org.apache.hadoop.yarn.server.resourcemanager.EmbeddedElector;
import org.apache.hadoop.yarn.server.resourcemanager.GenericEventTypeMetricsManager;
import org.apache.hadoop.yarn.server.resourcemanager.IsResourceManagerActiveServlet;
import org.apache.hadoop.yarn.server.resourcemanager.NMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.OpportunisticContainerAllocatorAMService;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMInfo;
import org.apache.hadoop.yarn.server.resourcemanager.RMNMInfo;
import org.apache.hadoop.yarn.server.resourcemanager.RMSecretManagerService;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManagerMXBean;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManagerStatusServlet;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEventType;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.ApplicationMasterLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.federation.FederationStateStoreService;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.CombinedSystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.NoOpSystemMetricPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.TimelineServiceV1Publisher;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.TimelineServiceV2Publisher;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NodeAttributesManagerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMDelegatedNodeLabelsUpdater;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.NullRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreFactory;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Recoverable;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.AbstractReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceProfilesManager;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceProfilesManagerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.monitor.RMAppLifetimeMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.MutableConfScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStoreFactory;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.AllocationTagsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.MemoryPlacementConstraintManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.PlacementConstraintManagerService;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.MultiNodeSortingManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.DelegationTokenRenewer;
import org.apache.hadoop.yarn.server.resourcemanager.security.ProxyCAManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.QueueACLsManager;
import org.apache.hadoop.yarn.server.resourcemanager.timelineservice.RMTimelineCollectorManager;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.VolumeManagerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.processor.VolumeAMSProcessor;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebApp;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebAppUtil;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.service.SystemServiceManager;
import org.apache.hadoop.yarn.server.webproxy.AppReportFetcher;
import org.apache.hadoop.yarn.server.webproxy.ProxyCA;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxyServlet;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ResourceManager
extends CompositeService
implements Recoverable,
ResourceManagerMXBean {
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    public static final int EPOCH_BIT_SHIFT = 40;
    private static final Logger LOG = LoggerFactory.getLogger(ResourceManager.class);
    private static final Marker FATAL = MarkerFactory.getMarker((String)"FATAL");
    private static long clusterTimeStamp = System.currentTimeMillis();
    public static final String UI2_WEBAPP_NAME = "/ui2";
    @VisibleForTesting
    protected RMContextImpl rmContext;
    private Dispatcher rmDispatcher;
    @VisibleForTesting
    protected AdminService adminService;
    protected RMActiveServices activeServices;
    protected RMSecretManagerService rmSecretManagerService;
    protected ResourceScheduler scheduler;
    protected ReservationSystem reservationSystem;
    private ClientRMService clientRM;
    protected ApplicationMasterService masterService;
    protected NMLivelinessMonitor nmLivelinessMonitor;
    protected NodesListManager nodesListManager;
    protected RMAppManager rmAppManager;
    protected ApplicationACLsManager applicationACLsManager;
    protected QueueACLsManager queueACLsManager;
    private FederationStateStoreService federationStateStoreService;
    private ProxyCAManager proxyCAManager;
    private WebApp webApp;
    private HttpServer2 statusServer;
    private AppReportFetcher fetcher = null;
    protected ResourceTrackerService resourceTracker;
    private JvmMetrics jvmMetrics;
    private boolean curatorEnabled = false;
    private ZKCuratorManager zkManager;
    private final String zkRootNodePassword = Long.toString(new SecureRandom().nextLong());
    private boolean recoveryEnabled;
    @VisibleForTesting
    protected String webAppAddress;
    private ConfigurationProvider configurationProvider = null;
    private Configuration conf;
    private UserGroupInformation rmLoginUGI;
    private ConfigurableAuxServices auxiliaryServices;
    private UsersACLsManager usersAclsManager;
    private RMInfo rmStatusInfoBean;

    public ResourceManager() {
        super("ResourceManager");
    }

    public RMContext getRMContext() {
        return this.rmContext;
    }

    public static long getClusterTimeStamp() {
        return clusterTimeStamp;
    }

    public String getRMLoginUser() {
        return this.rmLoginUGI.getShortUserName();
    }

    @VisibleForTesting
    protected static void setClusterTimeStamp(long timestamp) {
        clusterTimeStamp = timestamp;
    }

    @VisibleForTesting
    Dispatcher getRmDispatcher() {
        return this.rmDispatcher;
    }

    @VisibleForTesting
    protected ResourceProfilesManager createResourceProfileManager() {
        ResourceProfilesManagerImpl resourceProfilesManager = new ResourceProfilesManagerImpl();
        return resourceProfilesManager;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.conf = conf;
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.rmContext = new RMContextImpl();
        this.rmContext.setResourceManager(this);
        this.rmContext.setYarnConfiguration(conf);
        this.rmStatusInfoBean = new RMInfo(this);
        this.rmStatusInfoBean.register();
        this.rmContext.setHAEnabled(HAUtil.isHAEnabled((Configuration)this.conf));
        if (this.rmContext.isHAEnabled()) {
            HAUtil.verifyAndSetConfiguration((Configuration)this.conf);
        }
        this.rmLoginUGI = UserGroupInformation.getCurrentUser();
        try {
            this.doSecureLogin();
        }
        catch (IOException ie) {
            throw new YarnRuntimeException("Failed to login", (Throwable)ie);
        }
        this.auxiliaryServices = new ConfigurableAuxServices("RMAuxServices", "yarn.resourcemanager.aux-services");
        this.addService((Service)this.auxiliaryServices);
        this.configurationProvider = ConfigurationProviderFactory.getConfigurationProvider((Configuration)conf);
        this.configurationProvider.init(this.conf);
        this.rmContext.setConfigurationProvider(this.configurationProvider);
        this.loadConfigurationXml("core-site.xml");
        RMServerUtils.processRMProxyUsersConf(conf);
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)this.conf);
        this.loadConfigurationXml("yarn-site.xml");
        ResourceManager.validateConfigs(this.conf);
        this.rmDispatcher = this.setupDispatcher();
        this.addIfService(this.rmDispatcher);
        this.rmContext.setDispatcher(this.rmDispatcher);
        this.adminService = this.createAdminService();
        this.addService((Service)this.adminService);
        this.rmContext.setRMAdminService(this.adminService);
        if (this.rmContext.isHAEnabled() && HAUtil.isAutomaticFailoverEnabled((Configuration)conf) && HAUtil.isAutomaticFailoverEmbedded((Configuration)conf)) {
            EmbeddedElector elector = this.createEmbeddedElector();
            this.addIfService(elector);
            this.rmContext.setLeaderElectorService(elector);
        }
        this.createAndInitActiveServices(false);
        this.webAppAddress = WebAppUtils.getWebAppBindURL((Configuration)this.conf, (String)"yarn.resourcemanager.bind-host", (String)WebAppUtils.getRMWebAppURLWithoutScheme((Configuration)this.conf));
        RMApplicationHistoryWriter rmApplicationHistoryWriter = this.createRMApplicationHistoryWriter();
        this.addService((Service)rmApplicationHistoryWriter);
        this.rmContext.setRMApplicationHistoryWriter(rmApplicationHistoryWriter);
        if (YarnConfiguration.timelineServiceV2Enabled((Configuration)this.conf)) {
            RMTimelineCollectorManager timelineCollectorManager = this.createRMTimelineCollectorManager();
            this.addService((Service)timelineCollectorManager);
            this.rmContext.setRMTimelineCollectorManager(timelineCollectorManager);
        }
        SystemMetricsPublisher systemMetricsPublisher = this.createSystemMetricsPublisher();
        this.addIfService(systemMetricsPublisher);
        this.rmContext.setSystemMetricsPublisher(systemMetricsPublisher);
        this.usersAclsManager = new UsersACLsManager(conf);
        Path rootRemoteDir = new Path(conf.get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs"));
        LogAggregationUtils.checkACLConf((boolean)this.usersAclsManager.isUsersACLEnable(), (boolean)conf.getBoolean("hadoop.users.acl.force.init", false), (Configuration)conf, (Path)rootRemoteDir);
        if (conf.getBoolean("hadoop.users.acl.force.init", false)) {
            if (this.usersAclsManager.isUsersACLEnable()) {
                LogAggregationUtils.initACLForAggregatedLogs((Configuration)conf, (UsersACLsManager)this.usersAclsManager, (Path)rootRemoteDir);
            } else {
                LogAggregationUtils.cleanAllACE((Configuration)conf, (Path)rootRemoteDir);
            }
        }
        this.registerMXBean();
        super.serviceInit(this.conf);
    }

    private void loadConfigurationXml(String configurationFile) throws YarnException, IOException {
        InputStream configurationInputStream = this.configurationProvider.getConfigurationInputStream(this.conf, configurationFile);
        if (configurationInputStream != null) {
            this.conf.addResource(configurationInputStream, configurationFile);
        }
    }

    protected EmbeddedElector createEmbeddedElector() throws IOException {
        AbstractService elector;
        this.curatorEnabled = this.conf.getBoolean("yarn.resourcemanager.ha.curator-leader-elector.enabled", false);
        if (this.curatorEnabled) {
            this.zkManager = this.createAndStartZKManager(this.conf);
            elector = new CuratorBasedElectorService(this);
        } else {
            elector = new ActiveStandbyElectorBasedElectorService(this);
        }
        return elector;
    }

    public ZKCuratorManager createAndStartZKManager(Configuration config) throws IOException {
        ZKCuratorManager manager = new ZKCuratorManager(config);
        ArrayList<AuthInfo> authInfos = new ArrayList<AuthInfo>();
        if (HAUtil.isHAEnabled((Configuration)config) && HAUtil.getConfValueForRMInstance((String)"yarn.resourcemanager.zk-state-store.root-node.acl", (Configuration)config) == null) {
            String zkRootNodeUsername = HAUtil.getConfValueForRMInstance((String)"yarn.resourcemanager.address", (String)"0.0.0.0:8032", (Configuration)config);
            String defaultFencingAuth = zkRootNodeUsername + ":" + this.zkRootNodePassword;
            byte[] defaultFencingAuthData = defaultFencingAuth.getBytes(Charset.forName("UTF-8"));
            String scheme = new DigestAuthenticationProvider().getScheme();
            AuthInfo authInfo = new AuthInfo(scheme, defaultFencingAuthData);
            authInfos.add(authInfo);
        }
        manager.start(authInfos);
        return manager;
    }

    public ZKCuratorManager getZKManager() {
        return this.zkManager;
    }

    public CuratorFramework getCurator() {
        if (this.zkManager == null) {
            return null;
        }
        return this.zkManager.getCurator();
    }

    public String getZkRootNodePassword() {
        return this.zkRootNodePassword;
    }

    protected QueueACLsManager createQueueACLsManager(ResourceScheduler scheduler, Configuration conf) {
        return new QueueACLsManager(scheduler, conf);
    }

    @VisibleForTesting
    protected void setRMStateStore(RMStateStore rmStore) {
        rmStore.setRMDispatcher(this.rmDispatcher);
        rmStore.setResourceManager(this);
        this.rmContext.setStateStore(rmStore);
    }

    protected EventHandler<SchedulerEvent> createSchedulerEventDispatcher() {
        SchedulerEventDispatcher dispatcher;
        String dispatcherName = "SchedulerEventDispatcher";
        int threadMonitorRate = this.conf.getInt("yarn.dispatcher.cpu-monitor.samples-per-min", 60);
        if (threadMonitorRate > 0) {
            dispatcher = new SchedulerEventDispatcher(dispatcherName, threadMonitorRate);
            ClusterMetrics.getMetrics().setRmEventProcMonitorEnable(true);
        } else {
            dispatcher = new EventDispatcher((EventHandler)this.scheduler, dispatcherName);
        }
        return dispatcher;
    }

    protected Dispatcher createDispatcher() {
        AsyncDispatcher dispatcher = new AsyncDispatcher("RM Event dispatcher");
        GenericEventTypeMetrics genericEventTypeMetrics = GenericEventTypeMetricsManager.create(dispatcher.getName(), NodesListManagerEventType.class);
        dispatcher.addMetrics((EventTypeMetrics)genericEventTypeMetrics, genericEventTypeMetrics.getEnumClass());
        return dispatcher;
    }

    protected ResourceScheduler createScheduler() {
        String schedulerClassName = this.conf.get("yarn.resourcemanager.scheduler.class", "org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler");
        LOG.info("Using Scheduler: " + schedulerClassName);
        try {
            Class<?> schedulerClazz = Class.forName(schedulerClassName);
            if (ResourceScheduler.class.isAssignableFrom(schedulerClazz)) {
                return (ResourceScheduler)ReflectionUtils.newInstance(schedulerClazz, (Configuration)this.conf);
            }
            throw new YarnRuntimeException("Class: " + schedulerClassName + " not instance of " + ResourceScheduler.class.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException("Could not instantiate Scheduler: " + schedulerClassName, (Throwable)e);
        }
    }

    protected ReservationSystem createReservationSystem() {
        String reservationClassName = this.conf.get("yarn.resourcemanager.reservation-system.class", AbstractReservationSystem.getDefaultReservationSystem(this.scheduler));
        if (reservationClassName == null) {
            return null;
        }
        LOG.info("Using ReservationSystem: " + reservationClassName);
        try {
            Class<?> reservationClazz = Class.forName(reservationClassName);
            if (ReservationSystem.class.isAssignableFrom(reservationClazz)) {
                return (ReservationSystem)ReflectionUtils.newInstance(reservationClazz, (Configuration)this.conf);
            }
            throw new YarnRuntimeException("Class: " + reservationClassName + " not instance of " + ReservationSystem.class.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException("Could not instantiate ReservationSystem: " + reservationClassName, (Throwable)e);
        }
    }

    protected SystemServiceManager createServiceManager() {
        String schedulerClassName = "org.apache.hadoop.yarn.service.client.SystemServiceManagerImpl";
        LOG.info("Using SystemServiceManager: " + schedulerClassName);
        try {
            Class<?> schedulerClazz = Class.forName(schedulerClassName);
            if (SystemServiceManager.class.isAssignableFrom(schedulerClazz)) {
                return (SystemServiceManager)ReflectionUtils.newInstance(schedulerClazz, (Configuration)this.conf);
            }
            throw new YarnRuntimeException("Class: " + schedulerClassName + " not instance of " + SystemServiceManager.class.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException("Could not instantiate SystemServiceManager: " + schedulerClassName, (Throwable)e);
        }
    }

    protected ApplicationMasterLauncher createAMLauncher() {
        return new ApplicationMasterLauncher(this.rmContext);
    }

    private NMLivelinessMonitor createNMLivelinessMonitor() {
        return new NMLivelinessMonitor(this.rmContext.getDispatcher());
    }

    protected AMLivelinessMonitor createAMLivelinessMonitor() {
        return new AMLivelinessMonitor(this.rmDispatcher);
    }

    protected RMNodeLabelsManager createNodeLabelManager() throws InstantiationException, IllegalAccessException {
        return new RMNodeLabelsManager();
    }

    protected NodeAttributesManager createNodeAttributesManager() {
        NodeAttributesManagerImpl namImpl = new NodeAttributesManagerImpl();
        namImpl.setRMContext(this.rmContext);
        return namImpl;
    }

    protected AllocationTagsManager createAllocationTagsManager() {
        return new AllocationTagsManager(this.rmContext);
    }

    protected PlacementConstraintManagerService createPlacementConstraintManager() {
        return new MemoryPlacementConstraintManager();
    }

    protected DelegationTokenRenewer createDelegationTokenRenewer() {
        return new DelegationTokenRenewer();
    }

    protected RMAppManager createRMAppManager() {
        return new RMAppManager(this.rmContext, this.scheduler, this.masterService, this.applicationACLsManager, this.conf);
    }

    protected RMApplicationHistoryWriter createRMApplicationHistoryWriter() {
        return new RMApplicationHistoryWriter();
    }

    private RMTimelineCollectorManager createRMTimelineCollectorManager() {
        return new RMTimelineCollectorManager(this);
    }

    private FederationStateStoreService createFederationStateStoreService() {
        return new FederationStateStoreService(this.rmContext);
    }

    protected MultiNodeSortingManager<SchedulerNode> createMultiNodeSortingManager() {
        return new MultiNodeSortingManager<SchedulerNode>();
    }

    protected SystemMetricsPublisher createSystemMetricsPublisher() {
        ArrayList<SystemMetricsPublisher> publishers = new ArrayList<SystemMetricsPublisher>();
        if (YarnConfiguration.timelineServiceV1Enabled((Configuration)this.conf) && YarnConfiguration.systemMetricsPublisherEnabled((Configuration)this.conf)) {
            TimelineServiceV1Publisher publisherV1 = new TimelineServiceV1Publisher();
            publishers.add(publisherV1);
        }
        if (YarnConfiguration.timelineServiceV2Enabled((Configuration)this.conf) && YarnConfiguration.systemMetricsPublisherEnabled((Configuration)this.conf)) {
            LOG.info("system metrics publisher with the timeline service V2 is configured");
            TimelineServiceV2Publisher publisherV2 = new TimelineServiceV2Publisher(this.rmContext.getRMTimelineCollectorManager());
            publishers.add(publisherV2);
        }
        if (publishers.isEmpty()) {
            LOG.info("TimelineServicePublisher is not configured");
            NoOpSystemMetricPublisher noopPublisher = new NoOpSystemMetricPublisher();
            publishers.add(noopPublisher);
        }
        for (SystemMetricsPublisher publisher : publishers) {
            this.addIfService(publisher);
        }
        CombinedSystemMetricsPublisher combinedPublisher = new CombinedSystemMetricsPublisher(publishers);
        return combinedPublisher;
    }

    protected static void validateConfigs(Configuration conf) {
        long heartbeatIntvl;
        int rmMaxAppAttempts = conf.getInt("yarn.resourcemanager.am.max-attempts", 2);
        if (rmMaxAppAttempts <= 0) {
            throw new YarnRuntimeException("Invalid rm am max attempts configuration, yarn.resourcemanager.am.max-attempts=" + rmMaxAppAttempts + ", it should be a positive integer.");
        }
        int globalMaxAppAttempts = conf.getInt("yarn.resourcemanager.am.global.max-attempts", conf.getInt("yarn.resourcemanager.am.max-attempts", 2));
        if (globalMaxAppAttempts <= 0) {
            throw new YarnRuntimeException("Invalid global max attempts configuration, yarn.resourcemanager.am.global.max-attempts=" + globalMaxAppAttempts + ", it should be a positive integer.");
        }
        long expireIntvl = conf.getLong("yarn.nm.liveness-monitor.expiry-interval-ms", 600000L);
        if (expireIntvl < (heartbeatIntvl = conf.getLong("yarn.resourcemanager.nodemanagers.heartbeat-interval-ms", 1000L))) {
            throw new YarnRuntimeException("Nodemanager expiry interval should be no less than heartbeat interval, yarn.nm.liveness-monitor.expiry-interval-ms=" + expireIntvl + ", " + "yarn.resourcemanager.nodemanagers.heartbeat-interval-ms" + "=" + heartbeatIntvl);
        }
    }

    private void handleTransitionToStandByInNewThread() {
        Thread standByTransitionThread = new Thread(this.activeServices.standByTransitionRunnable);
        standByTransitionThread.setName("StandByTransitionThread");
        standByTransitionThread.start();
    }

    public static HttpServer2.Builder httpServerTemplateForRM(Configuration conf, InetSocketAddress httpAddr, InetSocketAddress httpsAddr, String name) throws IOException {
        HttpServer2.Builder builder = new HttpServer2.Builder().setName(name).setConf(conf).setSecurityEnabled(false);
        if (httpAddr.getPort() == 0) {
            builder.setFindPort(true);
        }
        URI uri = URI.create("http://" + NetUtils.getHostPortString((InetSocketAddress)httpAddr));
        builder.addEndpoint(uri);
        LOG.info("Starting Web-server for " + name + " at: " + uri);
        return builder;
    }

    protected void startWepApp() {
        Object serviceConfig = null;
        Configuration conf = this.getConfig();
        RMWebAppUtil.setupSecurityAndFilters(conf, this.getClientRMService().rmDTSecretManager);
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.getConfig().getBoolean("yarn.webapp.api-service.enable", false)) {
            String apiPackages = "org.apache.hadoop.yarn.service.webapp;org.apache.hadoop.yarn.webapp";
            params.put("com.sun.jersey.config.property.resourceConfigClass", "com.sun.jersey.api.core.PackagesResourceConfig");
            params.put("com.sun.jersey.config.property.packages", apiPackages);
        }
        WebApps.Builder builder = WebApps.$for((String)"cluster", ResourceManager.class, (Object)this, (String)"ws").with(conf).withServlet("API-Service", "/app/*", ServletContainer.class, params, false).withHttpSpnegoPrincipalKey("yarn.resourcemanager.webapp.spnego-principal").withHttpSpnegoKeytabKey("yarn.resourcemanager.webapp.spnego-keytab-file").withCSRFProtection("yarn.resourcemanager.webapp.rest-csrf.").withXFSProtection("yarn.resourcemanager.webapp.xfs-filter.").at(this.webAppAddress);
        String proxyHostAndPort = this.rmContext.getProxyHostAndPort(conf);
        if (WebAppUtils.getResolvedRMWebAppURLWithoutScheme((Configuration)conf).equals(proxyHostAndPort)) {
            this.fetcher = HAUtil.isHAEnabled((Configuration)conf) ? new AppReportFetcher(conf) : new AppReportFetcher(conf, (ApplicationClientProtocol)this.getClientRMService());
            builder.withServlet("proxy", "/proxy/*", WebAppProxyServlet.class);
            builder.withAttribute("ProxyCA", (Object)this.rmContext.getProxyCAManager().getProxyCA());
            builder.withAttribute("AppUrlFetcher", (Object)this.fetcher);
            String[] proxyParts = proxyHostAndPort.split(":");
            builder.withAttribute("proxyHost", (Object)proxyParts[0]);
        }
        WebAppContext uiWebAppContext = null;
        if (this.getConfig().getBoolean("yarn.webapp.ui2.enable", true)) {
            String onDiskPath = this.getConfig().get("yarn.webapp.ui2.war-file-path");
            uiWebAppContext = new WebAppContext();
            uiWebAppContext.setContextPath(UI2_WEBAPP_NAME);
            if (null == onDiskPath) {
                String war = "hadoop-yarn-ui-" + VersionInfo.getVersion() + ".war";
                URL url = this.getClass().getClassLoader().getResource(war);
                onDiskPath = null == url ? this.getWebAppsPath("ui2") : url.getFile();
            }
            if (onDiskPath == null || onDiskPath.isEmpty()) {
                LOG.error("No war file or webapps found for ui2 !");
            } else if (onDiskPath.endsWith(".war")) {
                uiWebAppContext.setWar(onDiskPath);
                LOG.info("Using war file at: " + onDiskPath);
            } else {
                uiWebAppContext.setResourceBase(onDiskPath);
                LOG.info("Using webapps at: " + onDiskPath);
            }
        }
        builder.withAttribute("rm", (Object)this);
        builder.withServlet("isActive", "/isActive", IsResourceManagerActiveServlet.class);
        this.webApp = builder.start((WebApp)new RMWebApp(this), uiWebAppContext);
    }

    private String getWebAppsPath(String appName) {
        URL url = this.getClass().getClassLoader().getResource("webapps/" + appName);
        if (url == null) {
            return "";
        }
        return url.toString();
    }

    protected void createAndInitActiveServices(boolean fromActive) {
        this.activeServices = new RMActiveServices(this);
        this.activeServices.fromActive = fromActive;
        this.activeServices.init(this.conf);
    }

    void startActiveServices() throws Exception {
        if (this.activeServices != null) {
            clusterTimeStamp = System.currentTimeMillis();
            this.activeServices.start();
        }
    }

    void stopActiveServices() {
        if (this.activeServices != null) {
            this.activeServices.stop();
            this.activeServices = null;
        }
    }

    void reinitialize(boolean initialize) {
        ClusterMetrics.destroy();
        QueueMetrics.clearQueueMetrics();
        this.getResourceScheduler().resetSchedulerMetrics();
        if (initialize) {
            this.resetRMContext();
            this.createAndInitActiveServices(true);
        }
    }

    @VisibleForTesting
    protected boolean areActiveServicesRunning() {
        return this.activeServices != null && this.activeServices.isInState(Service.STATE.STARTED);
    }

    synchronized void transitionToActive() throws Exception {
        if (this.rmContext.getHAServiceState() == HAServiceProtocol.HAServiceState.ACTIVE) {
            LOG.info("Already in active state");
            return;
        }
        LOG.info("Transitioning to active state");
        this.rmLoginUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    ResourceManager.this.startActiveServices();
                    return null;
                }
                catch (Exception e) {
                    ResourceManager.this.reinitialize(true);
                    throw e;
                }
            }
        });
        this.rmContext.setHAServiceState(HAServiceProtocol.HAServiceState.ACTIVE);
        LOG.info("Transitioned to active state");
    }

    synchronized void transitionToStandby(boolean initialize) throws Exception {
        if (this.rmContext.getHAServiceState() == HAServiceProtocol.HAServiceState.STANDBY) {
            LOG.info("Already in standby state");
            return;
        }
        LOG.info("Transitioning to standby state");
        HAServiceProtocol.HAServiceState state = this.rmContext.getHAServiceState();
        this.rmContext.setHAServiceState(HAServiceProtocol.HAServiceState.STANDBY);
        if (state == HAServiceProtocol.HAServiceState.ACTIVE) {
            this.stopActiveServices();
            this.reinitialize(initialize);
        }
        LOG.info("Transitioned to standby state");
    }

    protected void serviceStart() throws Exception {
        if (this.rmContext.isHAEnabled()) {
            this.transitionToStandby(false);
        }
        this.startWepApp();
        if (this.getConfig().getBoolean("yarn.is.minicluster", false)) {
            int port = this.webApp.port();
            WebAppUtils.setRMWebAppPort((Configuration)this.conf, (int)port);
        }
        super.serviceStart();
        this.startStatusServer(new Configuration());
        if (!this.rmContext.isHAEnabled()) {
            this.transitionToActive();
        }
    }

    protected void doSecureLogin() throws IOException {
        InetSocketAddress socAddr = ResourceManager.getBindAddress(this.conf);
        SecurityUtil.login((Configuration)this.conf, (String)"yarn.resourcemanager.keytab", (String)"yarn.resourcemanager.principal", (String)socAddr.getHostName());
        if (UserGroupInformation.isSecurityEnabled()) {
            this.rmLoginUGI = UserGroupInformation.getLoginUser();
        }
    }

    protected void startStatusServer(Configuration conf) throws Exception {
        if (this.getConfig().getBoolean("yarn.resourcemanager.status.server.enabled", YarnConfiguration.DEFAULT_RM_STATUS_SERVER_ENABLED)) {
            String httpScheme = "http://";
            String bindAddress = conf.get("yarn.resourcemanager.status.server.address", "localhost:18090");
            HttpServer2.Builder builder = new HttpServer2.Builder();
            this.statusServer = builder.setName("resourcemanager-status").setConf(conf).addEndpoint(URI.create(httpScheme + bindAddress)).build();
            this.statusServer.addServlet("service_status", "/status", ResourceManagerStatusServlet.class);
            this.statusServer.start();
        }
    }

    protected void serviceStop() throws Exception {
        if (this.webApp != null) {
            this.webApp.stop();
        }
        if (this.fetcher != null) {
            this.fetcher.stop();
        }
        if (this.configurationProvider != null) {
            this.configurationProvider.close();
        }
        if (this.statusServer != null) {
            this.statusServer.stop();
        }
        super.serviceStop();
        if (this.zkManager != null) {
            this.zkManager.close();
        }
        this.transitionToStandby(false);
        this.rmContext.setHAServiceState(HAServiceProtocol.HAServiceState.STOPPING);
        this.rmStatusInfoBean.unregister();
    }

    protected ResourceTrackerService createResourceTrackerService() {
        return new ResourceTrackerService(this.rmContext, this.nodesListManager, this.nmLivelinessMonitor, this.rmContext.getContainerTokenSecretManager(), this.rmContext.getNMTokenSecretManager());
    }

    protected ClientRMService createClientRMService() {
        return new ClientRMService(this.rmContext, this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.rmContext.getRMDelegationTokenSecretManager());
    }

    protected ApplicationMasterService createApplicationMasterService() {
        Configuration config = this.rmContext.getYarnConfiguration();
        if (this.isOpportunisticSchedulingEnabled(this.conf)) {
            if (YarnConfiguration.isDistSchedulingEnabled((Configuration)config) && !YarnConfiguration.isOpportunisticContainerAllocationEnabled((Configuration)config)) {
                throw new YarnRuntimeException("Invalid parameters: opportunistic container allocation has to be enabled when distributed scheduling is enabled.");
            }
            OpportunisticContainerAllocatorAMService oppContainerAllocatingAMService = new OpportunisticContainerAllocatorAMService(this.rmContext, this.scheduler);
            this.rmContext.setContainerQueueLimitCalculator(oppContainerAllocatingAMService.getNodeManagerQueueLimitCalculator());
            return oppContainerAllocatingAMService;
        }
        return new ApplicationMasterService(this.rmContext, this.scheduler);
    }

    protected AdminService createAdminService() {
        return new AdminService(this);
    }

    protected RMSecretManagerService createRMSecretManagerService() {
        return new RMSecretManagerService(this.conf, this.rmContext);
    }

    private boolean isOpportunisticSchedulingEnabled(Configuration conf) {
        return YarnConfiguration.isOpportunisticContainerAllocationEnabled((Configuration)conf) || YarnConfiguration.isDistSchedulingEnabled((Configuration)conf);
    }

    protected RMDelegatedNodeLabelsUpdater createRMDelegatedNodeLabelsUpdater() {
        if (this.conf.getBoolean("yarn.node-labels.enabled", false) && YarnConfiguration.isDelegatedCentralizedNodeLabelConfiguration((Configuration)this.conf)) {
            return new RMDelegatedNodeLabelsUpdater(this.rmContext);
        }
        return null;
    }

    @InterfaceAudience.Private
    public ClientRMService getClientRMService() {
        return this.clientRM;
    }

    @InterfaceAudience.Private
    public ResourceScheduler getResourceScheduler() {
        return this.scheduler;
    }

    @InterfaceAudience.Private
    public ResourceTrackerService getResourceTrackerService() {
        return this.resourceTracker;
    }

    @InterfaceAudience.Private
    public ApplicationMasterService getApplicationMasterService() {
        return this.masterService;
    }

    @InterfaceAudience.Private
    public ApplicationACLsManager getApplicationACLsManager() {
        return this.applicationACLsManager;
    }

    @InterfaceAudience.Private
    public QueueACLsManager getQueueACLsManager() {
        return this.queueACLsManager;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public FederationStateStoreService getFederationStateStoreService() {
        return this.federationStateStoreService;
    }

    @InterfaceAudience.Private
    WebApp getWebapp() {
        return this.webApp;
    }

    @Override
    public void recover(RMStateStore.RMState state) throws Exception {
        this.rmContext.getRMDelegationTokenSecretManager().recover(state);
        this.rmContext.getAMRMTokenSecretManager().recover(state);
        if (this.reservationSystem != null) {
            this.reservationSystem.recover(state);
        }
        this.rmAppManager.recover(state);
        this.rmContext.getProxyCAManager().recover(state);
        this.setSchedulerRecoveryStartAndWaitTime(state, this.conf);
    }

    public static void main(String[] argv) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
        StringUtils.startupShutdownMessage(ResourceManager.class, (String[])argv, (Logger)LOG);
        try {
            YarnConfiguration conf = new YarnConfiguration();
            GenericOptionsParser hParser = new GenericOptionsParser((Configuration)conf, argv);
            argv = hParser.getRemainingArgs();
            if (argv.length >= 1) {
                if (argv[0].equals("-format-state-store")) {
                    ResourceManager.deleteRMStateStore((Configuration)conf);
                } else if (argv[0].equals("-format-conf-store")) {
                    ResourceManager.deleteRMConfStore((Configuration)conf);
                } else if (argv[0].equals("-remove-application-from-state-store") && argv.length == 2) {
                    ResourceManager.removeApplication((Configuration)conf, argv[1]);
                } else {
                    ResourceManager.printUsage(System.err);
                }
            } else {
                ResourceManager resourceManager = new ResourceManager();
                ShutdownHookManager.get().addShutdownHook((Runnable)new CompositeService.CompositeServiceShutdownHook((CompositeService)resourceManager), 30);
                resourceManager.init((Configuration)conf);
                resourceManager.start();
            }
        }
        catch (Throwable t) {
            LOG.error(FATAL, "Error starting ResourceManager", t);
            System.exit(-1);
        }
    }

    private Dispatcher setupDispatcher() {
        Dispatcher dispatcher = this.createDispatcher();
        dispatcher.register(RMFatalEventType.class, (EventHandler)new RMFatalEventDispatcher());
        return dispatcher;
    }

    private void resetRMContext() {
        RMContextImpl rmContextImpl = new RMContextImpl();
        rmContextImpl.setServiceContext(this.rmContext.getServiceContext());
        Dispatcher dispatcher = this.setupDispatcher();
        ((Service)dispatcher).init(this.conf);
        ((Service)dispatcher).start();
        this.removeService((Service)this.rmDispatcher);
        ((Service)this.rmDispatcher).stop();
        this.rmDispatcher = dispatcher;
        this.addIfService(this.rmDispatcher);
        rmContextImpl.setDispatcher(dispatcher);
        this.rmContext = rmContextImpl;
    }

    private void setSchedulerRecoveryStartAndWaitTime(RMStateStore.RMState state, Configuration conf) {
        if (!state.getApplicationState().isEmpty()) {
            long waitTime = conf.getLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 10000L);
            this.rmContext.setSchedulerRecoveryStartAndWaitTime(waitTime);
        }
    }

    public static InetSocketAddress getBindAddress(Configuration conf) {
        return conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
    }

    @VisibleForTesting
    static void deleteRMStateStore(Configuration conf) throws Exception {
        RMStateStore rmStore = RMStateStoreFactory.getStore(conf);
        rmStore.setResourceManager(new ResourceManager());
        rmStore.init(conf);
        rmStore.start();
        try {
            LOG.info("Deleting ResourceManager state store...");
            rmStore.deleteStore();
            LOG.info("State store deleted");
        }
        finally {
            rmStore.stop();
        }
    }

    @VisibleForTesting
    static void deleteRMConfStore(Configuration conf) throws Exception {
        String confProviderStr;
        ResourceManager rm = new ResourceManager();
        rm.conf = conf;
        ResourceScheduler scheduler = rm.createScheduler();
        RMContextImpl rmContext = new RMContextImpl();
        rmContext.setResourceManager(rm);
        boolean isConfigurationMutable = false;
        switch (confProviderStr = conf.get("yarn.scheduler.configuration.store.class", "file")) {
            case "memory": 
            case "leveldb": 
            case "zk": 
            case "fs": {
                isConfigurationMutable = true;
                break;
            }
        }
        if (scheduler instanceof MutableConfScheduler && isConfigurationMutable) {
            YarnConfigurationStore confStore = YarnConfigurationStoreFactory.getStore(conf);
            confStore.initialize(conf, conf, rmContext);
            confStore.format();
        } else {
            System.out.println("Scheduler Configuration format only supported by MutableConfScheduler.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void removeApplication(Configuration conf, String applicationId) throws Exception {
        RMStateStore rmStore = RMStateStoreFactory.getStore(conf);
        rmStore.setResourceManager(new ResourceManager());
        rmStore.init(conf);
        rmStore.start();
        try {
            ApplicationId removeAppId = ApplicationId.fromString((String)applicationId);
            LOG.info("Deleting application " + removeAppId + " from state store");
            rmStore.removeApplication(removeAppId);
            LOG.info("Application is deleted from state store");
        }
        finally {
            rmStore.stop();
        }
    }

    private static void printUsage(PrintStream out) {
        out.println("Usage: yarn resourcemanager [-format-state-store]");
        out.println("                            [-remove-application-from-state-store <appId>]");
        out.println("                            [-format-conf-store]\n");
    }

    protected RMAppLifetimeMonitor createRMAppLifetimeMonitor() {
        return new RMAppLifetimeMonitor(this.rmContext);
    }

    private void registerMXBean() {
        MBeans.register((String)"ResourceManager", (String)"ResourceManager", (Object)this);
    }

    @Override
    public boolean isSecurityEnabled() {
        return UserGroupInformation.isSecurityEnabled();
    }

    @InterfaceAudience.Private
    public static final class NodeEventDispatcher
    implements EventHandler<RMNodeEvent> {
        private final RMContext rmContext;

        public NodeEventDispatcher(RMContext rmContext) {
            this.rmContext = rmContext;
        }

        public void handle(RMNodeEvent event) {
            NodeId nodeId = event.getNodeId();
            RMNode node = (RMNode)this.rmContext.getRMNodes().get(nodeId);
            if (node != null) {
                try {
                    ((EventHandler)node).handle((Event)event);
                }
                catch (Throwable t) {
                    LOG.error("Error in handling event type " + event.getType() + " for node " + nodeId, t);
                }
            }
        }
    }

    @InterfaceAudience.Private
    public static final class ApplicationAttemptEventDispatcher
    implements EventHandler<RMAppAttemptEvent> {
        private final RMContext rmContext;

        public ApplicationAttemptEventDispatcher(RMContext rmContext) {
            this.rmContext = rmContext;
        }

        public void handle(RMAppAttemptEvent event) {
            ApplicationAttemptId appAttemptId = event.getApplicationAttemptId();
            ApplicationId appId = appAttemptId.getApplicationId();
            RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(appId);
            if (rmApp != null) {
                RMAppAttempt rmAppAttempt = rmApp.getRMAppAttempt(appAttemptId);
                if (rmAppAttempt != null) {
                    try {
                        rmAppAttempt.handle((Event)event);
                    }
                    catch (Throwable t) {
                        LOG.error("Error in handling event type " + event.getType() + " for applicationAttempt " + appAttemptId, t);
                    }
                } else if (rmApp.getApplicationSubmissionContext() != null && rmApp.getApplicationSubmissionContext().getKeepContainersAcrossApplicationAttempts() && event.getType() == RMAppAttemptEventType.CONTAINER_FINISHED) {
                    RMAppAttempt previousFailedAttempt = rmApp.getAppAttempts().values().iterator().next();
                    if (previousFailedAttempt != null) {
                        try {
                            LOG.debug("Event {} handled by {}", (Object)event.getType(), (Object)previousFailedAttempt);
                            previousFailedAttempt.handle((Event)event);
                        }
                        catch (Throwable t) {
                            LOG.error("Error in handling event type " + event.getType() + " for applicationAttempt " + appAttemptId + " with " + previousFailedAttempt, t);
                        }
                    } else {
                        LOG.error("Event " + event.getType() + " not handled, because previousFailedAttempt is null");
                    }
                }
            }
        }
    }

    @InterfaceAudience.Private
    public static final class ApplicationEventDispatcher
    implements EventHandler<RMAppEvent> {
        private final RMContext rmContext;

        public ApplicationEventDispatcher(RMContext rmContext) {
            this.rmContext = rmContext;
        }

        public void handle(RMAppEvent event) {
            ApplicationId appID = event.getApplicationId();
            RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(appID);
            if (rmApp != null) {
                try {
                    rmApp.handle((Event)event);
                }
                catch (Throwable t) {
                    LOG.error("Error in handling event type " + event.getType() + " for application " + appID, t);
                }
            }
        }
    }

    private class StandByTransitionRunnable
    implements Runnable {
        private final AtomicBoolean hasAlreadyRun = new AtomicBoolean(false);

        private StandByTransitionRunnable() {
        }

        @Override
        public void run() {
            if (this.hasAlreadyRun.getAndSet(true)) {
                return;
            }
            if (ResourceManager.this.rmContext.isHAEnabled()) {
                try {
                    LOG.info("Transitioning RM to Standby mode");
                    ResourceManager.this.transitionToStandby(true);
                    EmbeddedElector elector = ResourceManager.this.rmContext.getLeaderElectorService();
                    if (elector != null) {
                        elector.rejoinElection();
                    }
                }
                catch (Exception e) {
                    LOG.error(FATAL, "Failed to transition RM to Standby mode.", (Throwable)e);
                    ExitUtil.terminate((int)1, (Throwable)e);
                }
            }
        }
    }

    @InterfaceAudience.Private
    private class SchedulerEventDispatcher
    extends EventDispatcher<SchedulerEvent> {
        private final Thread eventProcessorMonitor;

        SchedulerEventDispatcher(String name, int samplesPerMin) {
            super((EventHandler)ResourceManager.this.scheduler, name);
            this.eventProcessorMonitor = new Thread(new EventProcessorMonitor(this.getEventProcessorId(), samplesPerMin));
            this.eventProcessorMonitor.setName("ResourceManager Event Processor Monitor");
        }

        protected void serviceStart() throws Exception {
            super.serviceStart();
            this.eventProcessorMonitor.start();
        }

        protected void serviceStop() throws Exception {
            super.serviceStop();
            this.eventProcessorMonitor.interrupt();
            try {
                this.eventProcessorMonitor.join();
            }
            catch (InterruptedException e) {
                throw new YarnRuntimeException((Throwable)e);
            }
        }

        private final class EventProcessorMonitor
        implements Runnable {
            private final long tid;
            private final boolean run;
            private final ThreadMXBean tmxb;
            private final ClusterMetrics clusterMetrics = ClusterMetrics.getMetrics();
            private final int samples;

            EventProcessorMonitor(long id, int samplesPerMin) {
                assert (samplesPerMin > 0);
                this.tid = id;
                this.samples = samplesPerMin;
                this.tmxb = ManagementFactory.getThreadMXBean();
                if (this.clusterMetrics != null && this.tmxb != null && this.tmxb.isThreadCpuTimeSupported()) {
                    this.run = true;
                    this.clusterMetrics.setRmEventProcMonitorEnable(true);
                } else {
                    this.run = false;
                }
            }

            @Override
            public void run() {
                int index = 0;
                long[] values = new long[this.samples];
                int sleepMs = 60000 / this.samples;
                while (this.run && !SchedulerEventDispatcher.this.isStopped() && !Thread.currentThread().isInterrupted()) {
                    try {
                        long cpuBefore = this.tmxb.getThreadCpuTime(this.tid);
                        long wallClockBefore = Time.monotonicNow();
                        Thread.sleep(sleepMs);
                        long wallClockDelta = Time.monotonicNow() - wallClockBefore;
                        long cpuDelta = this.tmxb.getThreadCpuTime(this.tid) - cpuBefore;
                        values[index] = cpuDelta / wallClockDelta;
                        index = (index + 1) % this.samples;
                        long max = 0L;
                        long sum = 0L;
                        for (int i = 0; i < this.samples; ++i) {
                            sum += values[i];
                            max = Math.max(max, values[i]);
                        }
                        this.clusterMetrics.setRmEventProcCPUAvg(sum / (long)this.samples);
                        this.clusterMetrics.setRmEventProcCPUMax(max);
                    }
                    catch (InterruptedException e) {
                        LOG.error("Returning, interrupted : " + e);
                        return;
                    }
                }
            }
        }
    }

    @InterfaceAudience.Private
    private class RMFatalEventDispatcher
    implements EventHandler<RMFatalEvent> {
        private RMFatalEventDispatcher() {
        }

        public void handle(RMFatalEvent event) {
            LOG.error("Received " + (Object)((Object)event));
            if (HAUtil.isHAEnabled((Configuration)ResourceManager.this.getConfig())) {
                LOG.warn("Transitioning the resource manager to standby.");
                ResourceManager.this.handleTransitionToStandByInNewThread();
            } else {
                switch ((RMFatalEventType)event.getType()) {
                    case STATE_STORE_FENCED: {
                        LOG.error(FATAL, "State store fenced even though the resource manager is not configured for high availability. Shutting down this resource manager to protect the integrity of the state store.");
                        ExitUtil.terminate((int)1, (String)event.getExplanation());
                        break;
                    }
                    case STATE_STORE_OP_FAILED: {
                        if (YarnConfiguration.shouldRMFailFast((Configuration)ResourceManager.this.getConfig())) {
                            LOG.error(FATAL, "Shutting down the resource manager because a state store operation failed, and the resource manager is configured to fail fast. See the yarn.fail-fast and yarn.resourcemanager.fail-fast properties.");
                            ExitUtil.terminate((int)1, (String)event.getExplanation());
                            break;
                        }
                        LOG.warn("Ignoring state store operation failure because the resource manager is not configured to fail fast. See the yarn.fail-fast and yarn.resourcemanager.fail-fast properties.");
                        break;
                    }
                    default: {
                        LOG.error(FATAL, "Shutting down the resource manager.");
                        ExitUtil.terminate((int)1, (String)event.getExplanation());
                    }
                }
            }
        }
    }

    @InterfaceAudience.Private
    public class RMActiveServices
    extends CompositeService {
        private DelegationTokenRenewer delegationTokenRenewer;
        private EventHandler<SchedulerEvent> schedulerDispatcher;
        private ApplicationMasterLauncher applicationMasterLauncher;
        private ContainerAllocationExpirer containerAllocationExpirer;
        private ResourceManager rm;
        private boolean fromActive;
        private StandByTransitionRunnable standByTransitionRunnable;
        private RMNMInfo rmnmInfo;

        RMActiveServices(ResourceManager rm) {
            super("RMActiveServices");
            this.fromActive = false;
            this.rm = rm;
        }

        protected void serviceInit(Configuration configuration) throws Exception {
            String[] amsProcessorList;
            this.standByTransitionRunnable = new StandByTransitionRunnable();
            ResourceManager.this.rmSecretManagerService = ResourceManager.this.createRMSecretManagerService();
            this.addService((Service)ResourceManager.this.rmSecretManagerService);
            this.containerAllocationExpirer = new ContainerAllocationExpirer(ResourceManager.this.rmDispatcher);
            this.addService((Service)this.containerAllocationExpirer);
            ResourceManager.this.rmContext.setContainerAllocationExpirer(this.containerAllocationExpirer);
            AMLivelinessMonitor amLivelinessMonitor = ResourceManager.this.createAMLivelinessMonitor();
            this.addService((Service)amLivelinessMonitor);
            ResourceManager.this.rmContext.setAMLivelinessMonitor(amLivelinessMonitor);
            AMLivelinessMonitor amFinishingMonitor = ResourceManager.this.createAMLivelinessMonitor();
            this.addService((Service)amFinishingMonitor);
            ResourceManager.this.rmContext.setAMFinishingMonitor(amFinishingMonitor);
            RMAppLifetimeMonitor rmAppLifetimeMonitor = ResourceManager.this.createRMAppLifetimeMonitor();
            this.addService((Service)rmAppLifetimeMonitor);
            ResourceManager.this.rmContext.setRMAppLifetimeMonitor(rmAppLifetimeMonitor);
            RMNodeLabelsManager nlm = ResourceManager.this.createNodeLabelManager();
            nlm.setRMContext(ResourceManager.this.rmContext);
            this.addService((Service)nlm);
            ResourceManager.this.rmContext.setNodeLabelManager(nlm);
            NodeAttributesManager nam = ResourceManager.this.createNodeAttributesManager();
            this.addService((Service)nam);
            ResourceManager.this.rmContext.setNodeAttributesManager(nam);
            AllocationTagsManager allocationTagsManager = ResourceManager.this.createAllocationTagsManager();
            ResourceManager.this.rmContext.setAllocationTagsManager(allocationTagsManager);
            PlacementConstraintManagerService placementConstraintManager = ResourceManager.this.createPlacementConstraintManager();
            this.addService((Service)placementConstraintManager);
            ResourceManager.this.rmContext.setPlacementConstraintManager(placementConstraintManager);
            ResourceProfilesManager resourceProfilesManager = ResourceManager.this.createResourceProfileManager();
            resourceProfilesManager.init(ResourceManager.this.conf);
            ResourceManager.this.rmContext.setResourceProfilesManager(resourceProfilesManager);
            MultiNodeSortingManager<SchedulerNode> multiNodeSortingManager = ResourceManager.this.createMultiNodeSortingManager();
            multiNodeSortingManager.setRMContext(ResourceManager.this.rmContext);
            this.addService((Service)multiNodeSortingManager);
            ResourceManager.this.rmContext.setMultiNodeSortingManager(multiNodeSortingManager);
            RMDelegatedNodeLabelsUpdater delegatedNodeLabelsUpdater = ResourceManager.this.createRMDelegatedNodeLabelsUpdater();
            if (delegatedNodeLabelsUpdater != null) {
                this.addService((Service)delegatedNodeLabelsUpdater);
                ResourceManager.this.rmContext.setRMDelegatedNodeLabelsUpdater(delegatedNodeLabelsUpdater);
            }
            ResourceManager.this.recoveryEnabled = ResourceManager.this.conf.getBoolean("yarn.resourcemanager.recovery.enabled", false);
            RMStateStore rmStore = null;
            if (ResourceManager.this.recoveryEnabled) {
                rmStore = RMStateStoreFactory.getStore(ResourceManager.this.conf);
                boolean isWorkPreservingRecoveryEnabled = ResourceManager.this.conf.getBoolean("yarn.resourcemanager.work-preserving-recovery.enabled", true);
                ResourceManager.this.rmContext.setWorkPreservingRecoveryEnabled(isWorkPreservingRecoveryEnabled);
            } else {
                rmStore = new NullRMStateStore();
            }
            try {
                rmStore.setResourceManager(this.rm);
                rmStore.init(ResourceManager.this.conf);
                rmStore.setRMDispatcher(ResourceManager.this.rmDispatcher);
            }
            catch (Exception e) {
                LOG.error("Failed to init state store", (Throwable)e);
                throw e;
            }
            ResourceManager.this.rmContext.setStateStore(rmStore);
            if (UserGroupInformation.isSecurityEnabled()) {
                this.delegationTokenRenewer = ResourceManager.this.createDelegationTokenRenewer();
                ResourceManager.this.rmContext.setDelegationTokenRenewer(this.delegationTokenRenewer);
            }
            ResourceManager.this.nodesListManager = new NodesListManager(ResourceManager.this.rmContext);
            ResourceManager.this.rmDispatcher.register(NodesListManagerEventType.class, (EventHandler)ResourceManager.this.nodesListManager);
            this.addService((Service)ResourceManager.this.nodesListManager);
            ResourceManager.this.rmContext.setNodesListManager(ResourceManager.this.nodesListManager);
            ResourceManager.this.scheduler = ResourceManager.this.createScheduler();
            ResourceManager.this.scheduler.setRMContext(ResourceManager.this.rmContext);
            this.addIfService(ResourceManager.this.scheduler);
            ResourceManager.this.rmContext.setScheduler(ResourceManager.this.scheduler);
            this.schedulerDispatcher = ResourceManager.this.createSchedulerEventDispatcher();
            this.addIfService(this.schedulerDispatcher);
            ResourceManager.this.rmDispatcher.register(SchedulerEventType.class, this.schedulerDispatcher);
            ResourceManager.this.rmDispatcher.register(RMAppEventType.class, (EventHandler)new ApplicationEventDispatcher(ResourceManager.this.rmContext));
            ResourceManager.this.rmDispatcher.register(RMAppAttemptEventType.class, (EventHandler)new ApplicationAttemptEventDispatcher(ResourceManager.this.rmContext));
            ResourceManager.this.rmDispatcher.register(RMNodeEventType.class, (EventHandler)new NodeEventDispatcher(ResourceManager.this.rmContext));
            ResourceManager.this.nmLivelinessMonitor = ResourceManager.this.createNMLivelinessMonitor();
            this.addService((Service)ResourceManager.this.nmLivelinessMonitor);
            ResourceManager.this.resourceTracker = ResourceManager.this.createResourceTrackerService();
            this.addService((Service)ResourceManager.this.resourceTracker);
            ResourceManager.this.rmContext.setResourceTrackerService(ResourceManager.this.resourceTracker);
            MetricsSystem ms = DefaultMetricsSystem.initialize((String)"ResourceManager");
            if (this.fromActive) {
                JvmMetrics.reattach((MetricsSystem)ms, (JvmMetrics)ResourceManager.this.jvmMetrics);
                UserGroupInformation.reattachMetrics();
            } else {
                ResourceManager.this.jvmMetrics = JvmMetrics.initSingleton((String)"ResourceManager", null);
            }
            JvmPauseMonitor pauseMonitor = new JvmPauseMonitor();
            this.addService((Service)pauseMonitor);
            ResourceManager.this.jvmMetrics.setPauseMonitor(pauseMonitor);
            if (ResourceManager.this.conf.getBoolean("yarn.resourcemanager.reservation-system.enable", false)) {
                ResourceManager.this.reservationSystem = ResourceManager.this.createReservationSystem();
                if (ResourceManager.this.reservationSystem != null) {
                    ResourceManager.this.reservationSystem.setRMContext(ResourceManager.this.rmContext);
                    this.addIfService(ResourceManager.this.reservationSystem);
                    ResourceManager.this.rmContext.setReservationSystem(ResourceManager.this.reservationSystem);
                    LOG.info("Initialized Reservation system");
                }
            }
            ResourceManager.this.masterService = ResourceManager.this.createApplicationMasterService();
            this.createAndRegisterOpportunisticDispatcher(ResourceManager.this.masterService);
            this.addService((Service)ResourceManager.this.masterService);
            ResourceManager.this.rmContext.setApplicationMasterService(ResourceManager.this.masterService);
            ResourceManager.this.applicationACLsManager = new ApplicationACLsManager(ResourceManager.this.conf);
            ResourceManager.this.queueACLsManager = ResourceManager.this.createQueueACLsManager(ResourceManager.this.scheduler, ResourceManager.this.conf);
            ResourceManager.this.rmAppManager = ResourceManager.this.createRMAppManager();
            ResourceManager.this.rmDispatcher.register(RMAppManagerEventType.class, (EventHandler)ResourceManager.this.rmAppManager);
            ResourceManager.this.clientRM = ResourceManager.this.createClientRMService();
            this.addService((Service)ResourceManager.this.clientRM);
            ResourceManager.this.rmContext.setClientRMService(ResourceManager.this.clientRM);
            this.applicationMasterLauncher = ResourceManager.this.createAMLauncher();
            ResourceManager.this.rmDispatcher.register(AMLauncherEventType.class, (EventHandler)this.applicationMasterLauncher);
            this.addService((Service)this.applicationMasterLauncher);
            if (UserGroupInformation.isSecurityEnabled()) {
                this.addService((Service)this.delegationTokenRenewer);
                this.delegationTokenRenewer.setRMContext(ResourceManager.this.rmContext);
            }
            if (HAUtil.isFederationEnabled((Configuration)ResourceManager.this.conf)) {
                String cId = YarnConfiguration.getClusterId((Configuration)ResourceManager.this.conf);
                if (cId.isEmpty()) {
                    String errMsg = "Cannot initialize RM as Federation is enabled but cluster id is not configured.";
                    LOG.error(errMsg);
                    throw new YarnRuntimeException(errMsg);
                }
                ResourceManager.this.federationStateStoreService = ResourceManager.this.createFederationStateStoreService();
                this.addIfService((Object)ResourceManager.this.federationStateStoreService);
                LOG.info("Initialized Federation membership.");
            }
            ResourceManager.this.proxyCAManager = new ProxyCAManager(new ProxyCA(), ResourceManager.this.rmContext);
            this.addService((Service)ResourceManager.this.proxyCAManager);
            ResourceManager.this.rmContext.setProxyCAManager(ResourceManager.this.proxyCAManager);
            this.rmnmInfo = new RMNMInfo(ResourceManager.this.rmContext, ResourceManager.this.scheduler);
            if (ResourceManager.this.conf.getBoolean("yarn.webapp.api-service.enable", false)) {
                SystemServiceManager systemServiceManager = ResourceManager.this.createServiceManager();
                this.addIfService(systemServiceManager);
            }
            if ((amsProcessorList = ResourceManager.this.conf.getStrings("yarn.resourcemanager.application-master-service.processors")) != null && Arrays.stream(amsProcessorList).anyMatch(s -> VolumeAMSProcessor.class.getName().equals(s))) {
                VolumeManagerImpl volumeManager = new VolumeManagerImpl();
                ResourceManager.this.rmContext.setVolumeManager(volumeManager);
                this.addIfService(volumeManager);
            }
            super.serviceInit(ResourceManager.this.conf);
        }

        private void createAndRegisterOpportunisticDispatcher(ApplicationMasterService service) {
            if (!ResourceManager.this.isOpportunisticSchedulingEnabled(ResourceManager.this.conf)) {
                return;
            }
            EventDispatcher oppContainerAllocEventDispatcher = new EventDispatcher((EventHandler)((OpportunisticContainerAllocatorAMService)service), OpportunisticContainerAllocatorAMService.class.getName());
            this.addService((Service)oppContainerAllocEventDispatcher);
            ResourceManager.this.rmDispatcher.register(SchedulerEventType.class, (EventHandler)oppContainerAllocEventDispatcher);
        }

        protected void serviceStart() throws Exception {
            RMStateStore rmStore = ResourceManager.this.rmContext.getStateStore();
            rmStore.start();
            if (ResourceManager.this.recoveryEnabled) {
                try {
                    LOG.info("Recovery started");
                    rmStore.checkVersion();
                    if (ResourceManager.this.rmContext.isWorkPreservingRecoveryEnabled()) {
                        ResourceManager.this.rmContext.setEpoch(rmStore.getAndIncrementEpoch());
                    }
                    RMStateStore.RMState state = rmStore.loadState();
                    ResourceManager.this.recover(state);
                    LOG.info("Recovery ended");
                }
                catch (Exception e) {
                    LOG.error("Failed to load/recover state", (Throwable)e);
                    throw e;
                }
            } else if (HAUtil.isFederationEnabled((Configuration)ResourceManager.this.conf)) {
                long epoch = ResourceManager.this.conf.getLong("yarn.resourcemanager.epoch", 0L);
                ResourceManager.this.rmContext.setEpoch(epoch);
                LOG.info("Epoch set for Federation: " + epoch);
            }
            super.serviceStart();
        }

        protected void serviceStop() throws Exception {
            super.serviceStop();
            DefaultMetricsSystem.shutdown();
            if (this.rmnmInfo != null) {
                this.rmnmInfo.unregister();
            }
            if (ResourceManager.this.rmContext != null) {
                RMStateStore store = ResourceManager.this.rmContext.getStateStore();
                try {
                    if (null != store) {
                        store.close();
                    }
                }
                catch (Exception e) {
                    LOG.error("Error closing store.", (Throwable)e);
                }
            }
        }
    }
}

