/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsCryptoException;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsECDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.ECUtil;
import org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsECDH;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsSecret;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JceTlsECDomain
implements TlsECDomain {
    protected final JcaTlsCrypto crypto;
    protected final TlsECConfig ecConfig;
    protected final ECParameterSpec ecSpec;
    protected final ECCurve ecCurve;

    public JceTlsECDomain(JcaTlsCrypto jcaTlsCrypto, TlsECConfig tlsECConfig) {
        ECParameterSpec eCParameterSpec;
        int n = tlsECConfig.getNamedGroup();
        if (NamedGroup.refersToAnECDSACurve(n) && null != (eCParameterSpec = ECUtil.getECParameterSpec(jcaTlsCrypto, NamedGroup.getCurveName(n)))) {
            this.crypto = jcaTlsCrypto;
            this.ecConfig = tlsECConfig;
            this.ecSpec = eCParameterSpec;
            this.ecCurve = ECUtil.convertCurve(eCParameterSpec.getCurve(), eCParameterSpec.getOrder(), eCParameterSpec.getCofactor());
            return;
        }
        throw new IllegalArgumentException("NamedGroup not supported: " + NamedGroup.getText(n));
    }

    public JceTlsSecret calculateECDHAgreement(PrivateKey privateKey, PublicKey publicKey) throws IOException {
        try {
            byte[] byArray = this.crypto.calculateKeyAgreement("ECDH", privateKey, publicKey, "TlsPremasterSecret");
            return this.crypto.adoptLocalSecret(byArray);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsCryptoException("cannot calculate secret", generalSecurityException);
        }
    }

    @Override
    public TlsAgreement createECDH() {
        return new JceTlsECDH(this);
    }

    public org.bouncycastle.math.ec.ECPoint decodePoint(byte[] byArray) throws IOException {
        return this.ecCurve.decodePoint(byArray);
    }

    public PublicKey decodePublicKey(byte[] byArray) throws IOException {
        try {
            org.bouncycastle.math.ec.ECPoint eCPoint = this.decodePoint(byArray).normalize();
            BigInteger bigInteger = eCPoint.getAffineXCoord().toBigInteger();
            BigInteger bigInteger2 = eCPoint.getAffineYCoord().toBigInteger();
            ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(new ECPoint(bigInteger, bigInteger2), this.ecSpec);
            KeyFactory keyFactory = this.crypto.getHelper().createKeyFactory("EC");
            return keyFactory.generatePublic(eCPublicKeySpec);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(47, (Throwable)exception);
        }
    }

    public byte[] encodePoint(org.bouncycastle.math.ec.ECPoint eCPoint) throws IOException {
        return eCPoint.getEncoded(false);
    }

    public byte[] encodePublicKey(PublicKey publicKey) throws IOException {
        if (publicKey instanceof ECPublicKey) {
            ECPoint eCPoint = ((ECPublicKey)publicKey).getW();
            return this.encodePoint(this.ecCurve.createPoint(eCPoint.getAffineX(), eCPoint.getAffineY()));
        }
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        return subjectPublicKeyInfo.getPublicKeyData().getOctets();
    }

    public KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = this.crypto.getHelper().createKeyPairGenerator("EC");
            keyPairGenerator.initialize(this.ecSpec, this.crypto.getSecureRandom());
            return keyPairGenerator.generateKeyPair();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Exceptions.illegalStateException("unable to create key pair: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }
}

