/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.checkpoint;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapreduce.checkpoint.CheckpointID;
import org.apache.hadoop.mapreduce.checkpoint.EnumCounter;
import org.apache.hadoop.mapreduce.checkpoint.FSCheckpointID;

public class TaskCheckpointID
implements CheckpointID {
    final FSCheckpointID rawId;
    private final List<Path> partialOutput;
    private final Counters counters;

    public TaskCheckpointID() {
        this(new FSCheckpointID(), new ArrayList<Path>(), new Counters());
    }

    public TaskCheckpointID(FSCheckpointID rawId, List<Path> partialOutput, Counters counters) {
        this.rawId = rawId;
        this.counters = counters;
        this.partialOutput = null == partialOutput ? new ArrayList() : partialOutput;
    }

    public void write(DataOutput out) throws IOException {
        this.counters.write(out);
        WritableUtils.writeVLong((DataOutput)out, (long)this.partialOutput.size());
        for (Path p : this.partialOutput) {
            Text.writeString((DataOutput)out, (String)p.toString());
        }
        this.rawId.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.partialOutput.clear();
        this.counters.readFields(in);
        long numPout = WritableUtils.readVLong((DataInput)in);
        int i = 0;
        while ((long)i < numPout) {
            this.partialOutput.add(new Path(Text.readString((DataInput)in)));
            ++i;
        }
        this.rawId.readFields(in);
    }

    public boolean equals(Object other) {
        if (other instanceof TaskCheckpointID) {
            TaskCheckpointID o = (TaskCheckpointID)other;
            return this.rawId.equals(o.rawId) && this.counters.equals(o.counters) && this.partialOutput.containsAll(o.partialOutput) && o.partialOutput.containsAll(this.partialOutput);
        }
        return false;
    }

    public int hashCode() {
        return this.rawId.hashCode();
    }

    public long getCheckpointBytes() {
        return ((Counters.Counter)this.counters.findCounter(EnumCounter.CHECKPOINT_BYTES)).getValue();
    }

    public long getCheckpointTime() {
        return ((Counters.Counter)this.counters.findCounter(EnumCounter.CHECKPOINT_MS)).getValue();
    }

    public String toString() {
        return this.rawId.toString() + " counters:" + this.counters;
    }

    public List<Path> getPartialCommittedOutput() {
        return this.partialOutput;
    }

    public Counters getCounters() {
        return this.counters;
    }
}

