/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.specific.UTF8Encoding;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Syntax;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class RegexStringComparator
extends ByteArrayComparable {
    private static final Log LOG = LogFactory.getLog(RegexStringComparator.class);
    private Engine engine;

    public RegexStringComparator(String expr) {
        this(expr, 32);
    }

    public RegexStringComparator(String expr, EngineType engine) {
        this(expr, 32, engine);
    }

    public RegexStringComparator(String expr, int flags) {
        this(expr, flags, EngineType.JAVA);
    }

    public RegexStringComparator(String expr, int flags, EngineType engine) {
        super(Bytes.toBytes((String)expr));
        switch (engine) {
            case JAVA: {
                this.engine = new JavaRegexEngine(expr, flags);
                break;
            }
            case JONI: {
                this.engine = new JoniRegexEngine(expr, flags);
            }
        }
    }

    public void setCharset(Charset charset) {
        this.engine.setCharset(charset.name());
    }

    @Override
    public int compareTo(byte[] value, int offset, int length) {
        return this.engine.compareTo(value, offset, length);
    }

    @Override
    public byte[] toByteArray() {
        return this.engine.toByteArray();
    }

    public static RegexStringComparator parseFrom(byte[] pbBytes) throws DeserializationException {
        RegexStringComparator comparator;
        ComparatorProtos.RegexStringComparator proto;
        try {
            proto = ComparatorProtos.RegexStringComparator.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        if (proto.hasEngine()) {
            EngineType engine = EngineType.valueOf(proto.getEngine());
            comparator = new RegexStringComparator(proto.getPattern(), proto.getPatternFlags(), engine);
        } else {
            comparator = new RegexStringComparator(proto.getPattern(), proto.getPatternFlags());
        }
        String charset = proto.getCharset();
        if (charset.length() > 0) {
            try {
                comparator.getEngine().setCharset(charset);
            }
            catch (IllegalCharsetNameException e) {
                LOG.error((Object)"invalid charset", (Throwable)e);
            }
        }
        return comparator;
    }

    @Override
    boolean areSerializedFieldsEqual(ByteArrayComparable other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RegexStringComparator)) {
            return false;
        }
        RegexStringComparator comparator = (RegexStringComparator)other;
        return super.areSerializedFieldsEqual(comparator) && this.engine.getClass().isInstance(comparator.getEngine()) && this.engine.getPattern().equals(comparator.getEngine().getPattern()) && this.engine.getFlags() == comparator.getEngine().getFlags() && this.engine.getCharset().equals(comparator.getEngine().getCharset());
    }

    public String getCharset() {
        return this.engine.getCharset();
    }

    public String getPattern() {
        return this.engine.getPattern();
    }

    Engine getEngine() {
        return this.engine;
    }

    static class JoniRegexEngine
    implements Engine {
        private Encoding encoding = UTF8Encoding.INSTANCE;
        private String regex;
        private Regex pattern;

        public JoniRegexEngine(String regex, int flags) {
            this.regex = regex;
            byte[] b = Bytes.toBytes((String)regex);
            this.pattern = new Regex(b, 0, b.length, this.patternToJoniFlags(flags), this.encoding, Syntax.Java);
        }

        @Override
        public String getPattern() {
            return this.regex;
        }

        @Override
        public int getFlags() {
            return this.pattern.getOptions();
        }

        @Override
        public String getCharset() {
            return this.encoding.getCharsetName();
        }

        @Override
        public void setCharset(String name) {
            this.setEncoding(name);
        }

        @Override
        public int compareTo(byte[] value, int offset, int length) {
            Matcher m = this.pattern.matcher(value);
            return m.search(offset, length, this.pattern.getOptions()) < 0 ? 1 : 0;
        }

        @Override
        public byte[] toByteArray() {
            ComparatorProtos.RegexStringComparator.Builder builder = ComparatorProtos.RegexStringComparator.newBuilder();
            builder.setPattern(this.regex);
            builder.setPatternFlags(this.joniToPatternFlags(this.pattern.getOptions()));
            builder.setCharset(this.encoding.getCharsetName());
            builder.setEngine(EngineType.JONI.name());
            return builder.build().toByteArray();
        }

        private int patternToJoniFlags(int flags) {
            int newFlags = 0;
            if ((flags & 2) != 0) {
                newFlags |= 1;
            }
            if ((flags & 0x20) != 0) {
                newFlags |= 4;
            }
            if ((flags & 8) != 0) {
                newFlags &= 0xFFFFFFF7;
                newFlags |= 0x40;
            }
            return newFlags;
        }

        private int joniToPatternFlags(int flags) {
            int newFlags = 0;
            if ((flags & 1) != 0) {
                newFlags |= 2;
            }
            if ((flags & 4) != 0) {
                newFlags |= 0x20;
            }
            if ((flags & 0x40) != 0) {
                newFlags |= 8;
            }
            return newFlags;
        }

        private void setEncoding(String name) {
            EncodingDB.Entry e = (EncodingDB.Entry)EncodingDB.getEncodings().get(Bytes.toBytes((String)name));
            if (e == null) {
                throw new IllegalCharsetNameException(name);
            }
            this.encoding = e.getEncoding();
        }
    }

    static class JavaRegexEngine
    implements Engine {
        private Charset charset = Charset.forName("UTF-8");
        private Pattern pattern;

        public JavaRegexEngine(String regex, int flags) {
            this.pattern = Pattern.compile(regex, flags);
        }

        @Override
        public String getPattern() {
            return this.pattern.toString();
        }

        @Override
        public int getFlags() {
            return this.pattern.flags();
        }

        @Override
        public String getCharset() {
            return this.charset.name();
        }

        @Override
        public void setCharset(String charset) {
            this.charset = Charset.forName(charset);
        }

        @Override
        public int compareTo(byte[] value, int offset, int length) {
            String tmp = length < value.length / 2 ? new String(Arrays.copyOfRange(value, offset, offset + length), this.charset) : new String(value, offset, length, this.charset);
            return this.pattern.matcher(tmp).find() ? 0 : 1;
        }

        @Override
        public byte[] toByteArray() {
            ComparatorProtos.RegexStringComparator.Builder builder = ComparatorProtos.RegexStringComparator.newBuilder();
            builder.setPattern(this.pattern.pattern());
            builder.setPatternFlags(this.pattern.flags());
            builder.setCharset(this.charset.name());
            builder.setEngine(EngineType.JAVA.name());
            return builder.build().toByteArray();
        }
    }

    static interface Engine {
        public String getPattern();

        public int getFlags();

        public String getCharset();

        public void setCharset(String var1);

        public byte[] toByteArray();

        public int compareTo(byte[] var1, int var2, int var3);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static enum EngineType {
        JAVA,
        JONI;

    }
}

