/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hdfs.nfs.conf.NfsConfiguration;
import org.apache.hadoop.hdfs.nfs.nfs3.OpenFileCtx;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OpenFileCtxCache {
    private static final Logger LOG = LoggerFactory.getLogger(OpenFileCtxCache.class);
    private final ConcurrentMap<FileHandle, OpenFileCtx> openFileMap = Maps.newConcurrentMap();
    private final int maxStreams;
    private final long streamTimeout;
    private final StreamMonitor streamMonitor;

    OpenFileCtxCache(NfsConfiguration config, long streamTimeout) {
        this.maxStreams = config.getInt("nfs.max.open.files", 256);
        LOG.info("Maximum open streams is " + this.maxStreams);
        this.streamTimeout = streamTimeout;
        this.streamMonitor = new StreamMonitor();
    }

    @VisibleForTesting
    Map.Entry<FileHandle, OpenFileCtx> getEntryToEvict() {
        Iterator it = this.openFileMap.entrySet().iterator();
        if (LOG.isTraceEnabled()) {
            LOG.trace("openFileMap size:" + this.size());
        }
        Map.Entry<FileHandle, OpenFileCtx> idlest = null;
        while (it.hasNext()) {
            Map.Entry<FileHandle, OpenFileCtx> pairs = it.next();
            OpenFileCtx ctx = (OpenFileCtx)pairs.getValue();
            if (!ctx.getActiveState()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Got one inactive stream: " + ctx);
                }
                return pairs;
            }
            if (ctx.hasPendingWork()) continue;
            if (idlest == null) {
                idlest = pairs;
                continue;
            }
            if (ctx.getLastAccessTime() >= idlest.getValue().getLastAccessTime()) continue;
            idlest = pairs;
        }
        if (idlest == null) {
            LOG.warn("No eviction candidate. All streams have pending work.");
            return null;
        }
        long idleTime = Time.monotonicNow() - ((OpenFileCtx)idlest.getValue()).getLastAccessTime();
        if (idleTime < 10000L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("idlest stream's idle time:" + idleTime);
            }
            LOG.warn("All opened streams are busy, can't remove any from cache.");
            return null;
        }
        return idlest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean put(FileHandle h, OpenFileCtx context) {
        OpenFileCtx toEvict = null;
        OpenFileCtxCache openFileCtxCache = this;
        synchronized (openFileCtxCache) {
            Preconditions.checkState((this.size() <= this.maxStreams ? 1 : 0) != 0, (Object)("stream cache size " + this.size() + "  is larger than maximum" + this.maxStreams));
            if (this.size() == this.maxStreams) {
                Map.Entry<FileHandle, OpenFileCtx> pairs = this.getEntryToEvict();
                if (pairs == null) {
                    return false;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Evict stream ctx: " + pairs.getValue());
                }
                Preconditions.checkState(((toEvict = (OpenFileCtx)this.openFileMap.remove(pairs.getKey())) == pairs.getValue() ? 1 : 0) != 0, (Object)"The deleted entry is not the same as odlest found.");
            }
            this.openFileMap.put(h, context);
        }
        if (toEvict != null) {
            toEvict.cleanup();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void scan(long streamTimeout) {
        ArrayList<OpenFileCtx> ctxToRemove = new ArrayList<OpenFileCtx>();
        Iterator it = this.openFileMap.entrySet().iterator();
        if (LOG.isTraceEnabled()) {
            LOG.trace("openFileMap size:" + this.size());
        }
        while (it.hasNext()) {
            Map.Entry pairs = it.next();
            FileHandle handle = (FileHandle)pairs.getKey();
            OpenFileCtx ctx = (OpenFileCtx)pairs.getValue();
            if (!ctx.streamCleanup(handle, streamTimeout)) continue;
            OpenFileCtxCache openFileCtxCache = this;
            synchronized (openFileCtxCache) {
                OpenFileCtx ctx2 = (OpenFileCtx)this.openFileMap.get(handle);
                if (ctx2 != null && ctx2.streamCleanup(handle, streamTimeout)) {
                    this.openFileMap.remove(handle);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("After remove stream " + handle.dumpFileHandle() + ", the stream number:" + this.size());
                    }
                    ctxToRemove.add(ctx2);
                }
            }
        }
        for (OpenFileCtx ofc : ctxToRemove) {
            ofc.cleanup();
        }
    }

    OpenFileCtx get(FileHandle key) {
        return (OpenFileCtx)this.openFileMap.get(key);
    }

    int size() {
        return this.openFileMap.size();
    }

    void start() {
        this.streamMonitor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanAll() {
        ArrayList<OpenFileCtx> cleanedContext = new ArrayList<OpenFileCtx>();
        OpenFileCtxCache openFileCtxCache = this;
        synchronized (openFileCtxCache) {
            Iterator it = this.openFileMap.entrySet().iterator();
            if (LOG.isTraceEnabled()) {
                LOG.trace("openFileMap size:" + this.size());
            }
            while (it.hasNext()) {
                Map.Entry pairs = it.next();
                OpenFileCtx ctx = (OpenFileCtx)pairs.getValue();
                it.remove();
                cleanedContext.add(ctx);
            }
        }
        for (OpenFileCtx ofc : cleanedContext) {
            ofc.cleanup();
        }
    }

    void shutdown() {
        if (this.streamMonitor.isAlive()) {
            this.streamMonitor.shouldRun(false);
            this.streamMonitor.interrupt();
            try {
                this.streamMonitor.join(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.cleanAll();
    }

    class StreamMonitor
    extends Daemon {
        private static final int rotation = 5000;
        private long lastWakeupTime = 0L;
        private boolean shouldRun = true;

        StreamMonitor() {
        }

        void shouldRun(boolean shouldRun) {
            this.shouldRun = shouldRun;
        }

        public void run() {
            while (this.shouldRun) {
                OpenFileCtxCache.this.scan(OpenFileCtxCache.this.streamTimeout);
                try {
                    long workedTime = Time.monotonicNow() - this.lastWakeupTime;
                    if (workedTime < 5000L) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("StreamMonitor can still have a sleep:" + (5000L - workedTime) / 1000L);
                        }
                        Thread.sleep(5000L - workedTime);
                    }
                    this.lastWakeupTime = Time.monotonicNow();
                }
                catch (InterruptedException e) {
                    LOG.info("StreamMonitor got interrupted");
                    return;
                }
            }
        }
    }
}

