/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.login;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.hadoop.util.PlatformName;

public class GenericOSLoginModule
implements LoginModule {
    private LoginModule realModule;
    public static final String OS_LOGIN_MODULE_NAME = GenericOSLoginModule.getOSLoginModuleName();

    private static String getOSLoginModuleName() {
        if (PlatformName.IBM_JAVA) {
            if (PlatformName.IS_WINDOWS) {
                return PlatformName.IS_64BIT ? "com.ibm.security.auth.module.Win64LoginModule" : "com.ibm.security.auth.module.NTLoginModule";
            }
            if (PlatformName.IS_AIX) {
                return PlatformName.IS_64BIT ? "com.ibm.security.auth.module.AIX64LoginModule" : "com.ibm.security.auth.module.AIXLoginModule";
            }
            return "com.ibm.security.auth.module.LinuxLoginModule";
        }
        return PlatformName.IS_WINDOWS ? "com.sun.security.auth.module.NTLoginModule" : "com.sun.security.auth.module.UnixLoginModule";
    }

    @Override
    public boolean abort() throws LoginException {
        return this.realModule.abort();
    }

    @Override
    public boolean commit() throws LoginException {
        return this.realModule.commit();
    }

    @Override
    public void initialize(Subject arg0, CallbackHandler arg1, Map<String, ?> arg2, Map<String, ?> arg3) {
        try {
            this.realModule = (LoginModule)Class.forName(OS_LOGIN_MODULE_NAME).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failure to instantiate needed login module: " + OS_LOGIN_MODULE_NAME, e);
        }
        this.realModule.initialize(arg0, arg1, arg2, arg3);
    }

    @Override
    public boolean login() throws LoginException {
        return this.realModule.login();
    }

    @Override
    public boolean logout() throws LoginException {
        return this.realModule.logout();
    }
}

