/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.MultiMechsAuthenticationHandler;
import org.apache.hadoop.shaded.javax.servlet.ServletException;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMaprAuthenticationHandler
extends MultiMechsAuthenticationHandler {
    private static Logger LOG = LoggerFactory.getLogger(AbstractMaprAuthenticationHandler.class);
    private final String ticketGenerationClass = "org.apache.hadoop.shaded.com.mapr.security.ClusterServerTicketGeneration";
    public static final String TYPE = "maprauth";

    @Override
    public abstract void init(Properties var1) throws ServletException;

    public abstract AuthenticationToken maprAuthenticate(HttpServletRequest var1, HttpServletResponse var2) throws IOException, AuthenticationException;

    @Override
    public void destroy() {
    }

    @Override
    public AuthenticationToken postauthenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        if (request.getHeader("Authorization") != null) {
            return this.maprAuthenticate(request, response);
        }
        return null;
    }

    @Override
    public void addHeader(HttpServletResponse response) {
        response.addHeader("WWW-Authenticate", "MAPR-Negotiate");
    }

    @Override
    public MultiMechsAuthenticationHandler getAuthBasedEntity(String authorization) {
        if (authorization != null && authorization.startsWith("MAPR-Negotiate")) {
            return this;
        }
        return null;
    }
}

