/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.http.HadoopCoreAuthenticationFilter;

public class HadoopCoreAuthenticationFilterInitializer
extends FilterInitializer {
    private static final String HTTP_AUTH_PREFIX = "hadoop.http.authentication.";

    protected Map<String, String> createFilterConfig(Configuration conf) {
        HashMap<String, String> filterConfig = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : conf) {
            String name = entry.getKey();
            if (!name.startsWith(HTTP_AUTH_PREFIX)) continue;
            String value = conf.get(name);
            name = name.substring(HTTP_AUTH_PREFIX.length());
            filterConfig.put(name, value);
        }
        return filterConfig;
    }

    @Override
    public void initFilter(FilterContainer container, Configuration conf) {
        Map<String, String> filterConfig = this.createFilterConfig(conf);
        if (conf.getBoolean("hadoop.http.core.filter.enable", true)) {
            container.addGlobalFilter("HadoopCoreAuthentication", HadoopCoreAuthenticationFilter.class.getName(), filterConfig);
        }
    }
}

