/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.NodeResourceUpdaterPlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.FpgaDevice;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.FpgaDiscoverer;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FpgaNodeResourceUpdateHandler
extends NodeResourceUpdaterPlugin {
    private final FpgaDiscoverer fpgaDiscoverer;
    private static final Logger LOG = LoggerFactory.getLogger(FpgaNodeResourceUpdateHandler.class);

    public FpgaNodeResourceUpdateHandler(FpgaDiscoverer fpgaDiscoverer) {
        this.fpgaDiscoverer = fpgaDiscoverer;
    }

    @Override
    public void updateConfiguredResource(Resource res) throws YarnException {
        LOG.info("Initializing configured FPGA resources for the NodeManager.");
        List<FpgaDevice> list = this.fpgaDiscoverer.getCurrentFpgaInfo();
        LinkedList<Integer> minors = new LinkedList<Integer>();
        for (FpgaDevice device : list) {
            minors.add(device.getMinor());
        }
        if (minors.isEmpty()) {
            LOG.info("Didn't find any usable FPGAs on the NodeManager.");
            return;
        }
        long count = minors.size();
        Map configuredResourceTypes = ResourceUtils.getResourceTypes();
        if (!configuredResourceTypes.containsKey("yarn.io/fpga")) {
            throw new YarnException("Wrong configurations, found " + count + " usable FPGAs, however " + "yarn.io/fpga" + " resource-type is not configured inside resource-types.xml, please configure it to enable FPGA feature or remove " + "yarn.io/fpga" + " from " + "yarn.nodemanager.resource-plugins");
        }
        res.setResourceValue("yarn.io/fpga", count);
    }
}

