/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class TrafficController {
    private static final Logger LOG = LoggerFactory.getLogger(TrafficController.class);
    private static final int ROOT_QDISC_HANDLE = 42;
    private static final int ZERO_CLASS_ID = 0;
    private static final int ROOT_CLASS_ID = 1;
    private static final int DEFAULT_CLASS_ID = 2;
    private static final int YARN_ROOT_CLASS_ID = 3;
    private static final int MIN_CONTAINER_CLASS_ID = 4;
    private static final int MAX_CONTAINER_CLASSES = 1024;
    private static final String MBIT_SUFFIX = "mbit";
    private static final String TMP_FILE_PREFIX = "tc.";
    private static final String TMP_FILE_SUFFIX = ".cmds";
    private static final String FORMAT_QDISC_ADD_TO_ROOT_WITH_DEFAULT = "qdisc add dev %s root handle %d: htb default %s";
    private static final String FORMAT_FILTER_CGROUP_ADD_TO_PARENT = "filter add dev %s parent %d: protocol ip prio 10 handle 1: cgroup";
    private static final String FORMAT_CLASS_ADD_TO_PARENT_WITH_RATES = "class add dev %s parent %d:%d classid %d:%d htb rate %s ceil %s";
    private static final String FORMAT_DELETE_CLASS = "class del dev %s classid %d:%d";
    private static final String FORMAT_NET_CLS_CLASS_ID = "0x%04d%04d";
    private static final String FORMAT_READ_STATE = "qdisc show dev %1$s%nfilter show dev %1$s%nclass show dev %1$s";
    private static final String FORMAT_READ_CLASSES = "class show dev %s";
    private static final String FORMAT_WIPE_STATE = "qdisc del dev %s parent root";
    private final Configuration conf;
    private final BitSet classIdSet;
    private final PrivilegedOperationExecutor privilegedOperationExecutor;
    private String tmpDirPath;
    private String device;
    private int rootBandwidthMbit;
    private int yarnBandwidthMbit;
    private int defaultClassBandwidthMbit;

    TrafficController(Configuration conf, PrivilegedOperationExecutor exec) {
        this.conf = conf;
        this.classIdSet = new BitSet(1024);
        this.privilegedOperationExecutor = exec;
    }

    public void bootstrap(String device, int rootBandwidthMbit, int yarnBandwidthMbit) throws ResourceHandlerException {
        if (device == null) {
            throw new ResourceHandlerException("device cannot be null!");
        }
        String tmpDirBase = this.conf.get("hadoop.tmp.dir");
        if (tmpDirBase == null) {
            throw new ResourceHandlerException("hadoop.tmp.dir not set!");
        }
        this.tmpDirPath = tmpDirBase + "/nm-tc-rules";
        File tmpDir = new File(this.tmpDirPath);
        if (!tmpDir.exists() && !tmpDir.mkdirs()) {
            LOG.warn("Unable to create directory: " + this.tmpDirPath);
            throw new ResourceHandlerException("Unable to create directory: " + this.tmpDirPath);
        }
        this.device = device;
        this.rootBandwidthMbit = rootBandwidthMbit;
        this.yarnBandwidthMbit = yarnBandwidthMbit;
        this.defaultClassBandwidthMbit = rootBandwidthMbit - yarnBandwidthMbit <= 0 ? rootBandwidthMbit : rootBandwidthMbit - yarnBandwidthMbit;
        boolean recoveryEnabled = this.conf.getBoolean("yarn.nodemanager.recovery.enabled", true);
        String state = null;
        if (!recoveryEnabled) {
            LOG.info("NM recovery is not enabled. We'll wipe tc state before proceeding.");
        } else {
            state = this.readState();
            if (this.checkIfAlreadyBootstrapped(state)) {
                LOG.info("TC configuration is already in place. Not wiping state.");
                this.reacquireContainerClasses(state);
                return;
            }
            LOG.info("TC configuration is incomplete. Wiping tc state before proceeding");
        }
        this.wipeState();
        this.initializeState();
    }

    private void initializeState() throws ResourceHandlerException {
        LOG.info("Initializing tc state.");
        BatchBuilder builder = new BatchBuilder(PrivilegedOperation.OperationType.TC_MODIFY_STATE).addRootQDisc().addCGroupFilter().addClassToRootQDisc(this.rootBandwidthMbit).addDefaultClass(this.defaultClassBandwidthMbit, this.rootBandwidthMbit).addYARNRootClass(this.yarnBandwidthMbit, this.yarnBandwidthMbit);
        PrivilegedOperation op = builder.commitBatchToTempFile();
        try {
            this.privilegedOperationExecutor.executePrivilegedOperation(op, false);
        }
        catch (PrivilegedOperationException e) {
            LOG.warn("Failed to bootstrap outbound bandwidth configuration");
            throw new ResourceHandlerException("Failed to bootstrap outbound bandwidth configuration", (Throwable)((Object)e));
        }
    }

    private boolean checkIfAlreadyBootstrapped(String state) throws ResourceHandlerException {
        ArrayList<String> regexes = new ArrayList<String>();
        regexes.add(String.format("^qdisc htb %d: root(.)*$", 42));
        regexes.add(String.format("^filter parent %d: protocol ip (.)*cgroup(.)*$", 42));
        regexes.add(String.format("^class htb %d:%d root(.)*$", 42, 1));
        regexes.add(String.format("^class htb %d:%d parent %d:%d(.)*$", 42, 2, 42, 1));
        regexes.add(String.format("^class htb %d:%d parent %d:%d(.)*$", 42, 3, 42, 1));
        for (String regex : regexes) {
            Pattern pattern = Pattern.compile(regex, 8);
            if (pattern.matcher(state).find()) {
                LOG.debug("Matched regex: {}", (Object)regex);
                continue;
            }
            String logLine = new StringBuffer("Failed to match regex: ").append(regex).append(" Current state: ").append(state).toString();
            LOG.warn(logLine);
            return false;
        }
        LOG.info("Bootstrap check succeeded");
        return true;
    }

    private String readState() throws ResourceHandlerException {
        BatchBuilder builder = new BatchBuilder(PrivilegedOperation.OperationType.TC_READ_STATE).readState();
        PrivilegedOperation op = builder.commitBatchToTempFile();
        try {
            String output = this.privilegedOperationExecutor.executePrivilegedOperation(op, true);
            LOG.debug("TC state: {}" + output);
            return output;
        }
        catch (PrivilegedOperationException e) {
            LOG.warn("Failed to bootstrap outbound bandwidth rules");
            throw new ResourceHandlerException("Failed to bootstrap outbound bandwidth rules", (Throwable)((Object)e));
        }
    }

    private void wipeState() throws ResourceHandlerException {
        BatchBuilder builder = new BatchBuilder(PrivilegedOperation.OperationType.TC_MODIFY_STATE).wipeState();
        PrivilegedOperation op = builder.commitBatchToTempFile();
        try {
            LOG.info("Wiping tc state.");
            this.privilegedOperationExecutor.executePrivilegedOperation(op, false);
        }
        catch (PrivilegedOperationException e) {
            LOG.warn("Failed to wipe tc state. This could happen if the interface is already in its default state. Ignoring.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reacquireContainerClasses(String state) {
        String tcClassesStr = state.substring(state.indexOf("class"));
        String[] tcClasses = Pattern.compile("$", 8).split(tcClassesStr);
        Pattern tcClassPattern = Pattern.compile(String.format("class htb %d:(\\d+) .*", 42));
        BitSet bitSet = this.classIdSet;
        synchronized (bitSet) {
            for (String tcClassSplit : tcClasses) {
                String tcClass = tcClassSplit.trim();
                if (tcClass.isEmpty()) continue;
                Matcher classMatcher = tcClassPattern.matcher(tcClass);
                if (classMatcher.matches()) {
                    int classId = Integer.parseInt(classMatcher.group(1));
                    if (classId < 4) continue;
                    this.classIdSet.set(classId - 4);
                    LOG.info("Reacquired container classid: " + classId);
                    continue;
                }
                LOG.warn("Unable to match classid in string:" + tcClass);
            }
        }
    }

    public Map<Integer, Integer> readStats() throws ResourceHandlerException {
        BatchBuilder builder = new BatchBuilder(PrivilegedOperation.OperationType.TC_READ_STATS).readClasses();
        PrivilegedOperation op = builder.commitBatchToTempFile();
        try {
            String output = this.privilegedOperationExecutor.executePrivilegedOperation(op, true);
            LOG.debug("TC stats output:{}", (Object)output);
            Map<Integer, Integer> classIdBytesStats = this.parseStatsString(output);
            LOG.debug("classId -> bytes sent {}", classIdBytesStats);
            return classIdBytesStats;
        }
        catch (PrivilegedOperationException e) {
            LOG.warn("Failed to get tc stats");
            throw new ResourceHandlerException("Failed to get tc stats", (Throwable)((Object)e));
        }
    }

    private Map<Integer, Integer> parseStatsString(String stats) {
        String[] lines = Pattern.compile("$", 8).split(stats);
        Pattern tcClassPattern = Pattern.compile(String.format("class htb %d:(\\d+) .*", 42));
        Pattern bytesPattern = Pattern.compile("Sent (\\d+) bytes.*");
        int currentClassId = -1;
        HashMap<Integer, Integer> containerClassIdStats = new HashMap<Integer, Integer>();
        for (String lineSplit : lines) {
            int classId;
            String line = lineSplit.trim();
            if (line.isEmpty()) continue;
            Matcher classMatcher = tcClassPattern.matcher(line);
            if (classMatcher.matches() && (classId = Integer.parseInt(classMatcher.group(1))) >= 4) {
                currentClassId = classId;
                continue;
            }
            Matcher bytesMatcher = bytesPattern.matcher(line);
            if (!bytesMatcher.matches()) continue;
            if (currentClassId != -1) {
                int bytes = Integer.parseInt(bytesMatcher.group(1));
                containerClassIdStats.put(currentClassId, bytes);
                continue;
            }
            LOG.warn("Matched a 'bytes sent' line outside of a class stats segment : " + line);
        }
        return containerClassIdStats;
    }

    private String getStringForAddRootQDisc() {
        return String.format(FORMAT_QDISC_ADD_TO_ROOT_WITH_DEFAULT, this.device, 42, 2);
    }

    private String getStringForaAddCGroupFilter() {
        return String.format(FORMAT_FILTER_CGROUP_ADD_TO_PARENT, this.device, 42);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextClassId() throws ResourceHandlerException {
        BitSet bitSet = this.classIdSet;
        synchronized (bitSet) {
            int index = this.classIdSet.nextClearBit(0);
            if (index >= 1024) {
                throw new ResourceHandlerException("Reached max container classes: 1024");
            }
            this.classIdSet.set(index);
            return index + 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseClassId(int classId) throws ResourceHandlerException {
        BitSet bitSet = this.classIdSet;
        synchronized (bitSet) {
            int index = classId - 4;
            if (index < 0 || index >= 1024) {
                throw new ResourceHandlerException("Invalid incoming classId: " + classId);
            }
            this.classIdSet.clear(index);
        }
    }

    public String getStringForNetClsClassId(int classId) {
        return String.format(FORMAT_NET_CLS_CLASS_ID, 42, classId);
    }

    public int getClassIdFromFileContents(String input) {
        String classIdStr = String.format("%08x", Integer.parseInt(input));
        LOG.debug("ClassId hex string : {}", (Object)classIdStr);
        return Integer.parseInt(classIdStr.substring(4));
    }

    private String getStringForAddClassToRootQDisc(int rateMbit) {
        String rateMbitStr = rateMbit + MBIT_SUFFIX;
        return String.format(FORMAT_CLASS_ADD_TO_PARENT_WITH_RATES, this.device, 42, 0, 42, 1, rateMbitStr, rateMbitStr);
    }

    private String getStringForAddDefaultClass(int rateMbit, int ceilMbit) {
        String rateMbitStr = rateMbit + MBIT_SUFFIX;
        String ceilMbitStr = ceilMbit + MBIT_SUFFIX;
        return String.format(FORMAT_CLASS_ADD_TO_PARENT_WITH_RATES, this.device, 42, 1, 42, 2, rateMbitStr, ceilMbitStr);
    }

    private String getStringForAddYARNRootClass(int rateMbit, int ceilMbit) {
        String rateMbitStr = rateMbit + MBIT_SUFFIX;
        String ceilMbitStr = ceilMbit + MBIT_SUFFIX;
        return String.format(FORMAT_CLASS_ADD_TO_PARENT_WITH_RATES, this.device, 42, 1, 42, 3, rateMbitStr, ceilMbitStr);
    }

    private String getStringForAddContainerClass(int classId, int rateMbit, int ceilMbit) {
        String rateMbitStr = rateMbit + MBIT_SUFFIX;
        String ceilMbitStr = ceilMbit + MBIT_SUFFIX;
        return String.format(FORMAT_CLASS_ADD_TO_PARENT_WITH_RATES, this.device, 42, 3, 42, classId, rateMbitStr, ceilMbitStr);
    }

    private String getStringForDeleteContainerClass(int classId) {
        return String.format(FORMAT_DELETE_CLASS, this.device, 42, classId);
    }

    private String getStringForReadState() {
        return String.format(FORMAT_READ_STATE, this.device);
    }

    private String getStringForReadClasses() {
        return String.format(FORMAT_READ_CLASSES, this.device);
    }

    private String getStringForWipeState() {
        return String.format(FORMAT_WIPE_STATE, this.device);
    }

    public class BatchBuilder {
        final PrivilegedOperation operation;
        final List<String> commands;

        public BatchBuilder(PrivilegedOperation.OperationType opType) throws ResourceHandlerException {
            switch (opType) {
                case TC_MODIFY_STATE: 
                case TC_READ_STATE: 
                case TC_READ_STATS: {
                    this.operation = new PrivilegedOperation(opType);
                    this.commands = new ArrayList<String>();
                    break;
                }
                default: {
                    throw new ResourceHandlerException("Not a tc operation type : " + (Object)((Object)opType));
                }
            }
        }

        private BatchBuilder addRootQDisc() {
            this.commands.add(TrafficController.this.getStringForAddRootQDisc());
            return this;
        }

        private BatchBuilder addCGroupFilter() {
            this.commands.add(TrafficController.this.getStringForaAddCGroupFilter());
            return this;
        }

        private BatchBuilder addClassToRootQDisc(int rateMbit) {
            this.commands.add(TrafficController.this.getStringForAddClassToRootQDisc(rateMbit));
            return this;
        }

        private BatchBuilder addDefaultClass(int rateMbit, int ceilMbit) {
            this.commands.add(TrafficController.this.getStringForAddDefaultClass(rateMbit, ceilMbit));
            return this;
        }

        private BatchBuilder addYARNRootClass(int rateMbit, int ceilMbit) {
            this.commands.add(TrafficController.this.getStringForAddYARNRootClass(rateMbit, ceilMbit));
            return this;
        }

        public BatchBuilder addContainerClass(int classId, int rateMbit, boolean strictMode) {
            int ceilMbit = strictMode ? rateMbit : TrafficController.this.yarnBandwidthMbit;
            this.commands.add(TrafficController.this.getStringForAddContainerClass(classId, rateMbit, ceilMbit));
            return this;
        }

        public BatchBuilder deleteContainerClass(int classId) {
            this.commands.add(TrafficController.this.getStringForDeleteContainerClass(classId));
            return this;
        }

        private BatchBuilder readState() {
            this.commands.add(TrafficController.this.getStringForReadState());
            return this;
        }

        private BatchBuilder readClasses() {
            this.commands.add(TrafficController.this.getStringForReadClasses());
            return this;
        }

        private BatchBuilder wipeState() {
            this.commands.add(TrafficController.this.getStringForWipeState());
            return this;
        }

        public PrivilegedOperation commitBatchToTempFile() throws ResourceHandlerException {
            try {
                File tcCmds = File.createTempFile(TrafficController.TMP_FILE_PREFIX, TrafficController.TMP_FILE_SUFFIX, new File(TrafficController.this.tmpDirPath));
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tcCmds), "UTF-8");
                     PrintWriter printWriter = new PrintWriter(writer);){
                    for (String command : this.commands) {
                        printWriter.println(command);
                    }
                }
                this.operation.appendArgs(tcCmds.getAbsolutePath());
                return this.operation;
            }
            catch (IOException e) {
                LOG.warn("Failed to create or write to temporary file in dir: " + TrafficController.this.tmpDirPath);
                throw new ResourceHandlerException("Failed to create or write to temporary file in dir: " + TrafficController.this.tmpDirPath);
            }
        }
    }
}

