/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.resourceestimator.common.serialization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.NavigableMap;
import org.apache.hadoop.resourceestimator.common.serialization.ResourceSerDe;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;

public class RLESparseResourceAllocationSerDe
implements JsonSerializer<RLESparseResourceAllocation>,
JsonDeserializer<RLESparseResourceAllocation> {
    private static final String KEY = "resourceAllocation";
    private final Gson gson = new GsonBuilder().registerTypeAdapter(Resource.class, (Object)new ResourceSerDe()).create();
    private final Type type = new TypeToken<NavigableMap<Long, Resource>>(){}.getType();
    private final ResourceCalculator resourceCalculator = new DefaultResourceCalculator();

    public final JsonElement serialize(RLESparseResourceAllocation resourceAllocation, Type typeOfSrc, JsonSerializationContext context) {
        NavigableMap myMap = resourceAllocation.getCumulative();
        JsonObject jo = new JsonObject();
        JsonElement element = this.gson.toJsonTree((Object)myMap, this.type);
        jo.add(KEY, element);
        return jo;
    }

    public final RLESparseResourceAllocation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        NavigableMap resAllocation = (NavigableMap)this.gson.fromJson(json.getAsJsonObject().get(KEY), this.type);
        RLESparseResourceAllocation rleSparseResourceAllocation = new RLESparseResourceAllocation(resAllocation, this.resourceCalculator);
        return rleSparseResourceAllocation;
    }
}

