/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.utils;

import java.io.Closeable;

public class Duration
implements Closeable {
    public long start;
    public long finish;
    public final long limit;

    public Duration() {
        this(0L);
    }

    public Duration(long limit) {
        this.limit = limit;
    }

    public Duration start() {
        this.start = this.now();
        return this;
    }

    @Override
    public final void close() {
        this.finish();
    }

    public void finish() {
        this.finish = this.now();
    }

    protected long now() {
        return System.nanoTime() / 1000000L;
    }

    public long getInterval() {
        return this.finish - this.start;
    }

    public boolean getLimitExceeded() {
        return this.limit >= 0L && this.now() - this.start > this.limit;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Duration");
        if (this.finish >= this.start) {
            builder.append(" finished at ").append(this.getInterval()).append(" millis;");
        } else if (this.start > 0L) {
            builder.append(" started but not yet finished;");
        } else {
            builder.append(" unstarted;");
        }
        if (this.limit > 0L) {
            builder.append(" limit: ").append(this.limit).append(" millis");
            if (this.getLimitExceeded()) {
                builder.append(" -  exceeded");
            }
        }
        return builder.toString();
    }
}

