/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.monitor.probe;

import java.util.Formatter;
import java.util.Locale;
import org.apache.hadoop.yarn.service.api.records.ReadinessCheck;
import org.apache.hadoop.yarn.service.monitor.probe.DefaultProbe;
import org.apache.hadoop.yarn.service.monitor.probe.HttpProbe;
import org.apache.hadoop.yarn.service.monitor.probe.PortProbe;
import org.apache.hadoop.yarn.service.monitor.probe.Probe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MonitorUtils {
    protected static final Logger LOG = LoggerFactory.getLogger(MonitorUtils.class);

    private MonitorUtils() {
    }

    public static String toPlural(int val) {
        return val != 1 ? "s" : "";
    }

    public static String millisToHumanTime(long milliseconds) {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        long s = Math.abs(milliseconds / 1000L);
        long m = Math.abs(milliseconds % 1000L);
        if (milliseconds > 0L) {
            formatter.format("%d.%03ds", s, m);
        } else if (milliseconds == 0L) {
            formatter.format("0", new Object[0]);
        } else {
            formatter.format("-%d.%03ds", s, m);
        }
        return sb.toString();
    }

    public static Probe getProbe(ReadinessCheck readinessCheck) {
        try {
            if (readinessCheck == null) {
                return DefaultProbe.create();
            }
            if (readinessCheck.getType() == null) {
                return DefaultProbe.create(readinessCheck.getProperties());
            }
            switch (readinessCheck.getType()) {
                case HTTP: {
                    return HttpProbe.create(readinessCheck.getProperties());
                }
                case PORT: {
                    return PortProbe.create(readinessCheck.getProperties());
                }
            }
            return DefaultProbe.create(readinessCheck.getProperties());
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Error creating readiness check " + t);
        }
    }
}

