/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HBaseTimelineStorageUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseTimelineStorageUtils.class);

    private HBaseTimelineStorageUtils() {
    }

    public static Configuration getTimelineServiceHBaseConf(Configuration conf) throws IOException {
        Configuration hbaseConf;
        block14: {
            if (conf == null) {
                throw new NullPointerException();
            }
            String timelineServiceHBaseConfFilePath = conf.get("yarn.timeline-service.hbase.configuration.file");
            if (timelineServiceHBaseConfFilePath != null && timelineServiceHBaseConfFilePath.length() > 0) {
                LOG.info("Using hbase configuration at " + timelineServiceHBaseConfFilePath);
                hbaseConf = new Configuration(conf);
                Configuration plainHBaseConf = new Configuration(false);
                Path hbaseConfigPath = new Path(timelineServiceHBaseConfFilePath);
                try (FileSystem fs = FileSystem.newInstance((URI)hbaseConfigPath.toUri(), (Configuration)conf);
                     FSDataInputStream in = fs.open(hbaseConfigPath);){
                    plainHBaseConf.addResource((InputStream)in);
                    HBaseConfiguration.merge((Configuration)hbaseConf, (Configuration)plainHBaseConf);
                    break block14;
                }
            }
            hbaseConf = HBaseConfiguration.create((Configuration)conf);
        }
        return hbaseConf;
    }

    public static byte[] calculateTheClosestNextRowKeyForPrefix(byte[] rowKeyPrefix) {
        int offset;
        for (offset = rowKeyPrefix.length; offset > 0 && rowKeyPrefix[offset - 1] == -1; --offset) {
        }
        if (offset == 0) {
            return HConstants.EMPTY_END_ROW;
        }
        byte[] newStopRow = Arrays.copyOfRange(rowKeyPrefix, 0, offset);
        int n = newStopRow.length - 1;
        newStopRow[n] = (byte)(newStopRow[n] + 1);
        return newStopRow;
    }

    public static void setMetricsTimeRange(Query query, byte[] metricsCf, long tsBegin, long tsEnd) {
        if (tsBegin != 0L || tsEnd != Long.MAX_VALUE) {
            query.setColumnFamilyTimeRange(metricsCf, tsBegin, tsEnd == Long.MAX_VALUE ? Long.MAX_VALUE : tsEnd + 1L);
        }
    }
}

