/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class DescribeTopicsResult {
    private final Map<Uuid, KafkaFuture<TopicDescription>> topicIdFutures;
    private final Map<String, KafkaFuture<TopicDescription>> nameFutures;

    @Deprecated
    DescribeTopicsResult(Map<String, KafkaFuture<TopicDescription>> futures) {
        this(null, futures);
    }

    protected DescribeTopicsResult(Map<Uuid, KafkaFuture<TopicDescription>> topicIdFutures, Map<String, KafkaFuture<TopicDescription>> nameFutures) {
        if (topicIdFutures != null && nameFutures != null) {
            throw new IllegalArgumentException("topicIdFutures and nameFutures cannot both be specified.");
        }
        if (topicIdFutures == null && nameFutures == null) {
            throw new IllegalArgumentException("topicIdFutures and nameFutures cannot both be null.");
        }
        this.topicIdFutures = topicIdFutures;
        this.nameFutures = nameFutures;
    }

    public static DescribeTopicsResult ofTopicIds(Map<Uuid, KafkaFuture<TopicDescription>> topicIdFutures) {
        return new DescribeTopicsResult(topicIdFutures, null);
    }

    public static DescribeTopicsResult ofTopicNames(Map<String, KafkaFuture<TopicDescription>> nameFutures) {
        return new DescribeTopicsResult(null, nameFutures);
    }

    public Map<Uuid, KafkaFuture<TopicDescription>> topicIdValues() {
        return this.topicIdFutures;
    }

    public Map<String, KafkaFuture<TopicDescription>> topicNameValues() {
        return this.nameFutures;
    }

    @Deprecated
    public Map<String, KafkaFuture<TopicDescription>> values() {
        return this.nameFutures;
    }

    @Deprecated
    public KafkaFuture<Map<String, TopicDescription>> all() {
        return DescribeTopicsResult.all(this.nameFutures);
    }

    public KafkaFuture<Map<String, TopicDescription>> allTopicNames() {
        return DescribeTopicsResult.all(this.nameFutures);
    }

    public KafkaFuture<Map<Uuid, TopicDescription>> allTopicIds() {
        return DescribeTopicsResult.all(this.topicIdFutures);
    }

    private static <T> KafkaFuture<Map<T, TopicDescription>> all(Map<T, KafkaFuture<TopicDescription>> futures) {
        KafkaFuture<Void> future = KafkaFuture.allOf(futures.values().toArray(new KafkaFuture[0]));
        return future.thenApply(v -> {
            HashMap descriptions = new HashMap(futures.size());
            for (Map.Entry entry : futures.entrySet()) {
                try {
                    descriptions.put(entry.getKey(), (TopicDescription)((KafkaFuture)entry.getValue()).get());
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            return descriptions;
        });
    }
}

