/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.tools.rumen.LoggedJob;
import org.apache.hadoop.tools.rumen.LoggedTask;
import org.apache.hadoop.tools.rumen.LoggedTaskAttempt;
import org.apache.hadoop.tools.rumen.datatypes.UserName;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.sls.AMDefinition;
import org.apache.hadoop.yarn.sls.AMDefinitionFactory;
import org.apache.hadoop.yarn.sls.SLSRunner;
import org.apache.hadoop.yarn.sls.TaskContainerDefinition;
import org.apache.hadoop.yarn.sls.scheduler.ContainerSimulator;

public class AMDefinitionRumen
extends AMDefinition {
    public static final int DEFAULT_MAPPER_PRIORITY = 20;
    private static final int DEFAULT_REDUCER_PRIORITY = 10;

    public AMDefinitionRumen(AMDefinition.AmDefinitionBuilder builder) {
        super(builder);
    }

    public static List<ContainerSimulator> getTaskContainers(LoggedJob job, SLSRunner slsRunner) throws YarnException {
        TaskContainerDefinition containerDef;
        LoggedTaskAttempt taskAttempt;
        ArrayList<ContainerSimulator> containerList = new ArrayList<ContainerSimulator>();
        TaskContainerDefinition.Builder builder = TaskContainerDefinition.Builder.create().withCount(1).withResource(slsRunner.getDefaultContainerResource()).withExecutionType(ExecutionType.GUARANTEED).withAllocationId(-1L).withRequestDelay(0L);
        for (LoggedTask mapTask : job.getMapTasks()) {
            if (mapTask.getAttempts().size() == 0) {
                throw new YarnException("Invalid map task, no attempt for a mapper!");
            }
            taskAttempt = (LoggedTaskAttempt)mapTask.getAttempts().get(mapTask.getAttempts().size() - 1);
            containerDef = builder.withHostname(taskAttempt.getHostName().getValue()).withDuration(taskAttempt.getFinishTime() - taskAttempt.getStartTime()).withPriority(20).withType("map").build();
            containerList.add(ContainerSimulator.createFromTaskContainerDefinition(containerDef));
        }
        for (LoggedTask reduceTask : job.getReduceTasks()) {
            if (reduceTask.getAttempts().size() == 0) {
                throw new YarnException("Invalid reduce task, no attempt for a reducer!");
            }
            taskAttempt = (LoggedTaskAttempt)reduceTask.getAttempts().get(reduceTask.getAttempts().size() - 1);
            containerDef = builder.withHostname(taskAttempt.getHostName().getValue()).withDuration(taskAttempt.getFinishTime() - taskAttempt.getStartTime()).withPriority(10).withType("reduce").build();
            containerList.add(ContainerSimulator.createFromTaskContainerDefinition(containerDef));
        }
        return containerList;
    }

    public static final class Builder
    extends AMDefinition.AmDefinitionBuilder {
        private long baselineTimeMs;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder withAmType(String amType) {
            this.amType = amType;
            return this;
        }

        public Builder withUser(UserName user) {
            if (user != null) {
                this.user = user.getValue();
            }
            return this;
        }

        public Builder withQueue(String queue) {
            this.queue = queue;
            return this;
        }

        public Builder withJobId(String oldJobId) {
            this.jobId = oldJobId;
            return this;
        }

        public Builder withJobStartTime(long time) {
            this.jobStartTime = time;
            return this;
        }

        public Builder withJobFinishTime(long time) {
            this.jobFinishTime = time;
            return this;
        }

        public Builder withBaseLineTimeMs(long baselineTimeMs) {
            this.baselineTimeMs = baselineTimeMs;
            return this;
        }

        public Builder withLabelExpression(String expr) {
            this.labelExpression = expr;
            return this;
        }

        public Builder withTaskContainers(List<ContainerSimulator> taskContainers) {
            this.taskContainers = taskContainers;
            return this;
        }

        public Builder withAmResource(Resource amResource) {
            this.amResource = amResource;
            return this;
        }

        public AMDefinitionRumen build() {
            AMDefinitionRumen amDef = new AMDefinitionRumen(this);
            if (this.baselineTimeMs == 0L) {
                this.baselineTimeMs = this.jobStartTime;
            }
            AMDefinitionFactory.adjustTimeValuesToBaselineTime(amDef, this, this.baselineTimeMs);
            return amDef;
        }
    }
}

