/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotManager;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestSnapshotManager {
    private static final int testMaxSnapshotIDLimit = 7;

    @Test(timeout=10000L)
    public void testSnapshotIDLimits() throws Exception {
        this.testMaxSnapshotLimit(7, "rollover", new Configuration(), 7);
    }

    @Test(timeout=10000L)
    public void testMaxSnapshotLimit() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.namenode.snapshot.filesystem.limit", 7);
        conf.setInt("dfs.namenode.snapshot.max.limit", 7);
        this.testMaxSnapshotLimit(7, "file system snapshot limit", conf, 14);
    }

    private void testMaxSnapshotLimit(int maxSnapshotLimit, String errMsg, Configuration conf, int maxSnapID) throws IOException {
        LeaseManager leaseManager = (LeaseManager)Mockito.mock(LeaseManager.class);
        INodeDirectory ids = (INodeDirectory)Mockito.mock(INodeDirectory.class);
        FSDirectory fsdir = (FSDirectory)Mockito.mock(FSDirectory.class);
        INodesInPath iip = (INodesInPath)Mockito.mock(INodesInPath.class);
        SnapshotManager sm = (SnapshotManager)Mockito.spy((Object)new SnapshotManager(conf, fsdir));
        ((SnapshotManager)Mockito.doReturn((Object)ids).when((Object)sm)).getSnapshottableRoot((INodesInPath)ArgumentMatchers.any());
        ((SnapshotManager)Mockito.doReturn((Object)maxSnapID).when((Object)sm)).getMaxSnapshotID();
        ((FSDirectory)Mockito.doReturn((Object)true).when((Object)fsdir)).isImageLoaded();
        Integer i = 0;
        while (i < maxSnapshotLimit) {
            sm.createSnapshot(leaseManager, iip, "dummy", i.toString(), Time.now());
            i = i + 1;
        }
        try {
            sm.createSnapshot(leaseManager, iip, "dummy", "shouldFailSnapshot", Time.now());
            Assert.fail((String)"Expected SnapshotException not thrown");
        }
        catch (SnapshotException se) {
            Assert.assertTrue((boolean)StringUtils.toLowerCase((String)se.getMessage()).contains(errMsg));
        }
        sm.deleteSnapshot(iip, "", (INode.ReclaimContext)Mockito.mock(INode.ReclaimContext.class), Time.now());
        try {
            sm.createSnapshot(leaseManager, iip, "dummy", "shouldFailSnapshot2", Time.now());
            if (maxSnapID < maxSnapshotLimit) {
                Assert.fail((String)"CreateSnapshot should succeed");
            }
        }
        catch (SnapshotException se) {
            Assert.assertTrue((boolean)StringUtils.toLowerCase((String)se.getMessage()).contains(errMsg));
        }
    }

    @Test
    public void testValidateSnapshotIDWidth() throws Exception {
        FSDirectory fsdir = (FSDirectory)Mockito.mock(FSDirectory.class);
        SnapshotManager snapshotManager = new SnapshotManager(new Configuration(), fsdir);
        Assert.assertTrue((snapshotManager.getMaxSnapshotID() < 0x7FFFFFFE ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnapshotLimitOnRestart() throws Exception {
        Configuration conf = new Configuration();
        Path snapshottableDir = new Path("/" + this.getClass().getSimpleName());
        int numSnapshots = 5;
        conf.setInt("dfs.namenode.snapshot.max.limit", numSnapshots);
        conf.setInt("dfs.namenode.snapshot.filesystem.limit", numSnapshots * 2);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            hdfs.mkdirs(snapshottableDir);
            hdfs.allowSnapshot(snapshottableDir);
            for (int i = 0; i < numSnapshots; ++i) {
                hdfs.createSnapshot(snapshottableDir, "s" + i);
            }
            LambdaTestUtils.intercept(SnapshotException.class, (String)"snapshot limit", () -> hdfs.createSnapshot(snapshottableDir, "s5"));
            cluster.getNameNode().getConf().setInt("dfs.namenode.snapshot.max.limit", 2);
            cluster.restartNameNodes();
            SnapshotManager snapshotManager = cluster.getNamesystem().getSnapshotManager();
            Assert.assertEquals((long)numSnapshots, (long)snapshotManager.getNumSnapshots());
            Assert.assertEquals((long)2L, (long)snapshotManager.getMaxSnapshotLimit());
            LambdaTestUtils.intercept(SnapshotException.class, (String)"snapshot limit", () -> hdfs.createSnapshot(snapshottableDir, "s5"));
            cluster.getNameNode().getConf().setInt("dfs.namenode.snapshot.filesystem.limit", 2);
            cluster.restartNameNodes();
            snapshotManager = cluster.getNamesystem().getSnapshotManager();
            Assert.assertEquals((long)numSnapshots, (long)snapshotManager.getNumSnapshots());
            Assert.assertEquals((long)2L, (long)snapshotManager.getMaxSnapshotLimit());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

